/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.testing;

import android.content.Context;
import android.os.Bundle;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.ViewModelStore;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavDestination;
import androidx.navigation.NavViewModelStoreProvider;
import androidx.navigation.NavigatorState;
import androidx.navigation.testing.TestNavigatorState;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000M\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000*\u0001\u000f\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\tH\u0016J\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\tJ\"\u0010 \u001a\u00020\u00162\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\"2\b\b\u0002\u0010\u001a\u001a\u00020\nH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006#"}, d2={"Landroidx/navigation/testing/TestNavigatorState;", "Landroidx/navigation/NavigatorState;", "context", "Landroid/content/Context;", "coroutineDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Landroid/content/Context;Lkotlinx/coroutines/CoroutineDispatcher;)V", "entrySavedState", "", "Landroidx/navigation/NavBackStackEntry;", "", "savedStates", "", "Landroid/os/Bundle;", "viewModelStoreProvider", "androidx/navigation/testing/TestNavigatorState$viewModelStoreProvider$1", "Landroidx/navigation/testing/TestNavigatorState$viewModelStoreProvider$1;", "createBackStackEntry", "destination", "Landroidx/navigation/NavDestination;", "arguments", "markTransitionComplete", "", "entry", "pop", "popUpTo", "saveState", "popWithTransition", "push", "backStackEntry", "restoreBackStackEntry", "previouslySavedEntry", "updateMaxLifecycle", "poppedList", "", "navigation-testing_release"})
public final class TestNavigatorState
extends NavigatorState {
    @Nullable
    private final Context context;
    @NotNull
    private final CoroutineDispatcher coroutineDispatcher;
    @NotNull
    private final viewModelStoreProvider.1 viewModelStoreProvider;
    @NotNull
    private final Map<String, Bundle> savedStates;
    @NotNull
    private final Map<NavBackStackEntry, Boolean> entrySavedState;

    @JvmOverloads
    public TestNavigatorState(@Nullable Context context, @NotNull CoroutineDispatcher coroutineDispatcher) {
        Intrinsics.checkNotNullParameter((Object)coroutineDispatcher, (String)"coroutineDispatcher");
        this.context = context;
        this.coroutineDispatcher = coroutineDispatcher;
        this.viewModelStoreProvider = new NavViewModelStoreProvider(){
            @NotNull
            private final Map<String, ViewModelStore> viewModelStores;
            {
                this.viewModelStores = new LinkedHashMap<K, V>();
            }

            @NotNull
            public ViewModelStore getViewModelStore(@NotNull String backStackEntryId) {
                ViewModelStore viewModelStore;
                Intrinsics.checkNotNullParameter((Object)backStackEntryId, (String)"backStackEntryId");
                Map<String, ViewModelStore> $this$getOrPut$iv = this.viewModelStores;
                boolean $i$f$getOrPut = false;
                ViewModelStore value$iv = $this$getOrPut$iv.get(backStackEntryId);
                if (value$iv == null) {
                    boolean bl = false;
                    ViewModelStore answer$iv = new ViewModelStore();
                    $this$getOrPut$iv.put(backStackEntryId, answer$iv);
                    viewModelStore = answer$iv;
                } else {
                    viewModelStore = value$iv;
                }
                return viewModelStore;
            }
        };
        this.savedStates = new LinkedHashMap();
        this.entrySavedState = new LinkedHashMap();
    }

    public /* synthetic */ TestNavigatorState(Context context, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            context = null;
        }
        if ((n & 2) != 0) {
            coroutineDispatcher = (CoroutineDispatcher)Dispatchers.getMain().getImmediate();
        }
        this(context, coroutineDispatcher);
    }

    @NotNull
    public NavBackStackEntry createBackStackEntry(@NotNull NavDestination destination, @Nullable Bundle arguments) {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        return NavBackStackEntry.Companion.create$default((NavBackStackEntry.Companion)NavBackStackEntry.Companion, (Context)this.context, (NavDestination)destination, (Bundle)arguments, (Lifecycle.State)Lifecycle.State.RESUMED, (NavViewModelStoreProvider)this.viewModelStoreProvider, null, null, (int)96, null);
    }

    @NotNull
    public final NavBackStackEntry restoreBackStackEntry(@NotNull NavBackStackEntry previouslySavedEntry) {
        Intrinsics.checkNotNullParameter((Object)previouslySavedEntry, (String)"previouslySavedEntry");
        Bundle bundle = this.savedStates.get(previouslySavedEntry.getId());
        if (bundle == null) {
            boolean bl = false;
            String string = "restoreBackStackEntry(previouslySavedEntry) must be passed a NavBackStackEntry that was previously popped with popBackStack(previouslySavedEntry, true)";
            throw new IllegalStateException(string.toString());
        }
        Bundle savedState = bundle;
        return NavBackStackEntry.Companion.create(this.context, previouslySavedEntry.getDestination(), previouslySavedEntry.getArguments(), Lifecycle.State.RESUMED, (NavViewModelStoreProvider)this.viewModelStoreProvider, previouslySavedEntry.getId(), savedState);
    }

    public void push(@NotNull NavBackStackEntry backStackEntry) {
        Intrinsics.checkNotNullParameter((Object)backStackEntry, (String)"backStackEntry");
        super.push(backStackEntry);
        TestNavigatorState.updateMaxLifecycle$default(this, null, false, 3, null);
    }

    public void pop(@NotNull NavBackStackEntry popUpTo, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
        List beforePopList = (List)this.getBackStack().getValue();
        List<NavBackStackEntry> poppedList = beforePopList.subList(beforePopList.indexOf(popUpTo), beforePopList.size());
        super.pop(popUpTo, saveState);
        this.updateMaxLifecycle(poppedList, saveState);
    }

    public void popWithTransition(@NotNull NavBackStackEntry popUpTo, boolean saveState) {
        Intrinsics.checkNotNullParameter((Object)popUpTo, (String)"popUpTo");
        super.popWithTransition(popUpTo, saveState);
        Map<NavBackStackEntry, Boolean> map = this.entrySavedState;
        Boolean bl = saveState;
        map.put(popUpTo, bl);
    }

    public void markTransitionComplete(@NotNull NavBackStackEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        boolean savedState = Intrinsics.areEqual((Object)this.entrySavedState.get(entry), (Object)true);
        super.markTransitionComplete(entry);
        this.entrySavedState.remove(entry);
        if (!((List)this.getBackStack().getValue()).contains(entry)) {
            this.updateMaxLifecycle(CollectionsKt.listOf((Object)entry), savedState);
        } else {
            TestNavigatorState.updateMaxLifecycle$default(this, null, false, 3, null);
        }
    }

    private final void updateMaxLifecycle(List<NavBackStackEntry> poppedList, boolean saveState) {
        BuildersKt.runBlocking((CoroutineContext)((CoroutineContext)this.coroutineDispatcher), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(poppedList, saveState, this, null){
            int label;
            final /* synthetic */ List<NavBackStackEntry> $poppedList;
            final /* synthetic */ boolean $saveState;
            final /* synthetic */ TestNavigatorState this$0;
            {
                this.$poppedList = $poppedList;
                this.$saveState = $saveState;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getMain().getImmediate()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$poppedList, this.$saveState, this.this$0, null){
                            int label;
                            final /* synthetic */ List<NavBackStackEntry> $poppedList;
                            final /* synthetic */ boolean $saveState;
                            final /* synthetic */ TestNavigatorState this$0;
                            {
                                this.$poppedList = $poppedList;
                                this.$saveState = $saveState;
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        for (NavBackStackEntry entry : CollectionsKt.reversed((Iterable)this.$poppedList)) {
                                            boolean transitioning;
                                            if (this.$saveState && entry.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED)) {
                                                entry.setMaxLifecycle(Lifecycle.State.CREATED);
                                                Bundle savedState = new Bundle();
                                                entry.saveState(savedState);
                                                Map map = TestNavigatorState.access$getSavedStates$p(this.this$0);
                                                String string = entry.getId();
                                                map.put(string, savedState);
                                            }
                                            if (!(transitioning = ((Set)this.this$0.getTransitionsInProgress().getValue()).contains(entry))) {
                                                entry.setMaxLifecycle(Lifecycle.State.DESTROYED);
                                                if (this.$saveState) continue;
                                                TestNavigatorState.access$getSavedStates$p(this.this$0).remove(entry.getId());
                                                TestNavigatorState.access$getViewModelStoreProvider$p(this.this$0).getViewModelStore(entry.getId()).clear();
                                                continue;
                                            }
                                            entry.setMaxLifecycle(Lifecycle.State.CREATED);
                                        }
                                        List currentList = (List)this.this$0.getBackStack().getValue();
                                        NavBackStackEntry previousEntry = null;
                                        for (NavBackStackEntry entry : CollectionsKt.reversed((Iterable)currentList)) {
                                            boolean transitioning = ((Set)this.this$0.getTransitionsInProgress().getValue()).contains(entry);
                                            entry.setMaxLifecycle(previousEntry == null ? (!transitioning ? Lifecycle.State.RESUMED : Lifecycle.State.STARTED) : (previousEntry.getDestination() instanceof FloatingWindow ? Lifecycle.State.STARTED : Lifecycle.State.CREATED));
                                            previousEntry = entry;
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    static /* synthetic */ void updateMaxLifecycle$default(TestNavigatorState testNavigatorState, List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        testNavigatorState.updateMaxLifecycle(list, bl);
    }

    @JvmOverloads
    public TestNavigatorState(@Nullable Context context) {
        this(context, null, 2, null);
    }

    @JvmOverloads
    public TestNavigatorState() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ Map access$getSavedStates$p(TestNavigatorState $this) {
        return $this.savedStates;
    }

    public static final /* synthetic */ viewModelStoreProvider.1 access$getViewModelStoreProvider$p(TestNavigatorState $this) {
        return $this.viewModelStoreProvider;
    }
}

