/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.ActionBarDrawerToggle;
import androidx.appcompat.app.AppCompatActivity;
import androidx.navigation.ui.AbstractAppBarOnDestinationChangedListener;
import androidx.navigation.ui.AppBarConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Landroidx/navigation/ui/ActionBarOnDestinationChangedListener;", "Landroidx/navigation/ui/AbstractAppBarOnDestinationChangedListener;", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "configuration", "Landroidx/navigation/ui/AppBarConfiguration;", "(Landroidx/appcompat/app/AppCompatActivity;Landroidx/navigation/ui/AppBarConfiguration;)V", "setNavigationIcon", "", "icon", "Landroid/graphics/drawable/Drawable;", "contentDescription", "", "setTitle", "title", "", "navigation-ui_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class ActionBarOnDestinationChangedListener
extends AbstractAppBarOnDestinationChangedListener {
    @NotNull
    private final AppCompatActivity activity;

    public ActionBarOnDestinationChangedListener(@NotNull AppCompatActivity activity, @NotNull AppBarConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        ActionBarOnDestinationChangedListener actionBarOnDestinationChangedListener = this;
        ActionBarDrawerToggle.Delegate delegate = activity.getDrawerToggleDelegate();
        boolean bl = false;
        boolean bl2 = false;
        if (delegate == null) {
            ActionBarOnDestinationChangedListener actionBarOnDestinationChangedListener2 = actionBarOnDestinationChangedListener;
            boolean bl3 = false;
            String string2 = "Activity " + activity + " does not have an DrawerToggleDelegate set";
            ActionBarOnDestinationChangedListener actionBarOnDestinationChangedListener3 = actionBarOnDestinationChangedListener2;
            String string3 = string2;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        Context context = delegate.getActionBarThemedContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"checkNotNull(activity.dr\u2026 }.actionBarThemedContext");
        super(context, configuration);
        this.activity = activity;
    }

    @Override
    protected void setTitle(@Nullable CharSequence title) {
        ActionBar actionBar;
        ActionBar actionBar2 = this.activity.getSupportActionBar();
        boolean bl = false;
        boolean bl2 = false;
        if (actionBar2 == null) {
            boolean bl3 = false;
            String string2 = "Activity " + this.activity + " does not have an ActionBar set via setSupportActionBar()";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ActionBar actionBar3 = actionBar = actionBar2;
        actionBar3.setTitle(title);
    }

    @Override
    protected void setNavigationIcon(@Nullable Drawable icon, @StringRes int contentDescription) {
        ActionBar actionBar;
        ActionBar actionBar2 = this.activity.getSupportActionBar();
        boolean bl = false;
        boolean bl2 = false;
        if (actionBar2 == null) {
            boolean bl3 = false;
            String string2 = "Activity " + this.activity + " does not have an ActionBar set via setSupportActionBar()";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ActionBar actionBar3 = actionBar = actionBar2;
        actionBar3.setDisplayHomeAsUpEnabled(icon != null);
        ActionBarDrawerToggle.Delegate delegate = this.activity.getDrawerToggleDelegate();
        bl2 = false;
        boolean bl4 = false;
        if (delegate == null) {
            boolean bl5 = false;
            String string3 = "Activity " + this.activity + " does not have an DrawerToggleDelegate set";
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        ActionBar delegate2 = actionBar2 = delegate;
        delegate2.setActionBarUpIndicator(icon, contentDescription);
    }
}

