/*
 * Decompiled with CFR 0.152.
 */
package androidx.navigation.ui;

import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import androidx.annotation.StringRes;
import androidx.appcompat.graphics.drawable.DrawerArrowDrawable;
import androidx.customview.widget.Openable;
import androidx.navigation.FloatingWindow;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.ui.AppBarConfiguration;
import androidx.navigation.ui.NavigationUI;
import androidx.navigation.ui.R;
import java.lang.ref.WeakReference;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\b \u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u001c\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\b\b\u0001\u0010 \u001a\u00020\u0011H$J\u0012\u0010!\u001a\u00020\u00132\b\u0010\"\u001a\u0004\u0018\u00010#H$R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/navigation/ui/AbstractAppBarOnDestinationChangedListener;", "Landroidx/navigation/NavController$OnDestinationChangedListener;", "context", "Landroid/content/Context;", "configuration", "Landroidx/navigation/ui/AppBarConfiguration;", "(Landroid/content/Context;Landroidx/navigation/ui/AppBarConfiguration;)V", "animator", "Landroid/animation/ValueAnimator;", "arrowDrawable", "Landroidx/appcompat/graphics/drawable/DrawerArrowDrawable;", "openableLayoutWeakReference", "Ljava/lang/ref/WeakReference;", "Landroidx/customview/widget/Openable;", "kotlin.jvm.PlatformType", "topLevelDestinations", "", "", "onDestinationChanged", "", "controller", "Landroidx/navigation/NavController;", "destination", "Landroidx/navigation/NavDestination;", "arguments", "Landroid/os/Bundle;", "setActionBarUpIndicator", "showAsDrawerIndicator", "", "setNavigationIcon", "icon", "Landroid/graphics/drawable/Drawable;", "contentDescription", "setTitle", "title", "", "navigation-ui_release"})
public abstract class AbstractAppBarOnDestinationChangedListener
implements NavController.OnDestinationChangedListener {
    @NotNull
    private final Context context;
    @NotNull
    private final Set<Integer> topLevelDestinations;
    @Nullable
    private final WeakReference<Openable> openableLayoutWeakReference;
    @Nullable
    private DrawerArrowDrawable arrowDrawable;
    @Nullable
    private ValueAnimator animator;

    /*
     * WARNING - void declaration
     */
    public AbstractAppBarOnDestinationChangedListener(@NotNull Context context, @NotNull AppBarConfiguration configuration) {
        WeakReference<void> weakReference;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.context = context;
        this.topLevelDestinations = configuration.getTopLevelDestinations();
        AbstractAppBarOnDestinationChangedListener abstractAppBarOnDestinationChangedListener = this;
        Openable openable = configuration.getOpenableLayout();
        if (openable == null) {
            weakReference = null;
        } else {
            void $this$openableLayoutWeakReference_u24lambda_u2d0;
            Openable openable2 = openable;
            AbstractAppBarOnDestinationChangedListener abstractAppBarOnDestinationChangedListener2 = abstractAppBarOnDestinationChangedListener;
            boolean bl = false;
            weakReference = new WeakReference<void>($this$openableLayoutWeakReference_u24lambda_u2d0);
            abstractAppBarOnDestinationChangedListener = abstractAppBarOnDestinationChangedListener2;
        }
        abstractAppBarOnDestinationChangedListener.openableLayoutWeakReference = weakReference;
    }

    protected abstract void setTitle(@Nullable CharSequence var1);

    protected abstract void setNavigationIcon(@Nullable Drawable var1, @StringRes int var2);

    public void onDestinationChanged(@NotNull NavController controller, @NotNull NavDestination destination, @Nullable Bundle arguments) {
        Openable openableLayout;
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        if (destination instanceof FloatingWindow) {
            return;
        }
        WeakReference<Openable> weakReference = this.openableLayoutWeakReference;
        Openable openable = openableLayout = weakReference == null ? null : (Openable)weakReference.get();
        if (this.openableLayoutWeakReference != null && openableLayout == null) {
            controller.removeOnDestinationChangedListener((NavController.OnDestinationChangedListener)this);
            return;
        }
        CharSequence label = destination.getLabel();
        if (label != null) {
            StringBuffer title = new StringBuffer();
            Pattern fillInPattern = Pattern.compile("\\{(.+?)\\}");
            Matcher matcher = fillInPattern.matcher(label);
            while (matcher.find()) {
                String argName = matcher.group(1);
                if (arguments != null && arguments.containsKey(argName)) {
                    matcher.appendReplacement(title, "");
                    title.append(String.valueOf(arguments.get(argName)));
                    continue;
                }
                throw new IllegalArgumentException("Could not find \"" + argName + "\" in " + arguments + " to fill label \"" + label + '\"');
            }
            matcher.appendTail(title);
            this.setTitle(title);
        }
        boolean isTopLevelDestination = NavigationUI.matchDestinations$navigation_ui_release(destination, this.topLevelDestinations);
        if (openableLayout == null && isTopLevelDestination) {
            this.setNavigationIcon(null, 0);
        } else {
            this.setActionBarUpIndicator(openableLayout != null && isTopLevelDestination);
        }
    }

    @SuppressLint(value={"ObjectAnimatorBinding"})
    private final void setActionBarUpIndicator(boolean showAsDrawerIndicator) {
        float endValue;
        Pair pair;
        Pair pair2;
        DrawerArrowDrawable drawerArrowDrawable = this.arrowDrawable;
        if (drawerArrowDrawable == null) {
            pair2 = null;
        } else {
            DrawerArrowDrawable $this$setActionBarUpIndicator_u24lambda_u2d1 = drawerArrowDrawable;
            boolean bl = false;
            pair2 = TuplesKt.to((Object)$this$setActionBarUpIndicator_u24lambda_u2d1, (Object)true);
        }
        Pair pair3 = pair2;
        if (pair3 == null) {
            DrawerArrowDrawable drawerArrowDrawable2;
            DrawerArrowDrawable it = drawerArrowDrawable2 = new DrawerArrowDrawable(this.context);
            boolean bl = false;
            this.arrowDrawable = it;
            pair = TuplesKt.to((Object)drawerArrowDrawable2, (Object)false);
        } else {
            pair = pair3;
        }
        Pair pair4 = pair;
        DrawerArrowDrawable arrow = (DrawerArrowDrawable)pair4.component1();
        boolean animate = (Boolean)pair4.component2();
        this.setNavigationIcon((Drawable)arrow, showAsDrawerIndicator ? R.string.nav_app_bar_open_drawer_description : R.string.nav_app_bar_navigate_up_description);
        float f = endValue = showAsDrawerIndicator ? 0.0f : 1.0f;
        if (animate) {
            float startValue = arrow.getProgress();
            ValueAnimator valueAnimator = this.animator;
            if (valueAnimator != null) {
                valueAnimator.cancel();
            }
            float[] fArray = new float[]{startValue, endValue};
            ValueAnimator valueAnimator2 = this.animator = (ValueAnimator)ObjectAnimator.ofFloat((Object)arrow, (String)"progress", (float[])fArray);
            if (valueAnimator2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.animation.ObjectAnimator");
            }
            ((ObjectAnimator)valueAnimator2).start();
        } else {
            arrow.setProgress(endValue);
        }
    }
}

