/*
 * Decompiled with CFR 0.152.
 */
package androidx.paging;

import androidx.annotation.RestrictTo;
import androidx.paging.PlaceholderPaddedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0005\u0004\u0005\u0006\u0007\bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0003\u0082\u0001\u0005\t\n\u000b\f\r\u00a8\u0006\u000e"}, d2={"Landroidx/paging/PagingDataEvent;", "T", "", "()V", "Append", "DropAppend", "DropPrepend", "Prepend", "Refresh", "Landroidx/paging/PagingDataEvent$Append;", "Landroidx/paging/PagingDataEvent$DropAppend;", "Landroidx/paging/PagingDataEvent$DropPrepend;", "Landroidx/paging/PagingDataEvent$Prepend;", "Landroidx/paging/PagingDataEvent$Refresh;", "paging-common_release"})
public abstract class PagingDataEvent<T> {
    private PagingDataEvent() {
    }

    public /* synthetic */ PagingDataEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B-\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0017"}, d2={"Landroidx/paging/PagingDataEvent$Append;", "T", "", "Landroidx/paging/PagingDataEvent;", "startIndex", "", "inserted", "", "newPlaceholdersAfter", "oldPlaceholdersAfter", "(ILjava/util/List;II)V", "getInserted", "()Ljava/util/List;", "getNewPlaceholdersAfter", "()I", "getOldPlaceholdersAfter", "getStartIndex", "equals", "", "other", "hashCode", "toString", "", "paging-common_release"})
    public static final class Append<T>
    extends PagingDataEvent<T> {
        private final int startIndex;
        @NotNull
        private final List<T> inserted;
        private final int newPlaceholdersAfter;
        private final int oldPlaceholdersAfter;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Append(int startIndex, @NotNull List<? extends T> inserted, int newPlaceholdersAfter, int oldPlaceholdersAfter) {
            Intrinsics.checkNotNullParameter(inserted, (String)"inserted");
            super(null);
            this.startIndex = startIndex;
            this.inserted = inserted;
            this.newPlaceholdersAfter = newPlaceholdersAfter;
            this.oldPlaceholdersAfter = oldPlaceholdersAfter;
        }

        public final int getStartIndex() {
            return this.startIndex;
        }

        @NotNull
        public final List<T> getInserted() {
            return this.inserted;
        }

        public final int getNewPlaceholdersAfter() {
            return this.newPlaceholdersAfter;
        }

        public final int getOldPlaceholdersAfter() {
            return this.oldPlaceholdersAfter;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Append && this.startIndex == ((Append)other).startIndex && Intrinsics.areEqual(this.inserted, ((Append)other).inserted) && this.newPlaceholdersAfter == ((Append)other).newPlaceholdersAfter && this.oldPlaceholdersAfter == ((Append)other).oldPlaceholdersAfter;
        }

        public int hashCode() {
            return Integer.hashCode(this.startIndex) + ((Object)this.inserted).hashCode() + Integer.hashCode(this.newPlaceholdersAfter) + Integer.hashCode(this.oldPlaceholdersAfter);
        }

        @NotNull
        public String toString() {
            return StringsKt.trimMargin$default((String)("PagingDataEvent.Append loaded " + this.inserted.size() + " items (\n                    |   startIndex: " + this.startIndex + "\n                    |   first item: " + CollectionsKt.firstOrNull(this.inserted) + "\n                    |   last item: " + CollectionsKt.lastOrNull(this.inserted) + "\n                    |   newPlaceholdersBefore: " + this.newPlaceholdersAfter + "\n                    |   oldPlaceholdersBefore: " + this.oldPlaceholdersAfter + "\n                    |)\n                    |"), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B'\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0015"}, d2={"Landroidx/paging/PagingDataEvent$DropAppend;", "T", "", "Landroidx/paging/PagingDataEvent;", "startIndex", "", "dropCount", "newPlaceholdersAfter", "oldPlaceholdersAfter", "(IIII)V", "getDropCount", "()I", "getNewPlaceholdersAfter", "getOldPlaceholdersAfter", "getStartIndex", "equals", "", "other", "hashCode", "toString", "", "paging-common_release"})
    public static final class DropAppend<T>
    extends PagingDataEvent<T> {
        private final int startIndex;
        private final int dropCount;
        private final int newPlaceholdersAfter;
        private final int oldPlaceholdersAfter;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public DropAppend(int startIndex, int dropCount, int newPlaceholdersAfter, int oldPlaceholdersAfter) {
            super(null);
            this.startIndex = startIndex;
            this.dropCount = dropCount;
            this.newPlaceholdersAfter = newPlaceholdersAfter;
            this.oldPlaceholdersAfter = oldPlaceholdersAfter;
        }

        public final int getStartIndex() {
            return this.startIndex;
        }

        public final int getDropCount() {
            return this.dropCount;
        }

        public final int getNewPlaceholdersAfter() {
            return this.newPlaceholdersAfter;
        }

        public final int getOldPlaceholdersAfter() {
            return this.oldPlaceholdersAfter;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DropAppend && this.startIndex == ((DropAppend)other).startIndex && this.dropCount == ((DropAppend)other).dropCount && this.newPlaceholdersAfter == ((DropAppend)other).newPlaceholdersAfter && this.oldPlaceholdersAfter == ((DropAppend)other).oldPlaceholdersAfter;
        }

        public int hashCode() {
            return Integer.hashCode(this.startIndex) + Integer.hashCode(this.dropCount) + Integer.hashCode(this.newPlaceholdersAfter) + Integer.hashCode(this.oldPlaceholdersAfter);
        }

        @NotNull
        public String toString() {
            return StringsKt.trimMargin$default((String)("PagingDataEvent.DropAppend dropped " + this.dropCount + " items (\n                    |   startIndex: " + this.startIndex + "\n                    |   dropCount: " + this.dropCount + "\n                    |   newPlaceholdersBefore: " + this.newPlaceholdersAfter + "\n                    |   oldPlaceholdersBefore: " + this.oldPlaceholdersAfter + "\n                    |)\n                    |"), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/paging/PagingDataEvent$DropPrepend;", "T", "", "Landroidx/paging/PagingDataEvent;", "dropCount", "", "newPlaceholdersBefore", "oldPlaceholdersBefore", "(III)V", "getDropCount", "()I", "getNewPlaceholdersBefore", "getOldPlaceholdersBefore", "equals", "", "other", "hashCode", "toString", "", "paging-common_release"})
    public static final class DropPrepend<T>
    extends PagingDataEvent<T> {
        private final int dropCount;
        private final int newPlaceholdersBefore;
        private final int oldPlaceholdersBefore;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public DropPrepend(int dropCount, int newPlaceholdersBefore, int oldPlaceholdersBefore) {
            super(null);
            this.dropCount = dropCount;
            this.newPlaceholdersBefore = newPlaceholdersBefore;
            this.oldPlaceholdersBefore = oldPlaceholdersBefore;
        }

        public final int getDropCount() {
            return this.dropCount;
        }

        public final int getNewPlaceholdersBefore() {
            return this.newPlaceholdersBefore;
        }

        public final int getOldPlaceholdersBefore() {
            return this.oldPlaceholdersBefore;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof DropPrepend && this.dropCount == ((DropPrepend)other).dropCount && this.newPlaceholdersBefore == ((DropPrepend)other).newPlaceholdersBefore && this.oldPlaceholdersBefore == ((DropPrepend)other).oldPlaceholdersBefore;
        }

        public int hashCode() {
            return Integer.hashCode(this.dropCount) + Integer.hashCode(this.newPlaceholdersBefore) + Integer.hashCode(this.oldPlaceholdersBefore);
        }

        @NotNull
        public String toString() {
            return StringsKt.trimMargin$default((String)("PagingDataEvent.DropPrepend dropped " + this.dropCount + " items (\n                    |   dropCount: " + this.dropCount + "\n                    |   newPlaceholdersBefore: " + this.newPlaceholdersBefore + "\n                    |   oldPlaceholdersBefore: " + this.oldPlaceholdersBefore + "\n                    |)\n                    |"), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0015"}, d2={"Landroidx/paging/PagingDataEvent$Prepend;", "T", "", "Landroidx/paging/PagingDataEvent;", "inserted", "", "newPlaceholdersBefore", "", "oldPlaceholdersBefore", "(Ljava/util/List;II)V", "getInserted", "()Ljava/util/List;", "getNewPlaceholdersBefore", "()I", "getOldPlaceholdersBefore", "equals", "", "other", "hashCode", "toString", "", "paging-common_release"})
    public static final class Prepend<T>
    extends PagingDataEvent<T> {
        @NotNull
        private final List<T> inserted;
        private final int newPlaceholdersBefore;
        private final int oldPlaceholdersBefore;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Prepend(@NotNull List<? extends T> inserted, int newPlaceholdersBefore, int oldPlaceholdersBefore) {
            Intrinsics.checkNotNullParameter(inserted, (String)"inserted");
            super(null);
            this.inserted = inserted;
            this.newPlaceholdersBefore = newPlaceholdersBefore;
            this.oldPlaceholdersBefore = oldPlaceholdersBefore;
        }

        @NotNull
        public final List<T> getInserted() {
            return this.inserted;
        }

        public final int getNewPlaceholdersBefore() {
            return this.newPlaceholdersBefore;
        }

        public final int getOldPlaceholdersBefore() {
            return this.oldPlaceholdersBefore;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Prepend && Intrinsics.areEqual(this.inserted, ((Prepend)other).inserted) && this.newPlaceholdersBefore == ((Prepend)other).newPlaceholdersBefore && this.oldPlaceholdersBefore == ((Prepend)other).oldPlaceholdersBefore;
        }

        public int hashCode() {
            return ((Object)this.inserted).hashCode() + Integer.hashCode(this.newPlaceholdersBefore) + Integer.hashCode(this.oldPlaceholdersBefore);
        }

        @NotNull
        public String toString() {
            return StringsKt.trimMargin$default((String)("PagingDataEvent.Prepend loaded " + this.inserted.size() + " items (\n                    |   first item: " + CollectionsKt.firstOrNull(this.inserted) + "\n                    |   last item: " + CollectionsKt.lastOrNull(this.inserted) + "\n                    |   newPlaceholdersBefore: " + this.newPlaceholdersBefore + "\n                    |   oldPlaceholdersBefore: " + this.oldPlaceholdersBefore + "\n                    |)\n                    |"), null, (int)1, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\b\u0007\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0012"}, d2={"Landroidx/paging/PagingDataEvent$Refresh;", "T", "", "Landroidx/paging/PagingDataEvent;", "newList", "Landroidx/paging/PlaceholderPaddedList;", "previousList", "(Landroidx/paging/PlaceholderPaddedList;Landroidx/paging/PlaceholderPaddedList;)V", "getNewList", "()Landroidx/paging/PlaceholderPaddedList;", "getPreviousList", "equals", "", "other", "hashCode", "", "toString", "", "paging-common_release"})
    public static final class Refresh<T>
    extends PagingDataEvent<T> {
        @NotNull
        private final PlaceholderPaddedList<T> newList;
        @NotNull
        private final PlaceholderPaddedList<T> previousList;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Refresh(@NotNull PlaceholderPaddedList<T> newList, @NotNull PlaceholderPaddedList<T> previousList) {
            Intrinsics.checkNotNullParameter(newList, (String)"newList");
            Intrinsics.checkNotNullParameter(previousList, (String)"previousList");
            super(null);
            this.newList = newList;
            this.previousList = previousList;
        }

        @NotNull
        public final PlaceholderPaddedList<T> getNewList() {
            return this.newList;
        }

        @NotNull
        public final PlaceholderPaddedList<T> getPreviousList() {
            return this.previousList;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof Refresh && this.newList.getPlaceholdersBefore() == ((Refresh)other).newList.getPlaceholdersBefore() && this.newList.getPlaceholdersAfter() == ((Refresh)other).newList.getPlaceholdersAfter() && this.newList.getSize() == ((Refresh)other).newList.getSize() && this.newList.getDataCount() == ((Refresh)other).newList.getDataCount() && this.previousList.getPlaceholdersBefore() == ((Refresh)other).previousList.getPlaceholdersBefore() && this.previousList.getPlaceholdersAfter() == ((Refresh)other).previousList.getPlaceholdersAfter() && this.previousList.getSize() == ((Refresh)other).previousList.getSize() && this.previousList.getDataCount() == ((Refresh)other).previousList.getDataCount();
        }

        public int hashCode() {
            return this.newList.hashCode() + this.previousList.hashCode();
        }

        @NotNull
        public String toString() {
            return StringsKt.trimMargin$default((String)("PagingDataEvent.Refresh loaded newList\n                    |   newList (\n                    |       placeholdersBefore: " + this.newList.getPlaceholdersBefore() + "\n                    |       placeholdersAfter: " + this.newList.getPlaceholdersAfter() + "\n                    |       size: " + this.newList.getSize() + "\n                    |       dataCount: " + this.newList.getDataCount() + "\n                    |   )\n                    |   previousList (\n                    |       placeholdersBefore: " + this.previousList.getPlaceholdersBefore() + "\n                    |       placeholdersAfter: " + this.previousList.getPlaceholdersAfter() + "\n                    |       size: " + this.previousList.getSize() + "\n                    |       dataCount: " + this.previousList.getDataCount() + "\n                    |   )\n                    |"), null, (int)1, null);
        }
    }
}

