/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.ItemKeyProvider;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.widget.RecyclerView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@VisibleForTesting(otherwise=3)
public class EventBridge {
    private static final String TAG = "EventsRelays";

    public static <K> void install(@NonNull RecyclerView.Adapter<?> adapter, @NonNull SelectionTracker<K> selectionTracker, @NonNull ItemKeyProvider<K> keyProvider, @NonNull Consumer<Runnable> runner) {
        new TrackerToAdapterBridge<K>(selectionTracker, keyProvider, adapter, runner);
        adapter.registerAdapterDataObserver(selectionTracker.getAdapterDataObserver());
    }

    private EventBridge() {
    }

    private static final class TrackerToAdapterBridge<K>
    extends SelectionTracker.SelectionObserver<K> {
        final RecyclerView.Adapter<?> mAdapter;
        private final ItemKeyProvider<K> mKeyProvider;
        private final Consumer<Runnable> mRunner;

        TrackerToAdapterBridge(@NonNull SelectionTracker<K> selectionTracker, @NonNull ItemKeyProvider<K> keyProvider, @NonNull RecyclerView.Adapter<?> adapter, Consumer<Runnable> runner) {
            selectionTracker.addObserver(this);
            Preconditions.checkArgument((keyProvider != null ? 1 : 0) != 0);
            Preconditions.checkArgument((adapter != null ? 1 : 0) != 0);
            Preconditions.checkArgument((runner != null ? 1 : 0) != 0);
            this.mKeyProvider = keyProvider;
            this.mAdapter = adapter;
            this.mRunner = runner;
        }

        @Override
        public void onItemStateChanged(@NonNull K key, boolean selected) {
            final int position = this.mKeyProvider.getPosition(key);
            if (position < 0) {
                Log.w((String)EventBridge.TAG, (String)("Item change notification received for unknown item: " + key));
                return;
            }
            this.mRunner.accept((Object)new Runnable(){

                @Override
                public void run() {
                    mAdapter.notifyItemChanged(position, (Object)"Selection-Changed");
                }
            });
        }
    }
}

