/*
 * Decompiled with CFR 0.152.
 */
package androidx.recyclerview.selection;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.recyclerview.selection.Selection;
import java.util.ArrayList;

public abstract class StorageStrategy<K> {
    @VisibleForTesting
    static final String SELECTION_ENTRIES = "androidx.recyclerview.selection.entries";
    @VisibleForTesting
    static final String SELECTION_KEY_TYPE = "androidx.recyclerview.selection.type";
    private final Class<K> mType;

    public StorageStrategy(@NonNull Class<K> type) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0);
        this.mType = type;
    }

    @Nullable
    public abstract Selection<K> asSelection(@NonNull Bundle var1);

    @NonNull
    public abstract Bundle asBundle(@NonNull Selection<K> var1);

    String getKeyTypeName() {
        return this.mType.getCanonicalName();
    }

    @NonNull
    public static <K extends Parcelable> StorageStrategy<K> createParcelableStorage(@NonNull Class<K> type) {
        return new ParcelableStorageStrategy<K>(type);
    }

    @NonNull
    public static StorageStrategy<String> createStringStorage() {
        return new StringStorageStrategy();
    }

    @NonNull
    public static StorageStrategy<Long> createLongStorage() {
        return new LongStorageStrategy();
    }

    private static class ParcelableStorageStrategy<K extends Parcelable>
    extends StorageStrategy<K> {
        ParcelableStorageStrategy(@NonNull Class<K> type) {
            super(type);
            Preconditions.checkArgument((boolean)Parcelable.class.isAssignableFrom(type));
        }

        @Override
        @Nullable
        public Selection<K> asSelection(@NonNull Bundle state) {
            String keyType = state.getString(StorageStrategy.SELECTION_KEY_TYPE, null);
            if (keyType == null || !keyType.equals(this.getKeyTypeName())) {
                return null;
            }
            ArrayList stored = state.getParcelableArrayList(StorageStrategy.SELECTION_ENTRIES);
            if (stored == null) {
                return null;
            }
            Selection selection = new Selection();
            selection.mSelection.addAll(stored);
            return selection;
        }

        @Override
        @NonNull
        public Bundle asBundle(@NonNull Selection<K> selection) {
            Bundle bundle = new Bundle();
            bundle.putString(StorageStrategy.SELECTION_KEY_TYPE, this.getKeyTypeName());
            ArrayList value = new ArrayList(selection.size());
            value.addAll(selection.mSelection);
            bundle.putParcelableArrayList(StorageStrategy.SELECTION_ENTRIES, value);
            return bundle;
        }
    }

    private static class LongStorageStrategy
    extends StorageStrategy<Long> {
        LongStorageStrategy() {
            super(Long.class);
        }

        @Override
        @Nullable
        public Selection<Long> asSelection(@NonNull Bundle state) {
            String keyType = state.getString(StorageStrategy.SELECTION_KEY_TYPE, null);
            if (keyType == null || !keyType.equals(this.getKeyTypeName())) {
                return null;
            }
            long[] stored = state.getLongArray(StorageStrategy.SELECTION_ENTRIES);
            if (stored == null) {
                return null;
            }
            Selection<Long> selection = new Selection<Long>();
            for (long key : stored) {
                selection.mSelection.add(key);
            }
            return selection;
        }

        @Override
        @NonNull
        public Bundle asBundle(@NonNull Selection<Long> selection) {
            Bundle bundle = new Bundle();
            bundle.putString(StorageStrategy.SELECTION_KEY_TYPE, this.getKeyTypeName());
            long[] value = new long[selection.size()];
            int i = 0;
            for (Long key : selection) {
                value[i++] = key;
            }
            bundle.putLongArray(StorageStrategy.SELECTION_ENTRIES, value);
            return bundle;
        }
    }

    private static class StringStorageStrategy
    extends StorageStrategy<String> {
        StringStorageStrategy() {
            super(String.class);
        }

        @Override
        @Nullable
        public Selection<String> asSelection(@NonNull Bundle state) {
            String keyType = state.getString(StorageStrategy.SELECTION_KEY_TYPE, null);
            if (keyType == null || !keyType.equals(this.getKeyTypeName())) {
                return null;
            }
            ArrayList stored = state.getStringArrayList(StorageStrategy.SELECTION_ENTRIES);
            if (stored == null) {
                return null;
            }
            Selection<String> selection = new Selection<String>();
            selection.mSelection.addAll(stored);
            return selection;
        }

        @Override
        @NonNull
        public Bundle asBundle(@NonNull Selection<String> selection) {
            Bundle bundle = new Bundle();
            bundle.putString(StorageStrategy.SELECTION_KEY_TYPE, this.getKeyTypeName());
            ArrayList value = new ArrayList(selection.size());
            value.addAll(selection.mSelection);
            bundle.putStringArrayList(StorageStrategy.SELECTION_ENTRIES, value);
            return bundle;
        }
    }
}

