/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing;

import androidx.room.compiler.processing.XMethodElement;
import androidx.room.compiler.processing.XTypeElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0006\u0010\u0012\u001a\u00020\u000eJ\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014J\u0014\u0010\u0015\u001a\u00020\u0016*\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0007H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Landroidx/room/compiler/processing/MethodCollector;", "", "target", "Landroidx/room/compiler/processing/XTypeElement;", "(Landroidx/room/compiler/processing/XTypeElement;)V", "selection", "", "Landroidx/room/compiler/processing/XMethodElement;", "selectionByName", "", "", "getTarget", "()Landroidx/room/compiler/processing/XTypeElement;", "addIfNotOverridden", "", "candidate", "addToSelection", "method", "collect", "getResult", "", "canAccessSuperMethod", "", "other", "room-compiler-processing"})
final class MethodCollector {
    @NotNull
    private final XTypeElement target;
    @NotNull
    private final Map<String, List<XMethodElement>> selectionByName;
    @NotNull
    private final List<XMethodElement> selection;

    public MethodCollector(@NotNull XTypeElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.target = target;
        boolean bl = false;
        this.selectionByName = new LinkedHashMap();
        bl = false;
        this.selection = new ArrayList();
    }

    @NotNull
    public final XTypeElement getTarget() {
        return this.target;
    }

    /*
     * WARNING - void declaration
     */
    public final void collect() {
        Object $this$forEach$iv = this.target.getDeclaredMethods();
        boolean $i$f$forEach22 = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            XMethodElement p0 = (XMethodElement)element$iv;
            boolean bl = false;
            this.addToSelection(p0);
        }
        Unit selection = Unit.INSTANCE;
        Object $i$f$forEach22 = this.target.getSuperType();
        Object object = $this$forEach$iv = $i$f$forEach22 == null ? null : $i$f$forEach22.getTypeElement();
        if ($this$forEach$iv != null && ($i$f$forEach22 = $this$forEach$iv.getAllMethods()) != null) {
            void $this$forEach$iv2;
            iterator = (Iterable)$i$f$forEach22;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                XMethodElement p0 = (XMethodElement)element$iv;
                boolean bl = false;
                this.addIfNotOverridden(p0);
            }
        }
        $this$forEach$iv = this.target.getSuperInterfaceElements();
        boolean $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            XTypeElement it = (XTypeElement)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv3 = it.getAllMethods();
            boolean $i$f$forEach3 = false;
            for (Object element$iv2 : $this$forEach$iv3) {
                XMethodElement it2 = (XMethodElement)element$iv2;
                boolean bl2 = false;
                if (it2.isStatic()) continue;
                this.addIfNotOverridden(it2);
            }
        }
    }

    @NotNull
    public final List<XMethodElement> getResult() {
        return this.selection;
    }

    private final void addIfNotOverridden(XMethodElement candidate) {
        boolean overridden;
        boolean bl;
        if (!this.canAccessSuperMethod(this.target, candidate)) {
            return;
        }
        List<XMethodElement> list = this.selectionByName.get(candidate.getName());
        if (list == null) {
            bl = false;
        } else {
            boolean bl2;
            boolean bl3;
            block7: {
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl3 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        XMethodElement existing = (XMethodElement)element$iv;
                        boolean bl4 = false;
                        if (!existing.overrides(candidate, this.getTarget())) continue;
                        bl3 = true;
                        break block7;
                    }
                    bl3 = false;
                }
            }
            bl = overridden = (bl2 = bl3);
        }
        if (!overridden) {
            this.addToSelection(candidate.copyTo(this.target));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addToSelection(XMethodElement method) {
        Object object;
        void $this$getOrPut$iv;
        Map<String, List<XMethodElement>> map = this.selectionByName;
        String key$iv = method.getName();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            boolean bl2 = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(method);
        this.selection.add(method);
    }

    private final boolean canAccessSuperMethod(XTypeElement $this$canAccessSuperMethod, XMethodElement other) {
        if (other.isPublic() || other.isProtected()) {
            return true;
        }
        if (other.isPrivate()) {
            return false;
        }
        return Intrinsics.areEqual((Object)$this$canAccessSuperMethod.getPackageName(), (Object)other.getEnclosingElement().getClassName().packageName());
    }
}

