/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing;

import androidx.room.compiler.processing.ExperimentalProcessingApi;
import androidx.room.compiler.processing.XArrayType;
import androidx.room.compiler.processing.XFiler;
import androidx.room.compiler.processing.XMessager;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.javac.JavacProcessingEnv;
import androidx.room.compiler.processing.ksp.KspProcessingEnv;
import com.google.devtools.ksp.processing.CodeGenerator;
import com.google.devtools.ksp.processing.KSPLogger;
import com.google.devtools.ksp.processing.Resolver;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\bg\u0018\u0000 *2\u00020\u0001:\u0002)*J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H&J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u0010H&J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u00162\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u0010H&J\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u00142\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0016H&J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J)\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00142\u0012\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\"\"\u00020\u0016H&\u00a2\u0006\u0002\u0010#J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140%2\u0006\u0010&\u001a\u00020\u0010H&J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0014\u0010'\u001a\u00020\u00162\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010(\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0014\u0010(\u001a\u00020\u00142\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006+\u00c0\u0006\u0001"}, d2={"Landroidx/room/compiler/processing/XProcessingEnv;", "", "backend", "Landroidx/room/compiler/processing/XProcessingEnv$Backend;", "getBackend", "()Landroidx/room/compiler/processing/XProcessingEnv$Backend;", "filer", "Landroidx/room/compiler/processing/XFiler;", "getFiler", "()Landroidx/room/compiler/processing/XFiler;", "messager", "Landroidx/room/compiler/processing/XMessager;", "getMessager", "()Landroidx/room/compiler/processing/XMessager;", "options", "", "", "getOptions", "()Ljava/util/Map;", "findGeneratedAnnotation", "Landroidx/room/compiler/processing/XTypeElement;", "findType", "Landroidx/room/compiler/processing/XType;", "typeName", "Lcom/squareup/javapoet/TypeName;", "qName", "klass", "Lkotlin/reflect/KClass;", "findTypeElement", "getArrayType", "Landroidx/room/compiler/processing/XArrayType;", "type", "getDeclaredType", "types", "", "(Landroidx/room/compiler/processing/XTypeElement;[Landroidx/room/compiler/processing/XType;)Landroidx/room/compiler/processing/XType;", "getTypeElementsFromPackage", "", "packageName", "requireType", "requireTypeElement", "Backend", "Companion", "room-compiler-processing"})
@ExperimentalProcessingApi
public interface XProcessingEnv {
    @NotNull
    public static final Companion Companion = androidx.room.compiler.processing.XProcessingEnv$Companion.$$INSTANCE;

    @NotNull
    public Backend getBackend();

    @NotNull
    public XMessager getMessager();

    @NotNull
    public Map<String, String> getOptions();

    @NotNull
    public XFiler getFiler();

    @Nullable
    public XTypeElement findTypeElement(@NotNull String var1);

    @Nullable
    public XType findType(@NotNull String var1);

    @NotNull
    default public XType requireType(@NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        XType xType = this.findType(qName);
        boolean bl = false;
        boolean bl2 = false;
        if (xType == null) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"cannot find required type ", (Object)qName);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return xType;
    }

    @Nullable
    public XTypeElement findGeneratedAnnotation();

    @NotNull
    public XType getDeclaredType(@NotNull XTypeElement var1, XType ... var2);

    @NotNull
    public XArrayType getArrayType(@NotNull XType var1);

    @NotNull
    default public XTypeElement requireTypeElement(@NotNull String qName) {
        Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
        XTypeElement xTypeElement = this.findTypeElement(qName);
        boolean bl = false;
        boolean bl2 = false;
        if (xTypeElement == null) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"Cannot find required type element ", (Object)qName);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return xTypeElement;
    }

    @NotNull
    default public XType requireType(@NotNull TypeName typeName2) {
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        XType xType = this.findType(typeName2);
        boolean bl = false;
        boolean bl2 = false;
        if (xType == null) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"cannot find required type ", (Object)typeName2);
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return xType;
    }

    @NotNull
    default public XType requireType(@NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getCanonicalName();
        Intrinsics.checkNotNull((Object)string);
        return this.requireType(string);
    }

    @Nullable
    default public XType findType(@NotNull TypeName typeName2) {
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        if (typeName2 instanceof ArrayTypeName) {
            XArrayType xArrayType;
            Object object = ((ArrayTypeName)typeName2).componentType;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"typeName.componentType");
            XType xType = this.findType((TypeName)object);
            if (xType == null) {
                xArrayType = null;
            } else {
                object = xType;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                xArrayType = this.getArrayType((XType)it);
            }
            return xArrayType;
        }
        String string = typeName2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName.toString()");
        return this.findType(string);
    }

    @Nullable
    default public XType findType(@NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getCanonicalName();
        Intrinsics.checkNotNull((Object)string);
        return this.findType(string);
    }

    @NotNull
    default public XTypeElement requireTypeElement(@NotNull TypeName typeName2) {
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        String string = typeName2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName.toString()");
        return this.requireTypeElement(string);
    }

    @NotNull
    default public XTypeElement requireTypeElement(@NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getCanonicalName();
        Intrinsics.checkNotNull((Object)string);
        return this.requireTypeElement(string);
    }

    @Nullable
    default public XTypeElement findTypeElement(@NotNull TypeName typeName2) {
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        String string = typeName2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"typeName.toString()");
        return this.findTypeElement(string);
    }

    @Nullable
    default public XTypeElement findTypeElement(@NotNull KClass<?> klass) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String string = JvmClassMappingKt.getJavaClass(klass).getCanonicalName();
        Intrinsics.checkNotNull((Object)string);
        return this.findTypeElement(string);
    }

    @NotNull
    default public XArrayType getArrayType(@NotNull TypeName typeName2) {
        Intrinsics.checkNotNullParameter((Object)typeName2, (String)"typeName");
        return this.getArrayType(this.requireType(typeName2));
    }

    @NotNull
    public List<XTypeElement> getTypeElementsFromPackage(@NotNull String var1);

    @JvmStatic
    @NotNull
    public static XProcessingEnv create(@NotNull ProcessingEnvironment env) {
        return Companion.create(env);
    }

    @JvmStatic
    @NotNull
    public static XProcessingEnv create(@NotNull Map<String, String> options, @NotNull Resolver resolver, @NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger) {
        return Companion.create(options, resolver, codeGenerator, logger);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Landroidx/room/compiler/processing/XProcessingEnv$Backend;", "", "(Ljava/lang/String;I)V", "JAVAC", "KSP", "room-compiler-processing"})
    public static final class Backend
    extends Enum<Backend> {
        public static final /* enum */ Backend JAVAC = new Backend();
        public static final /* enum */ Backend KSP = new Backend();
        private static final /* synthetic */ Backend[] $VALUES;

        public static Backend[] values() {
            Backend[] backendArray = $VALUES;
            return Arrays.copyOf(backendArray, backendArray.length);
        }

        public static Backend valueOf(String value2) {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            return Enum.valueOf(Backend.class, value2);
        }

        static {
            $VALUES = backendArray = new Backend[]{Backend.JAVAC, Backend.KSP};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J4\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Landroidx/room/compiler/processing/XProcessingEnv$Companion;", "", "()V", "create", "Landroidx/room/compiler/processing/XProcessingEnv;", "env", "Ljavax/annotation/processing/ProcessingEnvironment;", "options", "", "", "resolver", "Lcom/google/devtools/ksp/processing/Resolver;", "codeGenerator", "Lcom/google/devtools/ksp/processing/CodeGenerator;", "logger", "Lcom/google/devtools/ksp/processing/KSPLogger;", "room-compiler-processing"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final XProcessingEnv create(@NotNull ProcessingEnvironment env) {
            Intrinsics.checkNotNullParameter((Object)env, (String)"env");
            return new JavacProcessingEnv(env);
        }

        @JvmStatic
        @NotNull
        public final XProcessingEnv create(@NotNull Map<String, String> options, @NotNull Resolver resolver, @NotNull CodeGenerator codeGenerator, @NotNull KSPLogger logger) {
            Intrinsics.checkNotNullParameter(options, (String)"options");
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter((Object)codeGenerator, (String)"codeGenerator");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            return new KspProcessingEnv(options, codeGenerator, logger, resolver);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

