/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.javac;

import androidx.room.compiler.processing.XExecutableParameterElement;
import androidx.room.compiler.processing.javac.JavacExecutableElement;
import androidx.room.compiler.processing.javac.JavacMethodElement;
import androidx.room.compiler.processing.javac.JavacProcessingEnv;
import androidx.room.compiler.processing.javac.JavacTypeElement;
import androidx.room.compiler.processing.javac.JavacVariableElement;
import androidx.room.compiler.processing.javac.kotlin.KmType;
import androidx.room.compiler.processing.javac.kotlin.KmValueParameter;
import androidx.room.compiler.processing.util.NamingUtilsKt;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015\u00a8\u0006\""}, d2={"Landroidx/room/compiler/processing/javac/JavacMethodParameter;", "Landroidx/room/compiler/processing/javac/JavacVariableElement;", "Landroidx/room/compiler/processing/XExecutableParameterElement;", "env", "Landroidx/room/compiler/processing/javac/JavacProcessingEnv;", "executable", "Landroidx/room/compiler/processing/javac/JavacExecutableElement;", "containing", "Landroidx/room/compiler/processing/javac/JavacTypeElement;", "element", "Ljavax/lang/model/element/VariableElement;", "kotlinMetadata", "Landroidx/room/compiler/processing/javac/kotlin/KmValueParameter;", "argIndex", "", "(Landroidx/room/compiler/processing/javac/JavacProcessingEnv;Landroidx/room/compiler/processing/javac/JavacExecutableElement;Landroidx/room/compiler/processing/javac/JavacTypeElement;Ljavax/lang/model/element/VariableElement;Landroidx/room/compiler/processing/javac/kotlin/KmValueParameter;I)V", "getArgIndex", "()I", "fallbackLocationText", "", "getFallbackLocationText", "()Ljava/lang/String;", "hasDefaultValue", "", "getHasDefaultValue", "()Z", "getKotlinMetadata", "()Landroidx/room/compiler/processing/javac/kotlin/KmValueParameter;", "kotlinType", "Landroidx/room/compiler/processing/javac/kotlin/KmType;", "getKotlinType", "()Landroidx/room/compiler/processing/javac/kotlin/KmType;", "name", "getName", "room-compiler-processing"})
public final class JavacMethodParameter
extends JavacVariableElement
implements XExecutableParameterElement {
    @NotNull
    private final JavacExecutableElement executable;
    @Nullable
    private final KmValueParameter kotlinMetadata;
    private final int argIndex;

    public JavacMethodParameter(@NotNull JavacProcessingEnv env, @NotNull JavacExecutableElement executable, @NotNull JavacTypeElement containing, @NotNull VariableElement element, @Nullable KmValueParameter kotlinMetadata2, int argIndex) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(env, containing, element);
        this.executable = executable;
        this.kotlinMetadata = kotlinMetadata2;
        this.argIndex = argIndex;
    }

    @Nullable
    public final KmValueParameter getKotlinMetadata() {
        return this.kotlinMetadata;
    }

    public final int getArgIndex() {
        return this.argIndex;
    }

    @Override
    @NotNull
    public String getName() {
        KmValueParameter kmValueParameter = this.kotlinMetadata;
        String string = kmValueParameter == null ? null : kmValueParameter.getName();
        return NamingUtilsKt.sanitizeAsJavaParameterName(string == null ? super.getName() : string, this.argIndex);
    }

    @Override
    @Nullable
    public KmType getKotlinType() {
        KmValueParameter kmValueParameter = this.kotlinMetadata;
        return kmValueParameter == null ? null : kmValueParameter.getType();
    }

    @Override
    public boolean getHasDefaultValue() {
        boolean bl;
        KmValueParameter kmValueParameter = this.kotlinMetadata;
        return kmValueParameter == null ? false : (bl = kmValueParameter.hasDefault());
    }

    @Override
    @NotNull
    public String getFallbackLocationText() {
        return this.executable instanceof JavacMethodElement && ((JavacMethodElement)this.executable).isSuspendFunction() && this == CollectionsKt.last(this.executable.getParameters()) ? Intrinsics.stringPlus((String)"return type of ", (Object)this.executable.getFallbackLocationText()) : this.getName() + " in " + this.executable.getFallbackLocationText();
    }
}

