/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.compiler.processing.javac;

import androidx.room.compiler.processing.XConstructorElement;
import androidx.room.compiler.processing.XConstructorType;
import androidx.room.compiler.processing.XType;
import androidx.room.compiler.processing.XTypeElement;
import androidx.room.compiler.processing.javac.ElementExtKt;
import androidx.room.compiler.processing.javac.JavacConstructorType;
import androidx.room.compiler.processing.javac.JavacDeclaredType;
import androidx.room.compiler.processing.javac.JavacExecutableElement;
import androidx.room.compiler.processing.javac.JavacMethodParameter;
import androidx.room.compiler.processing.javac.JavacProcessingEnv;
import androidx.room.compiler.processing.javac.JavacTypeElement;
import androidx.room.compiler.processing.javac.kotlin.KmConstructor;
import androidx.room.compiler.processing.javac.kotlin.KmValueParameter;
import androidx.room.compiler.processing.javac.kotlin.KotlinMetadataElement;
import com.google.auto.common.MoreTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\"H\u0016R\u001b\u0010\n\u001a\u00020\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\u00118VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000f\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0015\u001a\u0004\u0018\u00010\u00168VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u000f\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000f\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006#"}, d2={"Landroidx/room/compiler/processing/javac/JavacConstructorElement;", "Landroidx/room/compiler/processing/javac/JavacExecutableElement;", "Landroidx/room/compiler/processing/XConstructorElement;", "env", "Landroidx/room/compiler/processing/javac/JavacProcessingEnv;", "containing", "Landroidx/room/compiler/processing/javac/JavacTypeElement;", "element", "Ljavax/lang/model/element/ExecutableElement;", "(Landroidx/room/compiler/processing/javac/JavacProcessingEnv;Landroidx/room/compiler/processing/javac/JavacTypeElement;Ljavax/lang/model/element/ExecutableElement;)V", "enclosingElement", "Landroidx/room/compiler/processing/XTypeElement;", "getEnclosingElement", "()Landroidx/room/compiler/processing/XTypeElement;", "enclosingElement$delegate", "Lkotlin/Lazy;", "executableType", "Landroidx/room/compiler/processing/XConstructorType;", "getExecutableType", "()Landroidx/room/compiler/processing/XConstructorType;", "executableType$delegate", "kotlinMetadata", "Landroidx/room/compiler/processing/javac/kotlin/KmConstructor;", "getKotlinMetadata", "()Landroidx/room/compiler/processing/javac/kotlin/KmConstructor;", "kotlinMetadata$delegate", "parameters", "", "Landroidx/room/compiler/processing/javac/JavacMethodParameter;", "getParameters", "()Ljava/util/List;", "parameters$delegate", "asMemberOf", "other", "Landroidx/room/compiler/processing/XType;", "room-compiler-processing"})
public final class JavacConstructorElement
extends JavacExecutableElement
implements XConstructorElement {
    @NotNull
    private final Lazy enclosingElement$delegate;
    @NotNull
    private final Lazy parameters$delegate;
    @NotNull
    private final Lazy executableType$delegate;
    @NotNull
    private final Lazy kotlinMetadata$delegate;

    public JavacConstructorElement(@NotNull JavacProcessingEnv env, @NotNull JavacTypeElement containing, @NotNull ExecutableElement element) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)containing, (String)"containing");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(env, containing, element);
        if (!(element.getKind() == ElementKind.CONSTRUCTOR)) {
            boolean bl = false;
            String string = Intrinsics.stringPlus((String)"Constructor element is constructed with invalid type: ", (Object)element);
            throw new IllegalStateException(string.toString());
        }
        this.enclosingElement$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JavacTypeElement>(element, env){
            final /* synthetic */ ExecutableElement $element;
            final /* synthetic */ JavacProcessingEnv $env;
            {
                this.$element = $element;
                this.$env = $env;
                super(0);
            }

            @NotNull
            public final JavacTypeElement invoke() {
                return ElementExtKt.requireEnclosingType(this.$element, this.$env);
            }
        }));
        this.parameters$delegate = LazyKt.lazy((Function0)((Function0)new Function0<List<? extends JavacMethodParameter>>(element, env, this, containing){
            final /* synthetic */ ExecutableElement $element;
            final /* synthetic */ JavacProcessingEnv $env;
            final /* synthetic */ JavacConstructorElement this$0;
            final /* synthetic */ JavacTypeElement $containing;
            {
                this.$element = $element;
                this.$env = $env;
                this.this$0 = $receiver;
                this.$containing = $containing;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<JavacMethodParameter> invoke() {
                void $this$mapIndexedTo$iv$iv;
                void $this$mapIndexed$iv;
                Iterable<VariableElement> iterable = this.$element.getParameters();
                Intrinsics.checkNotNullExpressionValue(iterable, (String)"element.parameters");
                iterable = iterable;
                JavacProcessingEnv javacProcessingEnv = this.$env;
                JavacConstructorElement javacConstructorElement = this.this$0;
                JavacTypeElement javacTypeElement = this.$containing;
                boolean $i$f$mapIndexed = false;
                void var6_6 = $this$mapIndexed$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
                boolean $i$f$mapIndexedTo = false;
                int index$iv$iv = 0;
                for (T item$iv$iv : $this$mapIndexedTo$iv$iv) {
                    void index;
                    void variable;
                    int n = index$iv$iv;
                    index$iv$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    VariableElement variableElement = (VariableElement)item$iv$iv;
                    int n2 = n;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    JavacExecutableElement javacExecutableElement = javacConstructorElement;
                    Intrinsics.checkNotNullExpressionValue((Object)variable, (String)"variable");
                    collection.add(new JavacMethodParameter(javacProcessingEnv, javacExecutableElement, javacTypeElement, (VariableElement)variable, (Function0<KmValueParameter>)((Function0)new Function0<KmValueParameter>(javacConstructorElement, (int)index){
                        final /* synthetic */ JavacConstructorElement this$0;
                        final /* synthetic */ int $index;
                        {
                            this.this$0 = $receiver;
                            this.$index = $index;
                            super(0);
                        }

                        @Nullable
                        public final KmValueParameter invoke() {
                            KmValueParameter kmValueParameter;
                            KmConstructor kmConstructor = this.this$0.getKotlinMetadata();
                            if (kmConstructor == null) {
                                kmValueParameter = null;
                            } else {
                                List<KmValueParameter> list = kmConstructor.getParameters();
                                kmValueParameter = list == null ? null : (KmValueParameter)CollectionsKt.getOrNull(list, (int)this.$index);
                            }
                            return kmValueParameter;
                        }
                    }), (int)index));
                }
                return (List)destination$iv$iv;
            }
        }));
        this.executableType$delegate = LazyKt.lazy((Function0)((Function0)new Function0<JavacConstructorType>(env, containing, element, this){
            final /* synthetic */ JavacProcessingEnv $env;
            final /* synthetic */ JavacTypeElement $containing;
            final /* synthetic */ ExecutableElement $element;
            final /* synthetic */ JavacConstructorElement this$0;
            {
                this.$env = $env;
                this.$containing = $containing;
                this.$element = $element;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final JavacConstructorType invoke() {
                TypeMirror asMemberOf = this.$env.getTypeUtils().asMemberOf(this.$containing.getType().getTypeMirror(), this.$element);
                ExecutableType executableType2 = MoreTypes.asExecutable((TypeMirror)asMemberOf);
                Intrinsics.checkNotNullExpressionValue((Object)executableType2, (String)"asExecutable(asMemberOf)");
                return new JavacConstructorType(this.$env, this.this$0, executableType2);
            }
        }));
        this.kotlinMetadata$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KmConstructor>(this, element){
            final /* synthetic */ JavacConstructorElement this$0;
            final /* synthetic */ ExecutableElement $element;
            {
                this.this$0 = $receiver;
                this.$element = $element;
                super(0);
            }

            @Nullable
            public final KmConstructor invoke() {
                KmConstructor kmConstructor;
                XTypeElement xTypeElement = this.this$0.getEnclosingElement();
                JavacTypeElement javacTypeElement = xTypeElement instanceof JavacTypeElement ? (JavacTypeElement)xTypeElement : null;
                if (javacTypeElement == null) {
                    kmConstructor = null;
                } else {
                    KotlinMetadataElement kotlinMetadataElement = javacTypeElement.getKotlinMetadata();
                    kmConstructor = kotlinMetadataElement == null ? null : kotlinMetadataElement.getConstructorMetadata(this.$element);
                }
                return kmConstructor;
            }
        }));
    }

    @Override
    @NotNull
    public XTypeElement getEnclosingElement() {
        Lazy lazy = this.enclosingElement$delegate;
        return (XTypeElement)lazy.getValue();
    }

    @Override
    @NotNull
    public List<JavacMethodParameter> getParameters() {
        Lazy lazy = this.parameters$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public XConstructorType getExecutableType() {
        Lazy lazy = this.executableType$delegate;
        return (XConstructorType)lazy.getValue();
    }

    @Override
    @NotNull
    public XConstructorType asMemberOf(@NotNull XType other) {
        XConstructorType xConstructorType;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!(other instanceof JavacDeclaredType) || this.getContaining().getType().isSameType(other)) {
            xConstructorType = this.getExecutableType();
        } else {
            TypeMirror asMemberOf = this.getEnv().getTypeUtils().asMemberOf(((JavacDeclaredType)other).getTypeMirror(), this.getElement());
            JavacProcessingEnv javacProcessingEnv = this.getEnv();
            ExecutableType executableType2 = MoreTypes.asExecutable((TypeMirror)asMemberOf);
            Intrinsics.checkNotNullExpressionValue((Object)executableType2, (String)"asExecutable(asMemberOf)");
            xConstructorType = new JavacConstructorType(javacProcessingEnv, this, executableType2);
        }
        return xConstructorType;
    }

    @Override
    @Nullable
    public KmConstructor getKotlinMetadata() {
        Lazy lazy = this.kotlinMetadata$delegate;
        return (KmConstructor)lazy.getValue();
    }
}

