/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.parser;

import androidx.room.jarjarred.org.antlr.v4.runtime.RuleContext;
import androidx.room.jarjarred.org.antlr.v4.runtime.tree.ParseTree;
import androidx.room.jarjarred.org.antlr.v4.runtime.tree.TerminalNode;
import androidx.room.parser.BindParameterNode;
import androidx.room.parser.ParsedQuery;
import androidx.room.parser.QueryType;
import androidx.room.parser.SQLiteBaseVisitor;
import androidx.room.parser.SQLiteParser;
import androidx.room.parser.Table;
import androidx.room.parser.expansion.ExpandableSqlParserKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 &2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001&B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020\u001fH\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u001a\u001a\u00020%H\u0016R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Landroidx/room/parser/QueryVisitor;", "Landroidx/room/parser/SQLiteBaseVisitor;", "Ljava/lang/Void;", "original", "", "syntaxErrors", "", "statement", "Landroidx/room/jarjarred/org/antlr/v4/runtime/tree/ParseTree;", "(Ljava/lang/String;Ljava/util/List;Lorg/antlr/v4/runtime/tree/ParseTree;)V", "bindingExpressions", "Ljava/util/ArrayList;", "Landroidx/room/parser/BindParameterNode;", "Lkotlin/collections/ArrayList;", "foundTopLevelStarProjection", "", "queryType", "Landroidx/room/parser/QueryType;", "tableNames", "", "Landroidx/room/parser/Table;", "withClauseNames", "createParsedQuery", "Landroidx/room/parser/ParsedQuery;", "findQueryType", "isFixedParamFunctionExpr", "ctx", "Landroidx/room/parser/SQLiteParser$Comma_separated_exprContext;", "unescapeIdentifier", "text", "visitCommon_table_expression", "Landroidx/room/parser/SQLiteParser$Common_table_expressionContext;", "visitExpr", "Landroidx/room/parser/SQLiteParser$ExprContext;", "visitResult_column", "Landroidx/room/parser/SQLiteParser$Result_columnContext;", "visitTable_or_subquery", "Landroidx/room/parser/SQLiteParser$Table_or_subqueryContext;", "Companion", "room-compiler"})
public final class QueryVisitor
extends SQLiteBaseVisitor<Void> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String original;
    @NotNull
    private final List<String> syntaxErrors;
    @NotNull
    private final ArrayList<BindParameterNode> bindingExpressions;
    @NotNull
    private final Set<Table> tableNames;
    @NotNull
    private final Set<String> withClauseNames;
    @NotNull
    private final QueryType queryType;
    private boolean foundTopLevelStarProjection;
    @NotNull
    private static final List<String> ESCAPE_LITERALS;
    @NotNull
    private static final Set<String> fixedParamFunctions;

    /*
     * WARNING - void declaration
     */
    public QueryVisitor(@NotNull String original, @NotNull List<String> syntaxErrors, @NotNull ParseTree statement) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Collection<QueryType> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter(syntaxErrors, (String)"syntaxErrors");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        this.original = original;
        this.syntaxErrors = syntaxErrors;
        boolean bl = false;
        this.bindingExpressions = new ArrayList();
        bl = false;
        this.tableNames = new LinkedHashSet();
        bl = false;
        this.withClauseNames = new LinkedHashSet();
        Iterable iterable = (Iterable)RangesKt.until((int)0, (int)statement.getChildCount());
        QueryVisitor queryVisitor = this;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl2 = false;
            ParseTree parseTree = statement.getChild((int)it);
            Intrinsics.checkNotNullExpressionValue((Object)parseTree, (String)"statement.getChild(it)");
            QueryType queryType = this.findQueryType(parseTree);
            collection.add(queryType);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$filterNot = false;
        $this$mapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            QueryType it = (QueryType)((Object)element$iv$iv);
            boolean bl3 = false;
            if (it == QueryType.UNKNOWN) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        collection = (List)destination$iv$iv;
        QueryType queryType = (QueryType)((Object)CollectionsKt.firstOrNull(collection));
        queryVisitor.queryType = queryType == null ? QueryType.UNKNOWN : queryType;
        statement.accept(this);
    }

    private final QueryType findQueryType(ParseTree statement) {
        String string;
        ParseTree parseTree = statement;
        QueryType queryType = parseTree instanceof SQLiteParser.Select_stmtContext ? QueryType.SELECT : ((parseTree instanceof SQLiteParser.Delete_stmt_limitedContext ? true : parseTree instanceof SQLiteParser.Delete_stmtContext) ? QueryType.DELETE : (parseTree instanceof SQLiteParser.Insert_stmtContext ? QueryType.INSERT : ((parseTree instanceof SQLiteParser.Update_stmtContext ? true : parseTree instanceof SQLiteParser.Update_stmt_limitedContext) ? QueryType.UPDATE : (parseTree instanceof TerminalNode ? (Intrinsics.areEqual((Object)(string = ((TerminalNode)statement).getText()), (Object)"EXPLAIN") ? QueryType.EXPLAIN : QueryType.UNKNOWN) : QueryType.UNKNOWN))));
        return queryType;
    }

    @Override
    @Nullable
    public Void visitExpr(@NotNull SQLiteParser.ExprContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        TerminalNode bindParameter = ctx.BIND_PARAMETER();
        if (bindParameter != null) {
            RuleContext parentContext = ctx.parent;
            boolean isMultiple = parentContext instanceof SQLiteParser.Comma_separated_exprContext && !this.isFixedParamFunctionExpr((SQLiteParser.Comma_separated_exprContext)parentContext);
            this.bindingExpressions.add(new BindParameterNode(bindParameter, isMultiple));
        }
        return (Void)super.visitExpr(ctx);
    }

    @Override
    @Nullable
    public Void visitResult_column(@NotNull SQLiteParser.Result_columnContext ctx) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Object object = ctx.parent;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.parent");
                if (ExpandableSqlParserKt.isCoreSelect((RuleContext)object) && Intrinsics.areEqual((Object)ctx.getText(), (Object)"*")) break block2;
                object = ctx.getText();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ctx.text");
                if (!StringsKt.endsWith$default((String)object, (String)".*", (boolean)false, (int)2, null)) break block3;
            }
            this.foundTopLevelStarProjection = true;
        }
        return (Void)super.visitResult_column(ctx);
    }

    private final boolean isFixedParamFunctionExpr(SQLiteParser.Comma_separated_exprContext ctx) {
        if (ctx.parent instanceof SQLiteParser.ExprContext) {
            RuleContext ruleContext = ctx.parent;
            if (ruleContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type androidx.room.parser.SQLiteParser.ExprContext");
            }
            SQLiteParser.ExprContext parentExpr = (SQLiteParser.ExprContext)ruleContext;
            Object object = parentExpr.function_name();
            if (object == null) {
                return false;
            }
            SQLiteParser.Function_nameContext functionName = object;
            object = functionName.getText();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functionName.text");
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
            boolean bl = false;
            String string = ((String)object).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            return fixedParamFunctions.contains(string);
        }
        return false;
    }

    @NotNull
    public final ParsedQuery createParsedQuery() {
        Iterable $this$sortedBy$iv = this.bindingExpressions;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return new ParsedQuery(this.original, this.queryType, CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                BindParameterNode it = (BindParameterNode)a;
                boolean bl2 = false;
                it = (BindParameterNode)b;
                Comparable comparable = Integer.valueOf(it.getSourceInterval().a);
                bl2 = false;
                Integer n = it.getSourceInterval().a;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        }), this.tableNames, this.queryType == QueryType.SELECT ? Boolean.valueOf(this.foundTopLevelStarProjection) : null, this.syntaxErrors);
    }

    @Override
    @Nullable
    public Void visitCommon_table_expression(@NotNull SQLiteParser.Common_table_expressionContext ctx) {
        String tableName;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        SQLiteParser.Table_nameContext table_nameContext = ctx.table_name();
        String string = tableName = table_nameContext == null ? null : table_nameContext.getText();
        if (tableName != null) {
            this.withClauseNames.add(this.unescapeIdentifier(tableName));
        }
        return (Void)super.visitCommon_table_expression(ctx);
    }

    @Override
    @Nullable
    public Void visitTable_or_subquery(@NotNull SQLiteParser.Table_or_subqueryContext ctx) {
        String tableName;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        SQLiteParser.Table_nameContext table_nameContext = ctx.table_name();
        String string = tableName = table_nameContext == null ? null : table_nameContext.getText();
        if (tableName != null) {
            String tableAlias;
            Object object = ctx.table_alias();
            String string2 = tableAlias = object == null ? null : ((RuleContext)object).getText();
            if (!this.withClauseNames.contains(tableName)) {
                this.tableNames.add(new Table(this.unescapeIdentifier(tableName), this.unescapeIdentifier((String)((object = tableAlias) == null ? tableName : object))));
            }
        }
        return (Void)super.visitTable_or_subquery(ctx);
    }

    private final String unescapeIdentifier(String text) {
        String string = text;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String trimmed = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Iterable $this$forEach$iv = ESCAPE_LITERALS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)trimmed, (String)it, (boolean)false, (int)2, null)) continue;
            String string3 = trimmed;
            int n = 1;
            int n2 = trimmed.length() - 1;
            boolean bl3 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            return this.unescapeIdentifier(string5);
        }
        return trimmed;
    }

    static {
        Object[] objectArray = new String[]{"\"", "'", "`"};
        ESCAPE_LITERALS = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"abs", "glob", "hex", "ifnull", "iif", "instr", "length", "like", "likelihood", "likely", "load_extension", "lower", "ltrim", "nullif", "quote", "randomblob", "replace", "round", "rtrim", "soundex", "sqlite_compileoption_get", "sqlite_compileoption_used", "sqlite_offset", "substr", "trim", "typeof", "unicode", "unlikely", "upper", "zeroblob"};
        fixedParamFunctions = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Landroidx/room/parser/QueryVisitor$Companion;", "", "()V", "ESCAPE_LITERALS", "", "", "fixedParamFunctions", "", "getFixedParamFunctions", "()Ljava/util/Set;", "room-compiler"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getFixedParamFunctions() {
            return fixedParamFunctions;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

