/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.writer;

import androidx.annotation.VisibleForTesting;
import androidx.room.ext.Javapoet_extKt;
import androidx.room.ext.RoomTypeNames;
import androidx.room.ext.SupportDbTypeNames;
import androidx.room.solver.CodeGenScope;
import androidx.room.vo.Database;
import androidx.room.vo.DatabaseView;
import androidx.room.vo.Entity;
import androidx.room.vo.FtsEntity;
import androidx.room.vo.Pojo;
import androidx.room.writer.FtsTableInfoValidationWriter;
import androidx.room.writer.TableInfoValidationWriter;
import androidx.room.writer.ValidationWriter;
import androidx.room.writer.ViewInfoValidationWriter;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.Modifier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\u0015\u001a\u00020\bH\u0002J\b\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u001b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\"\u001a\u00020\u001e*\u00020#2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\rH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Landroidx/room/writer/SQLiteOpenHelperWriter;", "", "database", "Landroidx/room/vo/Database;", "(Landroidx/room/vo/Database;)V", "getDatabase", "()Landroidx/room/vo/Database;", "createCreateAllTables", "Lcom/squareup/javapoet/MethodSpec;", "createDropAllTables", "scope", "Landroidx/room/solver/CodeGenScope;", "createDropTableQuery", "", "entity", "Landroidx/room/vo/Entity;", "createDropViewQuery", "view", "Landroidx/room/vo/DatabaseView;", "createOnCreate", "createOnOpen", "createOnPostMigrate", "createOnPreMigrate", "createOpenCallback", "Lcom/squareup/javapoet/TypeSpec;", "createTableQuery", "createValidateMigration", "", "createViewQuery", "write", "", "outVar", "configuration", "Lcom/squareup/javapoet/ParameterSpec;", "invokeCallbacks", "Lcom/squareup/javapoet/MethodSpec$Builder;", "methodName", "room-compiler"})
public final class SQLiteOpenHelperWriter {
    @NotNull
    private final Database database;

    public SQLiteOpenHelperWriter(@NotNull Database database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.database = database;
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    public final void write(@NotNull String outVar, @NotNull ParameterSpec configuration, @NotNull CodeGenScope scope) {
        Intrinsics.checkNotNullParameter((Object)outVar, (String)"outVar");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        CodeBlock.Builder builder = scope.builder();
        boolean bl = false;
        boolean bl2 = false;
        CodeBlock.Builder $this$write_u24lambda_u2d0 = builder;
        boolean bl3 = false;
        String sqliteConfigVar = scope.getTmpVar("_sqliteConfig");
        String callbackVar = scope.getTmpVar("_openCallback");
        Object[] objectArray = new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CALLBACK(), callbackVar, RoomTypeNames.INSTANCE.getOPEN_HELPER(), configuration, this.createOpenCallback(scope), this.getDatabase().getIdentityHash(), this.getDatabase().getLegacyIdentityHash()};
        $this$write_u24lambda_u2d0.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = new " + Javapoet_extKt.getT() + '(' + Javapoet_extKt.getN() + ", " + Javapoet_extKt.getL() + ", " + Javapoet_extKt.getS() + ", " + Javapoet_extKt.getS() + ')', objectArray);
        objectArray = new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), sqliteConfigVar, SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER_CONFIG(), configuration, configuration, callbackVar};
        $this$write_u24lambda_u2d0.addStatement(StringsKt.trimIndent((String)("\n                    final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL() + " = " + Javapoet_extKt.getT() + ".builder(" + Javapoet_extKt.getN() + ".context)\n                    .name(" + Javapoet_extKt.getN() + ".name)\n                    .callback(" + Javapoet_extKt.getL() + ")\n                    .build()\n                ")), objectArray);
        objectArray = new Object[]{SupportDbTypeNames.INSTANCE.getSQLITE_OPEN_HELPER(), outVar, configuration, sqliteConfigVar};
        $this$write_u24lambda_u2d0.addStatement("final " + Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getN() + " = " + Javapoet_extKt.getN() + ".sqliteOpenHelperFactory.create(" + Javapoet_extKt.getL() + ')', objectArray);
    }

    private final TypeSpec createOpenCallback(CodeGenScope scope) {
        Object[] objectArray = new Object[]{this.database.getVersion()};
        objectArray = TypeSpec.anonymousClassBuilder((String)Javapoet_extKt.getL(), (Object[])objectArray);
        boolean bl = false;
        boolean bl2 = false;
        Object[] $this$createOpenCallback_u24lambda_u2d1 = objectArray;
        boolean bl3 = false;
        $this$createOpenCallback_u24lambda_u2d1.superclass((TypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_DELEGATE());
        $this$createOpenCallback_u24lambda_u2d1.addMethod(this.createCreateAllTables());
        $this$createOpenCallback_u24lambda_u2d1.addMethod(this.createDropAllTables(scope.fork()));
        $this$createOpenCallback_u24lambda_u2d1.addMethod(this.createOnCreate(scope.fork()));
        $this$createOpenCallback_u24lambda_u2d1.addMethod(this.createOnOpen(scope.fork()));
        $this$createOpenCallback_u24lambda_u2d1.addMethod(this.createOnPreMigrate());
        $this$createOpenCallback_u24lambda_u2d1.addMethod(this.createOnPostMigrate());
        $this$createOpenCallback_u24lambda_u2d1.addMethods((Iterable)this.createValidateMigration(scope.fork()));
        TypeSpec typeSpec = objectArray.build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSpec, (String)"anonymousClassBuilder(L,\u2026ork()))\n        }.build()");
        return typeSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MethodSpec> createValidateMigration(CodeGenScope scope) {
        MethodSpec.Builder builder;
        List list;
        Object[] objectArray;
        boolean bl = false;
        List methodSpecs = new ArrayList();
        ArrayDeque entities = new ArrayDeque(this.database.getEntities());
        ArrayDeque views = new ArrayDeque(this.database.getViews());
        ParameterSpec dbParam = ParameterSpec.builder((TypeName)((TypeName)SupportDbTypeNames.INSTANCE.getDB()), (String)"_db", (Modifier[])new Modifier[0]).build();
        while (!entities.isEmpty() || !views.isEmpty()) {
            CodeGenScope methodScope;
            int statementCount;
            ValidationWriter validationWriter;
            void $this$createValidateMigration_u24lambda_u2d2;
            Modifier[] modifierArray;
            boolean isPrimaryMethod = methodSpecs.isEmpty();
            String methodName2 = isPrimaryMethod ? "onValidateSchema" : Intrinsics.stringPlus((String)"onValidateSchema", (Object)(methodSpecs.size() + 1));
            Object[] objectArray2 = MethodSpec.methodBuilder((String)methodName2);
            boolean bl2 = false;
            boolean bl3 = false;
            objectArray = objectArray2;
            list = methodSpecs;
            boolean bl4 = false;
            if (isPrimaryMethod) {
                modifierArray = new Modifier[]{Modifier.PROTECTED};
                $this$createValidateMigration_u24lambda_u2d2.addModifiers(modifierArray);
                $this$createValidateMigration_u24lambda_u2d2.addAnnotation(Override.class);
            } else {
                modifierArray = new Modifier[]{Modifier.PRIVATE};
                $this$createValidateMigration_u24lambda_u2d2.addModifiers(modifierArray);
            }
            $this$createValidateMigration_u24lambda_u2d2.returns((TypeName)RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT());
            $this$createValidateMigration_u24lambda_u2d2.addParameter(dbParam);
            for (statementCount = 0; !entities.isEmpty() && statementCount < 1000; statementCount += validationWriter.statementCount()) {
                ValidationWriter validationWriter2;
                methodScope = scope.fork();
                Entity entity = (Entity)entities.poll();
                Entity entity2 = entity;
                if (entity2 instanceof FtsEntity) {
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
                    validationWriter2 = new FtsTableInfoValidationWriter((FtsEntity)entity);
                } else {
                    Intrinsics.checkNotNullExpressionValue((Object)entity, (String)"entity");
                    validationWriter2 = new TableInfoValidationWriter(entity);
                }
                validationWriter = validationWriter2;
                Intrinsics.checkNotNullExpressionValue((Object)dbParam, (String)"dbParam");
                validationWriter.write(dbParam, methodScope);
                $this$createValidateMigration_u24lambda_u2d2.addCode(methodScope.builder().build());
            }
            while (!views.isEmpty() && statementCount < 1000) {
                methodScope = scope.fork();
                DatabaseView view = (DatabaseView)views.poll();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
                validationWriter = new ViewInfoValidationWriter(view);
                Intrinsics.checkNotNullExpressionValue((Object)dbParam, (String)"dbParam");
                validationWriter.write(dbParam, methodScope);
                $this$createValidateMigration_u24lambda_u2d2.addCode(methodScope.builder().build());
                statementCount += validationWriter.statementCount();
            }
            if (!isPrimaryMethod) {
                Object[] objectArray3 = new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()};
                $this$createValidateMigration_u24lambda_u2d2.addStatement("return new " + Javapoet_extKt.getT() + "(true, null)", objectArray3);
            }
            Unit unit = Unit.INSTANCE;
            MethodSpec methodSpec = objectArray2.build();
            Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(methodName\u2026                }.build()");
            list.add(methodSpec);
        }
        if (methodSpecs.size() > 1) {
            void $this$createValidateMigration_u24lambda_u2d4;
            builder = ((MethodSpec)methodSpecs.get(0)).toBuilder();
            boolean bl5 = false;
            boolean bl6 = false;
            MethodSpec.Builder builder2 = builder;
            int n = 0;
            list = methodSpecs;
            boolean bl7 = false;
            String resultVar = scope.getTmpVar("_result");
            Object[] bl4 = new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT(), resultVar};
            $this$createValidateMigration_u24lambda_u2d4.addStatement(Javapoet_extKt.getT() + ' ' + Javapoet_extKt.getL(), bl4);
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)methodSpecs, (int)1);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MethodSpec it = (MethodSpec)element$iv;
                boolean bl8 = false;
                Object[] objectArray4 = new Object[]{resultVar, dbParam};
                $this$createValidateMigration_u24lambda_u2d4.addStatement(Javapoet_extKt.getL() + " = " + it.name + '(' + Javapoet_extKt.getN() + ')', objectArray4);
                objectArray4 = new Object[]{resultVar};
                $this$createValidateMigration_u24lambda_u2d4.beginControlFlow("if (!" + Javapoet_extKt.getL() + ".isValid)", objectArray4);
                objectArray4 = new Object[]{resultVar};
                $this$createValidateMigration_u24lambda_u2d4.addStatement(Intrinsics.stringPlus((String)"return ", (Object)Javapoet_extKt.getL()), objectArray4);
                $this$createValidateMigration_u24lambda_u2d4.endControlFlow();
            }
            Object[] objectArray5 = new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()};
            $this$createValidateMigration_u24lambda_u2d4.addStatement("return new " + Javapoet_extKt.getT() + "(true, null)", objectArray5);
            Unit unit = Unit.INSTANCE;
            MethodSpec methodSpec = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodSpecs[0].toBuilder\u2026  )\n            }.build()");
            list.set(n, methodSpec);
        } else if (methodSpecs.size() == 1) {
            void $this$createValidateMigration_u24lambda_u2d5;
            builder = ((MethodSpec)methodSpecs.get(0)).toBuilder();
            boolean bl9 = false;
            boolean bl10 = false;
            MethodSpec.Builder $this$createValidateMigration_u24lambda_u2d4 = builder;
            int n = 0;
            list = methodSpecs;
            boolean bl11 = false;
            objectArray = new Object[]{RoomTypeNames.INSTANCE.getOPEN_HELPER_VALIDATION_RESULT()};
            $this$createValidateMigration_u24lambda_u2d5.addStatement("return new " + Javapoet_extKt.getT() + "(true, null)", objectArray);
            Unit unit = Unit.INSTANCE;
            MethodSpec methodSpec = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodSpecs[0].toBuilder\u2026  )\n            }.build()");
            list.set(n, methodSpec);
        }
        return methodSpecs;
    }

    private final MethodSpec createOnCreate(CodeGenScope scope) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onCreate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createOnCreate_u24lambda_u2d6 = builder;
        boolean bl3 = false;
        Modifier[] modifierArray = new Modifier[]{Modifier.PROTECTED};
        $this$createOnCreate_u24lambda_u2d6.addModifiers(modifierArray);
        $this$createOnCreate_u24lambda_u2d6.addAnnotation(Override.class);
        $this$createOnCreate_u24lambda_u2d6.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createOnCreate_u24lambda_u2d6, (String)"");
        this.invokeCallbacks($this$createOnCreate_u24lambda_u2d6, scope, "onCreate");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"onCreate\"\u2026reate\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnOpen(CodeGenScope scope) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onOpen");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createOnOpen_u24lambda_u2d7 = builder;
        boolean bl3 = false;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$createOnOpen_u24lambda_u2d7.addModifiers(objectArray);
        $this$createOnOpen_u24lambda_u2d7.addAnnotation(Override.class);
        $this$createOnOpen_u24lambda_u2d7.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        $this$createOnOpen_u24lambda_u2d7.addStatement("mDatabase = _db", new Object[0]);
        if (this.getDatabase().getEnableForeignKeys()) {
            objectArray = new Object[]{"PRAGMA foreign_keys = ON"};
            $this$createOnOpen_u24lambda_u2d7.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', objectArray);
        }
        $this$createOnOpen_u24lambda_u2d7.addStatement("internalInitInvalidationTracker(_db)", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)$this$createOnOpen_u24lambda_u2d7, (String)"");
        this.invokeCallbacks($this$createOnOpen_u24lambda_u2d7, scope, "onOpen");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"onOpen\").\u2026nOpen\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createCreateAllTables() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"createAllTables");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createCreateAllTables_u24lambda_u2d9 = builder;
        boolean bl3 = false;
        Object object = new Modifier[]{Modifier.PUBLIC};
        $this$createCreateAllTables_u24lambda_u2d9.addModifiers(object);
        $this$createCreateAllTables_u24lambda_u2d9.addAnnotation(Override.class);
        $this$createCreateAllTables_u24lambda_u2d9.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        object = this.getDatabase().getBundle().buildCreateQueries();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"database.bundle.buildCreateQueries()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl4 = false;
            Object[] objectArray = new Object[]{it};
            $this$createCreateAllTables_u24lambda_u2d9.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', objectArray);
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"createAll\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createDropAllTables(CodeGenScope scope) {
        Object[] objectArray;
        Pojo it;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"dropAllTables");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createDropAllTables_u24lambda_u2d12 = builder;
        boolean bl3 = false;
        Modifier[] modifierArray = new Modifier[]{Modifier.PUBLIC};
        $this$createDropAllTables_u24lambda_u2d12.addModifiers(modifierArray);
        $this$createDropAllTables_u24lambda_u2d12.addAnnotation(Override.class);
        $this$createDropAllTables_u24lambda_u2d12.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        Iterable $this$forEach$iv = this.getDatabase().getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Entity)element$iv;
            boolean bl4 = false;
            objectArray = new Object[]{this.createDropTableQuery((Entity)it)};
            $this$createDropAllTables_u24lambda_u2d12.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', objectArray);
        }
        $this$forEach$iv = this.getDatabase().getViews();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (DatabaseView)element$iv;
            boolean bl5 = false;
            objectArray = new Object[]{this.createDropViewQuery((DatabaseView)it)};
            $this$createDropAllTables_u24lambda_u2d12.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', objectArray);
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$createDropAllTables_u24lambda_u2d12, (String)"");
        this.invokeCallbacks($this$createDropAllTables_u24lambda_u2d12, scope, "onDestructiveMigration");
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"dropAllTa\u2026ation\")\n        }.build()");
        return methodSpec;
    }

    private final MethodSpec createOnPreMigrate() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onPreMigrate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createOnPreMigrate_u24lambda_u2d13 = builder;
        boolean bl3 = false;
        Object[] objectArray = new Modifier[]{Modifier.PUBLIC};
        $this$createOnPreMigrate_u24lambda_u2d13.addModifiers(objectArray);
        $this$createOnPreMigrate_u24lambda_u2d13.addAnnotation(Override.class);
        $this$createOnPreMigrate_u24lambda_u2d13.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        objectArray = new Object[]{RoomTypeNames.INSTANCE.getDB_UTIL(), "_db"};
        $this$createOnPreMigrate_u24lambda_u2d13.addStatement(Javapoet_extKt.getT() + ".dropFtsSyncTriggers(" + Javapoet_extKt.getL() + ')', objectArray);
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"onPreMigr\u2026 \"_db\")\n        }.build()");
        return methodSpec;
    }

    /*
     * WARNING - void declaration
     */
    private final MethodSpec createOnPostMigrate() {
        void $this$forEach$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        FtsEntity it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"onPostMigrate");
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$createOnPostMigrate_u24lambda_u2d17 = builder;
        boolean bl3 = false;
        Object object = new Modifier[]{Modifier.PUBLIC};
        $this$createOnPostMigrate_u24lambda_u2d17.addModifiers(object);
        $this$createOnPostMigrate_u24lambda_u2d17.addAnnotation(Override.class);
        $this$createOnPostMigrate_u24lambda_u2d17.addParameter((TypeName)SupportDbTypeNames.INSTANCE.getDB(), "_db", new Modifier[0]);
        object = CollectionsKt.filterIsInstance((Iterable)this.getDatabase().getEntities(), FtsEntity.class);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl4 = false;
            if (!(it.getFtsOptions().getContentEntity() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (FtsEntity)element$iv$iv;
            boolean bl5 = false;
            Iterable list$iv$iv = it.getContentSyncTriggerCreateQueries();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String syncTriggerQuery = (String)element$iv;
            boolean bl6 = false;
            Object[] objectArray = new Object[]{syncTriggerQuery};
            $this$createOnPostMigrate_u24lambda_u2d17.addStatement("_db.execSQL(" + Javapoet_extKt.getS() + ')', objectArray);
        }
        MethodSpec methodSpec = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)methodSpec, (String)"methodBuilder(\"onPostMig\u2026      }\n        }.build()");
        return methodSpec;
    }

    private final void invokeCallbacks(MethodSpec.Builder $this$invokeCallbacks, CodeGenScope scope, String methodName2) {
        String iVar = scope.getTmpVar("_i");
        String sizeVar = scope.getTmpVar("_size");
        MethodSpec.Builder builder = $this$invokeCallbacks.beginControlFlow("if (mCallbacks != null)", new Object[0]);
        boolean bl = false;
        boolean bl2 = false;
        MethodSpec.Builder $this$invokeCallbacks_u24lambda_u2d19 = builder;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{iVar, sizeVar, iVar, sizeVar, iVar};
        objectArray = $this$invokeCallbacks_u24lambda_u2d19.beginControlFlow("for (int " + Javapoet_extKt.getN() + " = 0, " + Javapoet_extKt.getN() + " = mCallbacks.size(); " + Javapoet_extKt.getN() + " < " + Javapoet_extKt.getN() + "; " + Javapoet_extKt.getN() + "++)", objectArray);
        boolean bl4 = false;
        boolean bl5 = false;
        Object[] $this$invokeCallbacks_u24lambda_u2d19_u24lambda_u2d18 = objectArray;
        boolean bl6 = false;
        Object[] objectArray2 = new Object[]{iVar, methodName2};
        $this$invokeCallbacks_u24lambda_u2d19_u24lambda_u2d18.addStatement("mCallbacks.get(" + Javapoet_extKt.getN() + ")." + Javapoet_extKt.getN() + "(_db)", objectArray2);
        $this$invokeCallbacks_u24lambda_u2d19.endControlFlow();
        $this$invokeCallbacks.endControlFlow();
    }

    @VisibleForTesting
    @NotNull
    public final String createTableQuery(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return entity.getCreateTableQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return view.getCreateViewQuery();
    }

    @VisibleForTesting
    @NotNull
    public final String createDropTableQuery(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        return "DROP TABLE IF EXISTS `" + entity.getTableName() + '`';
    }

    @VisibleForTesting
    @NotNull
    public final String createDropViewQuery(@NotNull DatabaseView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return "DROP VIEW IF EXISTS `" + view.getViewName() + '`';
    }
}

