/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.jarjarred.org.antlr.v4.codegen;

import androidx.room.jarjarred.org.antlr.v4.codegen.CodeGenerator;
import androidx.room.jarjarred.org.antlr.v4.runtime.misc.IntervalSet;
import androidx.room.jarjarred.org.antlr.v4.tool.ErrorType;
import androidx.room.jarjarred.org.antlr.v4.tool.Grammar;
import androidx.room.jarjarred.org.antlr.v4.tool.ast.GrammarAST;
import androidx.room.jarjarred.org.stringtemplate.v4.ST;
import androidx.room.jarjarred.org.stringtemplate.v4.gui.STViz;
import java.util.List;

public class CodeGenPipeline {
    Grammar g;

    public CodeGenPipeline(Grammar g) {
        this.g = g;
    }

    public void process() {
        if (!CodeGenerator.targetExists(this.g.getOptionString("language"))) {
            return;
        }
        CodeGenerator gen = new CodeGenerator(this.g);
        IntervalSet idTypes = new IntervalSet(new int[0]);
        idTypes.add(28);
        idTypes.add(57);
        idTypes.add(66);
        List<GrammarAST> idNodes = this.g.ast.getNodesWithType(idTypes);
        for (GrammarAST idNode : idNodes) {
            if (!gen.getTarget().grammarSymbolCausesIssueInGeneratedCode(idNode)) continue;
            this.g.tool.errMgr.grammarError(ErrorType.USE_OF_BAD_WORD, this.g.fileName, idNode.getToken(), idNode.getText());
        }
        int errorCount = this.g.tool.errMgr.getNumErrors();
        if (this.g.isLexer()) {
            ST lexer;
            if (gen.getTarget().needsHeader()) {
                lexer = gen.generateLexer(true);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    this.writeRecognizer(lexer, gen, true);
                }
            }
            lexer = gen.generateLexer(false);
            if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                this.writeRecognizer(lexer, gen, false);
            }
        } else {
            ST parser;
            if (gen.getTarget().needsHeader()) {
                parser = gen.generateParser(true);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    this.writeRecognizer(parser, gen, true);
                }
            }
            parser = gen.generateParser(false);
            if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                this.writeRecognizer(parser, gen, false);
            }
            if (this.g.tool.gen_listener) {
                ST baseListener;
                ST listener;
                if (gen.getTarget().needsHeader()) {
                    listener = gen.generateListener(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeListener(listener, true);
                    }
                }
                listener = gen.generateListener(false);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    gen.writeListener(listener, false);
                }
                if (gen.getTarget().needsHeader()) {
                    baseListener = gen.generateBaseListener(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeBaseListener(baseListener, true);
                    }
                }
                if (gen.getTarget().wantsBaseListener()) {
                    baseListener = gen.generateBaseListener(false);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeBaseListener(baseListener, false);
                    }
                }
            }
            if (this.g.tool.gen_visitor) {
                ST baseVisitor;
                ST visitor;
                if (gen.getTarget().needsHeader()) {
                    visitor = gen.generateVisitor(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeVisitor(visitor, true);
                    }
                }
                visitor = gen.generateVisitor(false);
                if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                    gen.writeVisitor(visitor, false);
                }
                if (gen.getTarget().needsHeader()) {
                    baseVisitor = gen.generateBaseVisitor(true);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeBaseVisitor(baseVisitor, true);
                    }
                }
                if (gen.getTarget().wantsBaseVisitor()) {
                    baseVisitor = gen.generateBaseVisitor(false);
                    if (this.g.tool.errMgr.getNumErrors() == errorCount) {
                        gen.writeBaseVisitor(baseVisitor, false);
                    }
                }
            }
        }
        gen.writeVocabFile();
    }

    protected void writeRecognizer(ST template, CodeGenerator gen, boolean header) {
        if (this.g.tool.launch_ST_inspector) {
            STViz viz = template.inspect();
            if (this.g.tool.ST_inspector_wait_for_close) {
                try {
                    viz.waitForClose();
                }
                catch (InterruptedException ex) {
                    this.g.tool.errMgr.toolError(ErrorType.INTERNAL_ERROR, ex, new Object[0]);
                }
            }
        }
        gen.writeRecognizer(template, header);
    }
}

