/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import android.database.Cursor;
import androidx.annotation.RestrictTo;
import androidx.sqlite.db.SupportSQLiteDatabase;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class ViewInfo {
    public final String name;
    public final String sql;

    public ViewInfo(String name, String sql) {
        this.name = name;
        this.sql = sql;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewInfo viewInfo = (ViewInfo)o;
        return (this.name != null ? this.name.equals(viewInfo.name) : viewInfo.name == null) && (this.sql != null ? this.sql.equals(viewInfo.sql) : viewInfo.sql == null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.sql != null ? this.sql.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ViewInfo{name='" + this.name + '\'' + ", sql='" + this.sql + '\'' + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ViewInfo read(SupportSQLiteDatabase database, String viewName) {
        try (Cursor cursor = database.query("SELECT name, sql FROM sqlite_master WHERE type = 'view' AND name = '" + viewName + "'");){
            if (cursor.moveToFirst()) {
                ViewInfo viewInfo = new ViewInfo(cursor.getString(0), cursor.getString(1));
                return viewInfo;
            }
            ViewInfo viewInfo = new ViewInfo(viewName, null);
            return viewInfo;
        }
    }
}

