/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import androidx.annotation.NonNull;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

class TransactionExecutor
implements Executor {
    private final Executor mExecutor;
    private final ArrayDeque<Runnable> mTasks = new ArrayDeque();
    private Runnable mActive;

    TransactionExecutor(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    @Override
    public synchronized void execute(final Runnable command) {
        this.mTasks.offer(new Runnable(){

            @Override
            public void run() {
                try {
                    command.run();
                }
                finally {
                    TransactionExecutor.this.scheduleNext();
                }
            }
        });
        if (this.mActive == null) {
            this.scheduleNext();
        }
    }

    synchronized void scheduleNext() {
        this.mActive = this.mTasks.poll();
        if (this.mActive != null) {
            this.mExecutor.execute(this.mActive);
        }
    }
}

