/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.arch.core.util.Function;
import androidx.room.util.SneakyThrow;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

final class AutoCloser {
    @Nullable
    private SupportSQLiteOpenHelper mDelegateOpenHelper = null;
    @NonNull
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    @Nullable
    Runnable mOnAutoCloseCallback = null;
    @NonNull
    final Object mLock = new Object();
    final long mAutoCloseTimeoutInMs;
    @NonNull
    final Executor mExecutor;
    @GuardedBy(value="mLock")
    int mRefCount = 0;
    @GuardedBy(value="mLock")
    long mLastDecrementRefCountTimeStamp = SystemClock.uptimeMillis();
    @GuardedBy(value="mLock")
    @Nullable
    SupportSQLiteDatabase mDelegateDatabase;
    private boolean mManuallyClosed = false;
    private final Runnable mExecuteAutoCloser = new Runnable(){

        @Override
        public void run() {
            AutoCloser.this.mExecutor.execute(AutoCloser.this.mAutoCloser);
        }
    };
    @NonNull
    final Runnable mAutoCloser = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AutoCloser.this.mLock;
            synchronized (object) {
                if (SystemClock.uptimeMillis() - AutoCloser.this.mLastDecrementRefCountTimeStamp < AutoCloser.this.mAutoCloseTimeoutInMs) {
                    return;
                }
                if (AutoCloser.this.mRefCount != 0) {
                    return;
                }
                if (AutoCloser.this.mOnAutoCloseCallback == null) {
                    throw new IllegalStateException("mOnAutoCloseCallback is null but it should have been set before use. Please file a bug against Room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568");
                }
                AutoCloser.this.mOnAutoCloseCallback.run();
                if (AutoCloser.this.mDelegateDatabase != null && AutoCloser.this.mDelegateDatabase.isOpen()) {
                    try {
                        AutoCloser.this.mDelegateDatabase.close();
                    }
                    catch (IOException e) {
                        SneakyThrow.reThrow(e);
                    }
                    AutoCloser.this.mDelegateDatabase = null;
                }
            }
        }
    };

    AutoCloser(long autoCloseTimeoutAmount, @NonNull TimeUnit autoCloseTimeUnit, @NonNull Executor autoCloseExecutor) {
        this.mAutoCloseTimeoutInMs = autoCloseTimeUnit.toMillis(autoCloseTimeoutAmount);
        this.mExecutor = autoCloseExecutor;
    }

    public void init(@NonNull SupportSQLiteOpenHelper delegateOpenHelper) {
        if (this.mDelegateOpenHelper != null) {
            Log.e((String)"ROOM", (String)"AutoCloser initialized multiple times. Please file a bug against room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568");
            return;
        }
        this.mDelegateOpenHelper = delegateOpenHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <V> V executeRefCountingFunction(@NonNull Function<SupportSQLiteDatabase, V> function) {
        try {
            SupportSQLiteDatabase db = this.incrementCountAndEnsureDbIsOpen();
            Object object = function.apply((Object)db);
            return (V)object;
        }
        finally {
            this.decrementCountAndScheduleClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public SupportSQLiteDatabase incrementCountAndEnsureDbIsOpen() {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeCallbacks(this.mExecuteAutoCloser);
            ++this.mRefCount;
            if (this.mManuallyClosed) {
                throw new IllegalStateException("Attempting to open already closed database.");
            }
            if (this.mDelegateDatabase != null && this.mDelegateDatabase.isOpen()) {
                return this.mDelegateDatabase;
            }
            if (this.mDelegateOpenHelper == null) {
                throw new IllegalStateException("AutoCloser has not been initialized. Please file a bug against Room at: https://issuetracker.google.com/issues/new?component=413107&template=1096568");
            }
            this.mDelegateDatabase = this.mDelegateOpenHelper.getWritableDatabase();
            return this.mDelegateDatabase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementCountAndScheduleClose() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRefCount <= 0) {
                throw new IllegalStateException("ref count is 0 or lower but we're supposed to decrement");
            }
            --this.mRefCount;
            if (this.mRefCount == 0) {
                if (this.mDelegateDatabase == null) {
                    return;
                }
                this.mHandler.postDelayed(this.mExecuteAutoCloser, this.mAutoCloseTimeoutInMs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public SupportSQLiteDatabase getDelegateDatabase() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mDelegateDatabase;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDatabaseIfOpen() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.mManuallyClosed = true;
            if (this.mDelegateDatabase != null) {
                this.mDelegateDatabase.close();
            }
            this.mDelegateDatabase = null;
        }
    }

    public boolean isActive() {
        return !this.mManuallyClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public int getRefCountForTest() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRefCount;
        }
    }

    public void setAutoCloseCallback(Runnable onAutoClose) {
        this.mOnAutoCloseCallback = onAutoClose;
    }
}

