/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.LiveData;
import androidx.room.AutoCloser;
import androidx.room.InvalidationLiveDataContainer;
import androidx.room.MultiInstanceInvalidationClient;
import androidx.room.RoomDatabase;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;

public class InvalidationTracker {
    private static final String[] TRIGGERS = new String[]{"UPDATE", "DELETE", "INSERT"};
    private static final String UPDATE_TABLE_NAME = "room_table_modification_log";
    private static final String TABLE_ID_COLUMN_NAME = "table_id";
    private static final String INVALIDATED_COLUMN_NAME = "invalidated";
    private static final String CREATE_TRACKING_TABLE_SQL = "CREATE TEMP TABLE room_table_modification_log(table_id INTEGER PRIMARY KEY, invalidated INTEGER NOT NULL DEFAULT 0)";
    @VisibleForTesting
    static final String RESET_UPDATED_TABLES_SQL = "UPDATE room_table_modification_log SET invalidated = 0 WHERE invalidated = 1 ";
    @VisibleForTesting
    static final String SELECT_UPDATED_TABLES_SQL = "SELECT * FROM room_table_modification_log WHERE invalidated = 1;";
    @NonNull
    final HashMap<String, Integer> mTableIdLookup;
    final String[] mTableNames;
    @NonNull
    private Map<String, Set<String>> mViewTables;
    @Nullable
    AutoCloser mAutoCloser = null;
    final RoomDatabase mDatabase;
    AtomicBoolean mPendingRefresh = new AtomicBoolean(false);
    private volatile boolean mInitialized = false;
    volatile SupportSQLiteStatement mCleanupStatement;
    private final ObservedTableTracker mObservedTableTracker;
    private final InvalidationLiveDataContainer mInvalidationLiveDataContainer;
    @VisibleForTesting
    @SuppressLint(value={"RestrictedApi"})
    final SafeIterableMap<Observer, ObserverWrapper> mObserverMap = new SafeIterableMap();
    private MultiInstanceInvalidationClient mMultiInstanceInvalidationClient;
    private final Object mSyncTriggersLock = new Object();
    @VisibleForTesting
    Runnable mRefreshRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Lock closeLock = InvalidationTracker.this.mDatabase.getCloseLock();
            Set<Integer> invalidatedTableIds = null;
            closeLock.lock();
            try {
                if (!InvalidationTracker.this.ensureInitialization()) {
                    return;
                }
                if (!InvalidationTracker.this.mPendingRefresh.compareAndSet(true, false)) {
                    return;
                }
                if (InvalidationTracker.this.mDatabase.inTransaction()) {
                    return;
                }
                SupportSQLiteDatabase db = InvalidationTracker.this.mDatabase.getOpenHelper().getWritableDatabase();
                db.beginTransactionNonExclusive();
                try {
                    invalidatedTableIds = this.checkUpdatedTable();
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            catch (SQLiteException | IllegalStateException exception) {
                Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)exception);
            }
            finally {
                closeLock.unlock();
                if (InvalidationTracker.this.mAutoCloser != null) {
                    InvalidationTracker.this.mAutoCloser.decrementCountAndScheduleClose();
                }
            }
            if (invalidatedTableIds != null && !invalidatedTableIds.isEmpty()) {
                SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = InvalidationTracker.this.mObserverMap;
                synchronized (safeIterableMap) {
                    for (Map.Entry entry : InvalidationTracker.this.mObserverMap) {
                        ((ObserverWrapper)entry.getValue()).notifyByTableInvalidStatus(invalidatedTableIds);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<Integer> checkUpdatedTable() {
            HashSet<Integer> invalidatedTableIds = new HashSet<Integer>();
            try (Cursor cursor = InvalidationTracker.this.mDatabase.query((SupportSQLiteQuery)new SimpleSQLiteQuery(InvalidationTracker.SELECT_UPDATED_TABLES_SQL));){
                while (cursor.moveToNext()) {
                    int tableId = cursor.getInt(0);
                    invalidatedTableIds.add(tableId);
                }
            }
            if (!invalidatedTableIds.isEmpty()) {
                InvalidationTracker.this.mCleanupStatement.executeUpdateDelete();
            }
            return invalidatedTableIds;
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public InvalidationTracker(RoomDatabase database, String ... tableNames) {
        this(database, new HashMap<String, String>(), Collections.emptyMap(), tableNames);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public InvalidationTracker(RoomDatabase database, Map<String, String> shadowTablesMap, Map<String, Set<String>> viewTables, String ... tableNames) {
        String shadowTableName;
        this.mDatabase = database;
        this.mObservedTableTracker = new ObservedTableTracker(tableNames.length);
        this.mTableIdLookup = new HashMap();
        this.mViewTables = viewTables;
        this.mInvalidationLiveDataContainer = new InvalidationLiveDataContainer(this.mDatabase);
        int size = tableNames.length;
        this.mTableNames = new String[size];
        for (int id = 0; id < size; ++id) {
            String tableName = tableNames[id].toLowerCase(Locale.US);
            this.mTableIdLookup.put(tableName, id);
            shadowTableName = shadowTablesMap.get(tableNames[id]);
            this.mTableNames[id] = shadowTableName != null ? shadowTableName.toLowerCase(Locale.US) : tableName;
        }
        for (Map.Entry<String, String> shadowTableEntry : shadowTablesMap.entrySet()) {
            shadowTableName = shadowTableEntry.getValue().toLowerCase(Locale.US);
            if (!this.mTableIdLookup.containsKey(shadowTableName)) continue;
            String tableName = shadowTableEntry.getKey().toLowerCase(Locale.US);
            this.mTableIdLookup.put(tableName, this.mTableIdLookup.get(shadowTableName));
        }
    }

    void setAutoCloser(AutoCloser autoCloser) {
        this.mAutoCloser = autoCloser;
        this.mAutoCloser.setAutoCloseCallback(this::onAutoCloseCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalInit(SupportSQLiteDatabase database) {
        InvalidationTracker invalidationTracker = this;
        synchronized (invalidationTracker) {
            if (this.mInitialized) {
                Log.e((String)"ROOM", (String)"Invalidation tracker is initialized twice :/.");
                return;
            }
            database.execSQL("PRAGMA temp_store = MEMORY;");
            database.execSQL("PRAGMA recursive_triggers='ON';");
            database.execSQL(CREATE_TRACKING_TABLE_SQL);
            this.syncTriggers(database);
            this.mCleanupStatement = database.compileStatement(RESET_UPDATED_TABLES_SQL);
            this.mInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAutoCloseCallback() {
        InvalidationTracker invalidationTracker = this;
        synchronized (invalidationTracker) {
            this.mInitialized = false;
            this.mObservedTableTracker.resetTriggerState();
        }
    }

    void startMultiInstanceInvalidation(Context context, String name, Intent serviceIntent) {
        this.mMultiInstanceInvalidationClient = new MultiInstanceInvalidationClient(context, name, serviceIntent, this, this.mDatabase.getQueryExecutor());
    }

    void stopMultiInstanceInvalidation() {
        if (this.mMultiInstanceInvalidationClient != null) {
            this.mMultiInstanceInvalidationClient.stop();
            this.mMultiInstanceInvalidationClient = null;
        }
    }

    private static void appendTriggerName(StringBuilder builder, String tableName, String triggerType) {
        builder.append("`").append("room_table_modification_trigger_").append(tableName).append("_").append(triggerType).append("`");
    }

    private void stopTrackingTable(SupportSQLiteDatabase writableDb, int tableId) {
        String tableName = this.mTableNames[tableId];
        StringBuilder stringBuilder = new StringBuilder();
        for (String trigger : TRIGGERS) {
            stringBuilder.setLength(0);
            stringBuilder.append("DROP TRIGGER IF EXISTS ");
            InvalidationTracker.appendTriggerName(stringBuilder, tableName, trigger);
            writableDb.execSQL(stringBuilder.toString());
        }
    }

    private void startTrackingTable(SupportSQLiteDatabase writableDb, int tableId) {
        writableDb.execSQL("INSERT OR IGNORE INTO room_table_modification_log VALUES(" + tableId + ", 0)");
        String tableName = this.mTableNames[tableId];
        StringBuilder stringBuilder = new StringBuilder();
        for (String trigger : TRIGGERS) {
            stringBuilder.setLength(0);
            stringBuilder.append("CREATE TEMP TRIGGER IF NOT EXISTS ");
            InvalidationTracker.appendTriggerName(stringBuilder, tableName, trigger);
            stringBuilder.append(" AFTER ").append(trigger).append(" ON `").append(tableName).append("` BEGIN UPDATE ").append(UPDATE_TABLE_NAME).append(" SET ").append(INVALIDATED_COLUMN_NAME).append(" = 1").append(" WHERE ").append(TABLE_ID_COLUMN_NAME).append(" = ").append(tableId).append(" AND ").append(INVALIDATED_COLUMN_NAME).append(" = 0").append("; END");
            writableDb.execSQL(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    @WorkerThread
    public void addObserver(@NonNull Observer observer) {
        ObserverWrapper currentObserver;
        String[] tableNames = this.resolveViews(observer.mTables);
        int[] tableIds = new int[tableNames.length];
        int size = tableNames.length;
        for (int i = 0; i < size; ++i) {
            Integer tableId = this.mTableIdLookup.get(tableNames[i].toLowerCase(Locale.US));
            if (tableId == null) {
                throw new IllegalArgumentException("There is no table with name " + tableNames[i]);
            }
            tableIds[i] = tableId;
        }
        ObserverWrapper wrapper = new ObserverWrapper(observer, tableIds, tableNames);
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        synchronized (safeIterableMap) {
            currentObserver = (ObserverWrapper)this.mObserverMap.putIfAbsent((Object)observer, (Object)wrapper);
        }
        if (currentObserver == null && this.mObservedTableTracker.onAdded(tableIds)) {
            this.syncTriggers();
        }
    }

    private String[] validateAndResolveTableNames(String[] tableNames) {
        String[] resolved;
        for (String tableName : resolved = this.resolveViews(tableNames)) {
            if (this.mTableIdLookup.containsKey(tableName.toLowerCase(Locale.US))) continue;
            throw new IllegalArgumentException("There is no table with name " + tableName);
        }
        return resolved;
    }

    private String[] resolveViews(String[] names) {
        HashSet<String> tables = new HashSet<String>();
        for (String name : names) {
            String lowercase = name.toLowerCase(Locale.US);
            if (this.mViewTables.containsKey(lowercase)) {
                tables.addAll((Collection)this.mViewTables.get(lowercase));
                continue;
            }
            tables.add(name);
        }
        return tables.toArray(new String[tables.size()]);
    }

    private static void beginTransactionInternal(SupportSQLiteDatabase database) {
        if (Build.VERSION.SDK_INT >= 16 && database.isWriteAheadLoggingEnabled()) {
            database.beginTransactionNonExclusive();
        } else {
            database.beginTransaction();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void addWeakObserver(Observer observer) {
        this.addObserver(new WeakObserver(this, observer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"RestrictedApi"})
    @WorkerThread
    public void removeObserver(@NonNull Observer observer) {
        ObserverWrapper wrapper;
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        synchronized (safeIterableMap) {
            wrapper = (ObserverWrapper)this.mObserverMap.remove((Object)observer);
        }
        if (wrapper != null && this.mObservedTableTracker.onRemoved(wrapper.mTableIds)) {
            this.syncTriggers();
        }
    }

    boolean ensureInitialization() {
        if (!this.mDatabase.isOpen()) {
            return false;
        }
        if (!this.mInitialized) {
            this.mDatabase.getOpenHelper().getWritableDatabase();
        }
        if (!this.mInitialized) {
            Log.e((String)"ROOM", (String)"database is not initialized even though it is open");
            return false;
        }
        return true;
    }

    public void refreshVersionsAsync() {
        if (this.mPendingRefresh.compareAndSet(false, true)) {
            if (this.mAutoCloser != null) {
                this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
            }
            this.mDatabase.getQueryExecutor().execute(this.mRefreshRunnable);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @WorkerThread
    public void refreshVersionsSync() {
        if (this.mAutoCloser != null) {
            this.mAutoCloser.incrementCountAndEnsureDbIsOpen();
        }
        this.syncTriggers();
        this.mRefreshRunnable.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting(otherwise=3)
    public void notifyObserversByTableNames(String ... tables) {
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        synchronized (safeIterableMap) {
            for (Map.Entry entry : this.mObserverMap) {
                if (((Observer)entry.getKey()).isRemote()) continue;
                ((ObserverWrapper)entry.getValue()).notifyByTableNames(tables);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncTriggers(SupportSQLiteDatabase database) {
        if (database.inTransaction()) {
            return;
        }
        try {
            Lock closeLock = this.mDatabase.getCloseLock();
            closeLock.lock();
            try {
                Object object = this.mSyncTriggersLock;
                synchronized (object) {
                    int[] tablesToSync;
                    block19: {
                        tablesToSync = this.mObservedTableTracker.getTablesToSync();
                        if (tablesToSync != null) break block19;
                        return;
                    }
                    int limit = tablesToSync.length;
                    InvalidationTracker.beginTransactionInternal(database);
                    try {
                        block17: for (int tableId = 0; tableId < limit; ++tableId) {
                            switch (tablesToSync[tableId]) {
                                case 1: {
                                    this.startTrackingTable(database, tableId);
                                    continue block17;
                                }
                                case 2: {
                                    this.stopTrackingTable(database, tableId);
                                }
                            }
                        }
                        database.setTransactionSuccessful();
                    }
                    finally {
                        database.endTransaction();
                    }
                }
            }
            finally {
                closeLock.unlock();
            }
        }
        catch (SQLiteException | IllegalStateException exception) {
            Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)exception);
        }
    }

    void syncTriggers() {
        if (!this.mDatabase.isOpen()) {
            return;
        }
        this.syncTriggers(this.mDatabase.getOpenHelper().getWritableDatabase());
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public <T> LiveData<T> createLiveData(String[] tableNames, Callable<T> computeFunction) {
        return this.createLiveData(tableNames, false, computeFunction);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public <T> LiveData<T> createLiveData(String[] tableNames, boolean inTransaction, Callable<T> computeFunction) {
        return this.mInvalidationLiveDataContainer.create(this.validateAndResolveTableNames(tableNames), inTransaction, computeFunction);
    }

    static class WeakObserver
    extends Observer {
        final InvalidationTracker mTracker;
        final WeakReference<Observer> mDelegateRef;

        WeakObserver(InvalidationTracker tracker, Observer delegate) {
            super(delegate.mTables);
            this.mTracker = tracker;
            this.mDelegateRef = new WeakReference<Observer>(delegate);
        }

        @Override
        public void onInvalidated(@NonNull Set<String> tables) {
            Observer observer = (Observer)this.mDelegateRef.get();
            if (observer == null) {
                this.mTracker.removeObserver(this);
            } else {
                observer.onInvalidated(tables);
            }
        }
    }

    static class ObservedTableTracker {
        static final int NO_OP = 0;
        static final int ADD = 1;
        static final int REMOVE = 2;
        final long[] mTableObservers;
        final boolean[] mTriggerStates;
        final int[] mTriggerStateChanges;
        boolean mNeedsSync;

        ObservedTableTracker(int tableCount) {
            this.mTableObservers = new long[tableCount];
            this.mTriggerStates = new boolean[tableCount];
            this.mTriggerStateChanges = new int[tableCount];
            Arrays.fill(this.mTableObservers, 0L);
            Arrays.fill(this.mTriggerStates, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean onAdded(int ... tableIds) {
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                for (int tableId : tableIds) {
                    long prevObserverCount = this.mTableObservers[tableId];
                    this.mTableObservers[tableId] = prevObserverCount + 1L;
                    if (prevObserverCount != 0L) continue;
                    this.mNeedsSync = true;
                    needTriggerSync = true;
                }
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean onRemoved(int ... tableIds) {
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                for (int tableId : tableIds) {
                    long prevObserverCount = this.mTableObservers[tableId];
                    this.mTableObservers[tableId] = prevObserverCount - 1L;
                    if (prevObserverCount != 1L) continue;
                    this.mNeedsSync = true;
                    needTriggerSync = true;
                }
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetTriggerState() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                Arrays.fill(this.mTriggerStates, false);
                this.mNeedsSync = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        int[] getTablesToSync() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                if (!this.mNeedsSync) {
                    return null;
                }
                int tableCount = this.mTableObservers.length;
                for (int i = 0; i < tableCount; ++i) {
                    boolean newState;
                    boolean bl = newState = this.mTableObservers[i] > 0L;
                    this.mTriggerStateChanges[i] = newState != this.mTriggerStates[i] ? (newState ? 1 : 2) : 0;
                    this.mTriggerStates[i] = newState;
                }
                this.mNeedsSync = false;
                return (int[])this.mTriggerStateChanges.clone();
            }
        }
    }

    public static abstract class Observer {
        final String[] mTables;

        protected Observer(@NonNull String firstTable, String ... rest) {
            this.mTables = Arrays.copyOf(rest, rest.length + 1);
            this.mTables[rest.length] = firstTable;
        }

        public Observer(@NonNull String[] tables) {
            this.mTables = Arrays.copyOf(tables, tables.length);
        }

        public abstract void onInvalidated(@NonNull Set<String> var1);

        boolean isRemote() {
            return false;
        }
    }

    static class ObserverWrapper {
        final int[] mTableIds;
        private final String[] mTableNames;
        final Observer mObserver;
        private final Set<String> mSingleTableSet;

        ObserverWrapper(Observer observer, int[] tableIds, String[] tableNames) {
            this.mObserver = observer;
            this.mTableIds = tableIds;
            this.mTableNames = tableNames;
            if (tableIds.length == 1) {
                HashSet<String> set = new HashSet<String>();
                set.add(this.mTableNames[0]);
                this.mSingleTableSet = Collections.unmodifiableSet(set);
            } else {
                this.mSingleTableSet = null;
            }
        }

        void notifyByTableInvalidStatus(Set<Integer> invalidatedTablesIds) {
            Set<String> invalidatedTables = null;
            int size = this.mTableIds.length;
            for (int index = 0; index < size; ++index) {
                int tableId = this.mTableIds[index];
                if (!invalidatedTablesIds.contains(tableId)) continue;
                if (size == 1) {
                    invalidatedTables = this.mSingleTableSet;
                    continue;
                }
                if (invalidatedTables == null) {
                    invalidatedTables = new HashSet<String>(size);
                }
                invalidatedTables.add(this.mTableNames[index]);
            }
            if (invalidatedTables != null) {
                this.mObserver.onInvalidated(invalidatedTables);
            }
        }

        void notifyByTableNames(String[] tables) {
            Set<String> invalidatedTables = null;
            if (this.mTableNames.length == 1) {
                for (String table : tables) {
                    if (!table.equalsIgnoreCase(this.mTableNames[0])) continue;
                    invalidatedTables = this.mSingleTableSet;
                    break;
                }
            } else {
                HashSet<String> set = new HashSet<String>();
                block1: for (String table : tables) {
                    for (String ourTable : this.mTableNames) {
                        if (!ourTable.equalsIgnoreCase(table)) continue;
                        set.add(ourTable);
                        continue block1;
                    }
                }
                if (set.size() > 0) {
                    invalidatedTables = set;
                }
            }
            if (invalidatedTables != null) {
                this.mObserver.onInvalidated(invalidatedTables);
            }
        }
    }
}

