/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.ObjectsCompat;
import java.lang.reflect.Array;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
class ArrayUtils {
    public static <T> boolean contains(T[] array, T item) {
        for (T t : array) {
            if (!ObjectsCompat.equals(t, item)) continue;
            return true;
        }
        return false;
    }

    public static <T> T[] appendElement(Class<T> kind, T[] array, T element) {
        Object[] result;
        int end;
        if (array != null) {
            end = array.length;
            result = (Object[])Array.newInstance(kind, end + 1);
            System.arraycopy(array, 0, result, 0, end);
        } else {
            end = 0;
            result = (Object[])Array.newInstance(kind, 1);
        }
        result[end] = element;
        return result;
    }

    public static <T> T[] removeElement(Class<T> kind, T[] array, T element) {
        if (array != null) {
            if (!ArrayUtils.contains(array, element)) {
                return array;
            }
            int length = array.length;
            for (int i = 0; i < length; ++i) {
                if (!ObjectsCompat.equals(array[i], element)) continue;
                if (length == 1) {
                    return null;
                }
                Object[] result = (Object[])Array.newInstance(kind, length - 1);
                System.arraycopy(array, 0, result, 0, i);
                System.arraycopy(array, i + 1, result, i, length - i - 1);
                return result;
            }
        }
        return array;
    }

    private ArrayUtils() {
    }
}

