/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.app.slice.SliceManager;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.core.util.Preconditions;
import androidx.slice.ArrayUtils;
import androidx.slice.SliceConvert;
import androidx.slice.SliceItem;
import androidx.slice.SliceSpec;
import androidx.slice.compat.SliceProviderCompat;
import androidx.versionedparcelable.VersionedParcelable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@RequiresApi(value=19)
public final class Slice
implements VersionedParcelable {
    private static final String HINTS = "hints";
    private static final String ITEMS = "items";
    private static final String URI = "uri";
    private static final String SPEC_TYPE = "type";
    private static final String SPEC_REVISION = "revision";
    SliceSpec mSpec;
    SliceItem[] mItems = new SliceItem[0];
    @SliceHint
    String[] mHints = new String[0];
    String mUri;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    Slice(ArrayList<SliceItem> items, @SliceHint String[] hints, Uri uri, SliceSpec spec) {
        this.mHints = hints;
        this.mItems = items.toArray(new SliceItem[items.size()]);
        this.mUri = uri.toString();
        this.mSpec = spec;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Slice() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Slice(Bundle in) {
        this.mHints = in.getStringArray(HINTS);
        Parcelable[] items = in.getParcelableArray(ITEMS);
        this.mItems = new SliceItem[items.length];
        for (int i = 0; i < this.mItems.length; ++i) {
            if (!(items[i] instanceof Bundle)) continue;
            this.mItems[i] = new SliceItem((Bundle)items[i]);
        }
        this.mUri = in.getParcelable(URI).toString();
        this.mSpec = in.containsKey(SPEC_TYPE) ? new SliceSpec(in.getString(SPEC_TYPE), in.getInt(SPEC_REVISION)) : null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public Bundle toBundle() {
        Bundle b = new Bundle();
        b.putStringArray(HINTS, this.mHints);
        Parcelable[] p = new Parcelable[this.mItems.length];
        for (int i = 0; i < this.mItems.length; ++i) {
            p[i] = this.mItems[i].toBundle();
        }
        b.putParcelableArray(ITEMS, p);
        b.putParcelable(URI, (Parcelable)Uri.parse((String)this.mUri));
        if (this.mSpec != null) {
            b.putString(SPEC_TYPE, this.mSpec.getType());
            b.putInt(SPEC_REVISION, this.mSpec.getRevision());
        }
        return b;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public SliceSpec getSpec() {
        return this.mSpec;
    }

    public Uri getUri() {
        return Uri.parse((String)this.mUri);
    }

    public List<SliceItem> getItems() {
        return Arrays.asList(this.mItems);
    }

    @SliceHint
    public List<String> getHints() {
        return Arrays.asList(this.mHints);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean hasHint(@SliceHint String hint) {
        return ArrayUtils.contains(this.mHints, hint);
    }

    public String toString() {
        return this.toString("");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append("Slice ");
        if (this.mHints.length > 0) {
            Slice.appendHints(sb, this.mHints);
            sb.append(' ');
        }
        sb.append('[');
        sb.append(this.mUri);
        sb.append("] {\n");
        String nextIndent = indent + "  ";
        for (int i = 0; i < this.mItems.length; ++i) {
            SliceItem item = this.mItems[i];
            sb.append(item.toString(nextIndent));
        }
        sb.append(indent);
        sb.append('}');
        return sb.toString();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static void appendHints(StringBuilder sb, String[] hints) {
        if (hints == null || hints.length == 0) {
            return;
        }
        sb.append('(');
        int end = hints.length - 1;
        for (int i = 0; i < end; ++i) {
            sb.append(hints[i]);
            sb.append(", ");
        }
        sb.append(hints[end]);
        sb.append(")");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static Slice bindSlice(Context context, @NonNull Uri uri, Set<SliceSpec> supportedSpecs) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Slice.callBindSlice(context, uri, supportedSpecs);
        }
        return SliceProviderCompat.bindSlice(context, uri, supportedSpecs);
    }

    @RequiresApi(value=28)
    private static Slice callBindSlice(Context context, Uri uri, Set<SliceSpec> supportedSpecs) {
        return SliceConvert.wrap(((SliceManager)context.getSystemService(SliceManager.class)).bindSlice(uri, SliceConvert.unwrap(supportedSpecs)), context);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static boolean isValidIcon(IconCompat icon) {
        if (icon == null) {
            return false;
        }
        if (icon.mType == 2 && icon.getResId() == 0) {
            throw new IllegalArgumentException("Failed to add icon, invalid resource id: " + icon.getResId());
        }
        return true;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static class Builder {
        private final Uri mUri;
        private ArrayList<SliceItem> mItems = new ArrayList();
        @SliceHint
        private ArrayList<String> mHints = new ArrayList();
        private SliceSpec mSpec;
        private int mChildId;

        public Builder(@NonNull Uri uri) {
            this.mUri = uri;
        }

        public Builder(@NonNull Builder parent) {
            this.mUri = parent.getChildUri();
        }

        private Uri getChildUri() {
            return this.mUri.buildUpon().appendPath("_gen").appendPath(String.valueOf(this.mChildId++)).build();
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder setSpec(SliceSpec spec) {
            this.mSpec = spec;
            return this;
        }

        public Builder addHints(String ... hints) {
            this.mHints.addAll(Arrays.asList(hints));
            return this;
        }

        public Builder addHints(@SliceHint List<String> hints) {
            return this.addHints(hints.toArray(new String[hints.size()]));
        }

        public Builder addSubSlice(@NonNull Slice slice) {
            Preconditions.checkNotNull((Object)slice);
            return this.addSubSlice(slice, null);
        }

        public Builder addSubSlice(@NonNull Slice slice, String subType) {
            Preconditions.checkNotNull((Object)slice);
            this.mItems.add(new SliceItem((Object)slice, "slice", subType, slice.getHints().toArray(new String[slice.getHints().size()])));
            return this;
        }

        public Builder addAction(@NonNull PendingIntent action, @NonNull Slice s, @Nullable String subType) {
            Preconditions.checkNotNull((Object)action);
            Preconditions.checkNotNull((Object)s);
            String[] hints = s.getHints().toArray(new String[s.getHints().size()]);
            this.mItems.add(new SliceItem(action, s, "action", subType, hints));
            return this;
        }

        public Builder addAction(@NonNull SliceItem.ActionHandler action, @NonNull Slice s, @Nullable String subType) {
            Preconditions.checkNotNull((Object)s);
            String[] hints = s.getHints().toArray(new String[s.getHints().size()]);
            this.mItems.add(new SliceItem(action, s, "action", subType, hints));
            return this;
        }

        public Builder addText(CharSequence text, @Nullable String subType, String ... hints) {
            this.mItems.add(new SliceItem((Object)text, "text", subType, hints));
            return this;
        }

        public Builder addText(CharSequence text, @Nullable String subType, @SliceHint List<String> hints) {
            return this.addText(text, subType, hints.toArray(new String[hints.size()]));
        }

        public Builder addIcon(IconCompat icon, @Nullable String subType, String ... hints) {
            Preconditions.checkNotNull((Object)icon);
            if (Slice.isValidIcon(icon)) {
                this.mItems.add(new SliceItem((Object)icon, "image", subType, hints));
            }
            return this;
        }

        public Builder addIcon(IconCompat icon, @Nullable String subType, @SliceHint List<String> hints) {
            Preconditions.checkNotNull((Object)icon);
            if (Slice.isValidIcon(icon)) {
                return this.addIcon(icon, subType, hints.toArray(new String[hints.size()]));
            }
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder addRemoteInput(RemoteInput remoteInput, @Nullable String subType, @SliceHint List<String> hints) {
            Preconditions.checkNotNull((Object)remoteInput);
            return this.addRemoteInput(remoteInput, subType, hints.toArray(new String[hints.size()]));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder addRemoteInput(RemoteInput remoteInput, @Nullable String subType, String ... hints) {
            Preconditions.checkNotNull((Object)remoteInput);
            this.mItems.add(new SliceItem((Object)remoteInput, "input", subType, hints));
            return this;
        }

        public Builder addInt(int value, @Nullable String subType, String ... hints) {
            this.mItems.add(new SliceItem((Object)value, "int", subType, hints));
            return this;
        }

        public Builder addInt(int value, @Nullable String subType, @SliceHint List<String> hints) {
            return this.addInt(value, subType, hints.toArray(new String[hints.size()]));
        }

        public Builder addLong(long time, @Nullable String subType, String ... hints) {
            this.mItems.add(new SliceItem((Object)time, "long", subType, hints));
            return this;
        }

        public Builder addLong(long time, @Nullable String subType, @SliceHint List<String> hints) {
            return this.addLong(time, subType, hints.toArray(new String[hints.size()]));
        }

        @Deprecated
        public Builder addTimestamp(long time, @Nullable String subType, String ... hints) {
            this.mItems.add(new SliceItem((Object)time, "long", subType, hints));
            return this;
        }

        public Builder addTimestamp(long time, @Nullable String subType, @SliceHint List<String> hints) {
            return this.addTimestamp(time, subType, hints.toArray(new String[hints.size()]));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public Builder addItem(SliceItem item) {
            this.mItems.add(item);
            return this;
        }

        public Slice build() {
            return new Slice(this.mItems, this.mHints.toArray(new String[this.mHints.size()]), this.mUri, this.mSpec);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface SliceHint {
    }
}

