/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.app.PendingIntent;
import android.os.Parcelable;
import android.text.Spanned;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.text.HtmlCompat;
import androidx.core.util.Pair;
import androidx.slice.Slice;
import androidx.versionedparcelable.VersionedParcelable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class SliceItemHolder
implements VersionedParcelable {
    VersionedParcelable mVersionedParcelable;
    Parcelable mParcelable;
    String mStr;
    int mInt;
    long mLong;

    public SliceItemHolder() {
    }

    public SliceItemHolder(String format, Object mObj, boolean isStream) {
        switch (format) {
            case "action": {
                if (((Pair)mObj).first instanceof PendingIntent) {
                    if (isStream) {
                        throw new IllegalArgumentException("Cannot write PendingIntent to stream");
                    }
                    this.mParcelable = (Parcelable)((Pair)mObj).first;
                } else if (!isStream) {
                    throw new IllegalArgumentException("Cannot write callback to parcel");
                }
                this.mVersionedParcelable = (VersionedParcelable)((Pair)mObj).second;
                break;
            }
            case "image": 
            case "slice": {
                this.mVersionedParcelable = (VersionedParcelable)mObj;
                break;
            }
            case "input": {
                if (isStream) {
                    throw new IllegalArgumentException("Cannot write RemoteInput to stream");
                }
                this.mParcelable = (Parcelable)mObj;
                break;
            }
            case "text": {
                this.mStr = mObj instanceof Spanned ? HtmlCompat.toHtml((Spanned)((Spanned)mObj), (int)0) : (String)mObj;
                break;
            }
            case "int": {
                this.mInt = (Integer)mObj;
                break;
            }
            case "long": {
                this.mLong = (Long)mObj;
            }
        }
    }

    public Object getObj(String format) {
        switch (format) {
            case "action": {
                return new Pair((Object)this.mParcelable, (Object)((Slice)this.mVersionedParcelable));
            }
            case "image": 
            case "slice": {
                return this.mVersionedParcelable;
            }
            case "input": {
                return this.mParcelable;
            }
            case "text": {
                if (this.mStr == null || this.mStr.length() == 0) {
                    return "";
                }
                return HtmlCompat.fromHtml((String)this.mStr, (int)0);
            }
            case "int": {
                return this.mInt;
            }
            case "long": {
                return this.mLong;
            }
        }
        throw new IllegalArgumentException("Unrecognized format " + format);
    }
}

