/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.SliceManager;
import androidx.slice.SliceSpec;
import androidx.slice.compat.SliceProviderCompat;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
class SliceManagerCompat
extends SliceManager {
    private final Context mContext;

    SliceManagerCompat(Context context) {
        this.mContext = context;
    }

    @Override
    @NonNull
    public Set<SliceSpec> getPinnedSpecs(@NonNull Uri uri) {
        return SliceProviderCompat.getPinnedSpecs(this.mContext, uri);
    }

    @Override
    public int checkSlicePermission(Uri uri, int pid, int uid) {
        return SliceProviderCompat.checkSlicePermission(this.mContext, this.mContext.getPackageName(), uri, pid, uid);
    }

    @Override
    public void grantSlicePermission(String toPackage, Uri uri) {
        SliceProviderCompat.grantSlicePermission(this.mContext, this.mContext.getPackageName(), toPackage, uri);
    }

    @Override
    public void revokeSlicePermission(String toPackage, Uri uri) {
        SliceProviderCompat.revokeSlicePermission(this.mContext, this.mContext.getPackageName(), toPackage, uri);
    }

    @Override
    public List<Uri> getPinnedSlices() {
        return SliceProviderCompat.getPinnedSlices(this.mContext);
    }
}

