/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.SliceConvert;
import androidx.slice.SliceManager;
import androidx.slice.SliceSpec;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(api=28)
class SliceManagerWrapper
extends SliceManager {
    private final android.app.slice.SliceManager mManager;
    private final Context mContext;

    SliceManagerWrapper(Context context) {
        this(context, (android.app.slice.SliceManager)context.getSystemService(android.app.slice.SliceManager.class));
    }

    SliceManagerWrapper(Context context, android.app.slice.SliceManager manager) {
        this.mContext = context;
        this.mManager = manager;
    }

    @Override
    @NonNull
    public Set<SliceSpec> getPinnedSpecs(@NonNull Uri uri) {
        if (Build.VERSION.SDK_INT == 28) {
            uri = this.maybeAddCurrentUserId(uri);
        }
        return SliceConvert.wrap(this.mManager.getPinnedSpecs(uri));
    }

    @Override
    public int checkSlicePermission(@NonNull Uri uri, int pid, int uid) {
        return this.mManager.checkSlicePermission(uri, pid, uid);
    }

    @Override
    public void grantSlicePermission(@NonNull String toPackage, @NonNull Uri uri) {
        this.mManager.grantSlicePermission(toPackage, uri);
    }

    @Override
    public void revokeSlicePermission(@NonNull String toPackage, @NonNull Uri uri) {
        this.mManager.revokeSlicePermission(toPackage, uri);
    }

    @Override
    public List<Uri> getPinnedSlices() {
        return this.mManager.getPinnedSlices();
    }

    private Uri maybeAddCurrentUserId(Uri uri) {
        if (uri == null || uri.getAuthority().contains("@")) {
            return uri;
        }
        String auth = uri.getAuthority();
        return uri.buildUpon().encodedAuthority(this.getCurrentUserId() + "@" + auth).build();
    }

    private int getCurrentUserId() {
        UserHandle h = Process.myUserHandle();
        try {
            return (Integer)h.getClass().getDeclaredMethod("getIdentifier", new Class[0]).invoke((Object)h, new Object[0]);
        }
        catch (IllegalAccessException e) {
            return 0;
        }
        catch (InvocationTargetException e) {
            return 0;
        }
        catch (NoSuchMethodException e) {
            return 0;
        }
    }
}

