/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.compat;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.SystemClock;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.core.util.ObjectsCompat;
import androidx.slice.SliceSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class CompatPinnedList {
    private static final String LAST_BOOT = "last_boot";
    private static final String PIN_PREFIX = "pinned_";
    private static final String SPEC_NAME_PREFIX = "spec_names_";
    private static final String SPEC_REV_PREFIX = "spec_revs_";
    private static final long BOOT_THRESHOLD = 2000L;
    private final Context mContext;
    private final String mPrefsName;

    public CompatPinnedList(Context context, String prefsName) {
        this.mContext = context;
        this.mPrefsName = prefsName;
    }

    private SharedPreferences getPrefs() {
        long currentBootTime;
        SharedPreferences prefs = this.mContext.getSharedPreferences(this.mPrefsName, 0);
        long lastBootTime = prefs.getLong(LAST_BOOT, 0L);
        if (Math.abs(lastBootTime - (currentBootTime = this.getBootTime())) > 2000L) {
            prefs.edit().clear().putLong(LAST_BOOT, currentBootTime).apply();
        }
        return prefs;
    }

    public List<Uri> getPinnedSlices() {
        ArrayList<Uri> pinned = new ArrayList<Uri>();
        for (String key : this.getPrefs().getAll().keySet()) {
            Uri uri;
            if (!key.startsWith(PIN_PREFIX) || this.getPins(uri = Uri.parse((String)key.substring(PIN_PREFIX.length()))).isEmpty()) continue;
            pinned.add(uri);
        }
        return pinned;
    }

    private Set<String> getPins(Uri uri) {
        return this.getPrefs().getStringSet(PIN_PREFIX + uri.toString(), (Set)new ArraySet());
    }

    public synchronized ArraySet<SliceSpec> getSpecs(Uri uri) {
        String[] specRevs;
        ArraySet specs = new ArraySet();
        SharedPreferences prefs = this.getPrefs();
        String specNamesStr = prefs.getString(SPEC_NAME_PREFIX + uri.toString(), null);
        String specRevsStr = prefs.getString(SPEC_REV_PREFIX + uri.toString(), null);
        if (TextUtils.isEmpty((CharSequence)specNamesStr) || TextUtils.isEmpty((CharSequence)specRevsStr)) {
            return new ArraySet();
        }
        String[] specNames = specNamesStr.split(",", -1);
        if (specNames.length != (specRevs = specRevsStr.split(",", -1)).length) {
            return new ArraySet();
        }
        for (int i = 0; i < specNames.length; ++i) {
            specs.add((Object)new SliceSpec(specNames[i], Integer.parseInt(specRevs[i])));
        }
        return specs;
    }

    private void setPins(Uri uri, Set<String> pins) {
        this.getPrefs().edit().putStringSet(PIN_PREFIX + uri.toString(), pins).apply();
    }

    private void setSpecs(Uri uri, ArraySet<SliceSpec> specs) {
        Object[] specNames = new String[specs.size()];
        Object[] specRevs = new String[specs.size()];
        for (int i = 0; i < specs.size(); ++i) {
            specNames[i] = ((SliceSpec)specs.valueAt(i)).getType();
            specRevs[i] = String.valueOf(((SliceSpec)specs.valueAt(i)).getRevision());
        }
        this.getPrefs().edit().putString(SPEC_NAME_PREFIX + uri.toString(), TextUtils.join((CharSequence)",", (Object[])specNames)).putString(SPEC_REV_PREFIX + uri.toString(), TextUtils.join((CharSequence)",", (Object[])specRevs)).apply();
    }

    @VisibleForTesting
    protected long getBootTime() {
        return System.currentTimeMillis() - SystemClock.elapsedRealtime();
    }

    public synchronized boolean addPin(Uri uri, String pkg, Set<SliceSpec> specs) {
        Set<String> pins = this.getPins(uri);
        boolean wasNotPinned = pins.isEmpty();
        pins.add(pkg);
        this.setPins(uri, pins);
        if (wasNotPinned) {
            this.setSpecs(uri, (ArraySet<SliceSpec>)new ArraySet(specs));
        } else {
            this.setSpecs(uri, CompatPinnedList.mergeSpecs(this.getSpecs(uri), specs));
        }
        return wasNotPinned;
    }

    public synchronized boolean removePin(Uri uri, String pkg) {
        Set<String> pins = this.getPins(uri);
        if (pins.isEmpty() || !pins.contains(pkg)) {
            return false;
        }
        pins.remove(pkg);
        this.setPins(uri, pins);
        this.setSpecs(uri, (ArraySet<SliceSpec>)new ArraySet());
        return pins.size() == 0;
    }

    private static ArraySet<SliceSpec> mergeSpecs(ArraySet<SliceSpec> specs, Set<SliceSpec> supportedSpecs) {
        for (int i = 0; i < specs.size(); ++i) {
            SliceSpec s = (SliceSpec)specs.valueAt(i);
            SliceSpec other = CompatPinnedList.findSpec(supportedSpecs, s.getType());
            if (other == null) {
                specs.removeAt(i--);
                continue;
            }
            if (other.getRevision() >= s.getRevision()) continue;
            specs.removeAt(i--);
            specs.add((Object)other);
        }
        return specs;
    }

    private static SliceSpec findSpec(Set<SliceSpec> specs, String type) {
        for (SliceSpec spec : specs) {
            if (!ObjectsCompat.equals((Object)spec.getType(), (Object)type)) continue;
            return spec;
        }
        return null;
    }
}

