/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.compat;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.Html;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.Log;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AlertDialog;
import androidx.core.text.BidiFormatter;
import androidx.slice.compat.SliceProviderCompat;
import androidx.slice.core.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class SlicePermissionActivity
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnDismissListener {
    private static final float MAX_LABEL_SIZE_PX = 500.0f;
    private static final String TAG = "SlicePermissionActivity";
    private Uri mUri;
    private String mCallingPkg;
    private String mProviderPkg;
    private AlertDialog mDialog;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mUri = (Uri)this.getIntent().getParcelableExtra("slice_uri");
        this.mCallingPkg = this.getIntent().getStringExtra("pkg");
        this.mProviderPkg = this.getIntent().getStringExtra("provider_pkg");
        try {
            PackageManager pm = this.getPackageManager();
            String app1 = BidiFormatter.getInstance().unicodeWrap(this.loadSafeLabel(pm, pm.getApplicationInfo(this.mCallingPkg, 0)).toString());
            String app2 = BidiFormatter.getInstance().unicodeWrap(this.loadSafeLabel(pm, pm.getApplicationInfo(this.mProviderPkg, 0)).toString());
            this.mDialog = new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.abc_slice_permission_title, new Object[]{app1, app2})).setView(R.layout.abc_slice_permission_request).setNegativeButton(R.string.abc_slice_permission_deny, (DialogInterface.OnClickListener)this).setPositiveButton(R.string.abc_slice_permission_allow, (DialogInterface.OnClickListener)this).setOnDismissListener((DialogInterface.OnDismissListener)this).show();
            TextView t1 = (TextView)this.mDialog.getWindow().getDecorView().findViewById(R.id.text1);
            t1.setText((CharSequence)this.getString(R.string.abc_slice_permission_text_1, new Object[]{app2}));
            TextView t2 = (TextView)this.mDialog.getWindow().getDecorView().findViewById(R.id.text2);
            t2.setText((CharSequence)this.getString(R.string.abc_slice_permission_text_2, new Object[]{app2}));
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Couldn't find package", (Throwable)e);
            this.finish();
        }
    }

    private CharSequence loadSafeLabel(PackageManager pm, ApplicationInfo appInfo) {
        int codePoint;
        String label = appInfo.loadLabel(pm).toString();
        String labelStr = Html.fromHtml((String)label).toString();
        int labelLength = labelStr.length();
        for (int offset = 0; offset < labelLength; offset += Character.charCount(codePoint)) {
            codePoint = labelStr.codePointAt(offset);
            int type = Character.getType(codePoint);
            if (type == 13 || type == 15 || type == 14) {
                labelStr = labelStr.substring(0, offset);
                break;
            }
            if (type != 12) continue;
            labelStr = labelStr.substring(0, offset) + " " + labelStr.substring(offset + Character.charCount(codePoint));
        }
        if ((labelStr = labelStr.trim()).isEmpty()) {
            return appInfo.packageName;
        }
        TextPaint paint = new TextPaint();
        paint.setTextSize(42.0f);
        return TextUtils.ellipsize((CharSequence)labelStr, (TextPaint)paint, (float)500.0f, (TextUtils.TruncateAt)TextUtils.TruncateAt.END);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            SliceProviderCompat.grantSlicePermission((Context)this, this.getPackageName(), this.mCallingPkg, this.mUri.buildUpon().path("").build());
        }
        this.finish();
    }

    public void onDismiss(DialogInterface dialog) {
        this.finish();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.cancel();
        }
    }
}

