/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.compat;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArraySet;
import androidx.core.util.Preconditions;
import androidx.slice.Slice;
import androidx.slice.SliceProvider;
import androidx.slice.SliceSpec;
import androidx.slice.compat.CompatPermissionManager;
import androidx.slice.compat.CompatPinnedList;
import androidx.versionedparcelable.ParcelUtils;
import androidx.versionedparcelable.VersionedParcelable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=19)
public class SliceProviderCompat {
    public static final String PERMS_PREFIX = "slice_perms_";
    private static final String TAG = "SliceProviderCompat";
    private static final String DATA_PREFIX = "slice_data_";
    private static final String ALL_FILES = "slice_data_all_slice_files";
    private static final long SLICE_BIND_ANR = 2000L;
    public static final String METHOD_SLICE = "bind_slice";
    public static final String METHOD_MAP_INTENT = "map_slice";
    public static final String METHOD_PIN = "pin_slice";
    public static final String METHOD_UNPIN = "unpin_slice";
    public static final String METHOD_GET_PINNED_SPECS = "get_specs";
    public static final String METHOD_MAP_ONLY_INTENT = "map_only";
    public static final String METHOD_GET_DESCENDANTS = "get_descendants";
    public static final String METHOD_CHECK_PERMISSION = "check_perms";
    public static final String METHOD_GRANT_PERMISSION = "grant_perms";
    public static final String METHOD_REVOKE_PERMISSION = "revoke_perms";
    public static final String EXTRA_BIND_URI = "slice_uri";
    public static final String EXTRA_INTENT = "slice_intent";
    public static final String EXTRA_SLICE = "slice";
    public static final String EXTRA_SUPPORTED_SPECS = "specs";
    public static final String EXTRA_SUPPORTED_SPECS_REVS = "revs";
    public static final String EXTRA_PKG = "pkg";
    public static final String EXTRA_PROVIDER_PKG = "provider_pkg";
    public static final String EXTRA_SLICE_DESCENDANTS = "slice_descendants";
    public static final String EXTRA_UID = "uid";
    public static final String EXTRA_PID = "pid";
    public static final String EXTRA_RESULT = "result";
    public static final String ARG_SUPPORTS_VERSIONED_PARCELABLE = "supports_versioned_parcelable";
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Context mContext;
    String mCallback;
    private final SliceProvider mProvider;
    private CompatPinnedList mPinnedList;
    private CompatPermissionManager mPermissionManager;
    private final Runnable mAnr = new Runnable(){

        @Override
        public void run() {
            Process.sendSignal((int)Process.myPid(), (int)3);
            Log.wtf((String)SliceProviderCompat.TAG, (String)("Timed out while handling slice callback " + SliceProviderCompat.this.mCallback));
        }
    };

    public SliceProviderCompat(SliceProvider provider, CompatPermissionManager permissionManager, Context context) {
        this.mProvider = provider;
        this.mContext = context;
        String prefsFile = DATA_PREFIX + this.getClass().getName();
        SharedPreferences allFiles = this.mContext.getSharedPreferences(ALL_FILES, 0);
        Set files = allFiles.getStringSet(ALL_FILES, Collections.emptySet());
        if (!files.contains(prefsFile)) {
            files = new ArraySet((Collection)files);
            files.add(prefsFile);
            allFiles.edit().putStringSet(ALL_FILES, files).commit();
        }
        this.mPinnedList = new CompatPinnedList(this.mContext, prefsFile);
        this.mPermissionManager = permissionManager;
    }

    private Context getContext() {
        return this.mContext;
    }

    public String getCallingPackage() {
        return this.mProvider.getCallingPackage();
    }

    public Bundle call(String method, String arg, Bundle extras) {
        if (method.equals(METHOD_SLICE)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            Set<SliceSpec> specs = SliceProviderCompat.getSpecs(extras);
            Slice s = this.handleBindSlice(uri, specs, this.getCallingPackage());
            Bundle b = new Bundle();
            if (ARG_SUPPORTS_VERSIONED_PARCELABLE.equals(arg)) {
                b.putParcelable(EXTRA_SLICE, s != null ? ParcelUtils.toParcelable((VersionedParcelable)s) : null);
            } else {
                b.putParcelable(EXTRA_SLICE, (Parcelable)(s != null ? s.toBundle() : null));
            }
            return b;
        }
        if (method.equals(METHOD_MAP_INTENT)) {
            Intent intent = (Intent)extras.getParcelable(EXTRA_INTENT);
            Uri uri = this.mProvider.onMapIntentToUri(intent);
            Bundle b = new Bundle();
            if (uri != null) {
                Set<SliceSpec> specs = SliceProviderCompat.getSpecs(extras);
                Slice s = this.handleBindSlice(uri, specs, this.getCallingPackage());
                if (ARG_SUPPORTS_VERSIONED_PARCELABLE.equals(arg)) {
                    b.putParcelable(EXTRA_SLICE, s != null ? ParcelUtils.toParcelable((VersionedParcelable)s) : null);
                } else {
                    b.putParcelable(EXTRA_SLICE, (Parcelable)(s != null ? s.toBundle() : null));
                }
            } else {
                b.putParcelable(EXTRA_SLICE, null);
            }
            return b;
        }
        if (method.equals(METHOD_MAP_ONLY_INTENT)) {
            Intent intent = (Intent)extras.getParcelable(EXTRA_INTENT);
            Uri uri = this.mProvider.onMapIntentToUri(intent);
            Bundle b = new Bundle();
            b.putParcelable(EXTRA_SLICE, (Parcelable)uri);
            return b;
        }
        if (method.equals(METHOD_PIN)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            Set<SliceSpec> specs = SliceProviderCompat.getSpecs(extras);
            String pkg = extras.getString(EXTRA_PKG);
            if (this.mPinnedList.addPin(uri, pkg, specs)) {
                this.handleSlicePinned(uri);
            }
            return null;
        }
        if (method.equals(METHOD_UNPIN)) {
            String pkg;
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            if (this.mPinnedList.removePin(uri, pkg = extras.getString(EXTRA_PKG))) {
                this.handleSliceUnpinned(uri);
            }
            return null;
        }
        if (method.equals(METHOD_GET_PINNED_SPECS)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            Bundle b = new Bundle();
            ArraySet<SliceSpec> specs = this.mPinnedList.getSpecs(uri);
            if (specs.size() == 0) {
                throw new IllegalStateException(uri + " is not pinned");
            }
            SliceProviderCompat.addSpecs(b, specs);
            return b;
        }
        if (method.equals(METHOD_GET_DESCENDANTS)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            Bundle b = new Bundle();
            b.putParcelableArrayList(EXTRA_SLICE_DESCENDANTS, new ArrayList<Uri>(this.handleGetDescendants(uri)));
            return b;
        }
        if (method.equals(METHOD_CHECK_PERMISSION)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            String pkg = extras.getString(EXTRA_PKG);
            int pid = extras.getInt(EXTRA_PID);
            int uid = extras.getInt(EXTRA_UID);
            Bundle b = new Bundle();
            b.putInt(EXTRA_RESULT, this.mPermissionManager.checkSlicePermission(uri, pid, uid));
            return b;
        }
        if (method.equals(METHOD_GRANT_PERMISSION)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            String toPkg = extras.getString(EXTRA_PKG);
            if (Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("Only the owning process can manage slice permissions");
            }
            this.mPermissionManager.grantSlicePermission(uri, toPkg);
        } else if (method.equals(METHOD_REVOKE_PERMISSION)) {
            Uri uri = (Uri)extras.getParcelable(EXTRA_BIND_URI);
            String toPkg = extras.getString(EXTRA_PKG);
            if (Binder.getCallingUid() != Process.myUid()) {
                throw new SecurityException("Only the owning process can manage slice permissions");
            }
            this.mPermissionManager.revokeSlicePermission(uri, toPkg);
        }
        return null;
    }

    private Collection<Uri> handleGetDescendants(Uri uri) {
        this.mCallback = "onGetSliceDescendants";
        return this.mProvider.onGetSliceDescendants(uri);
    }

    private void handleSlicePinned(Uri sliceUri) {
        this.mCallback = "onSlicePinned";
        this.mHandler.postDelayed(this.mAnr, 2000L);
        try {
            this.mProvider.onSlicePinned(sliceUri);
            this.mProvider.handleSlicePinned(sliceUri);
        }
        finally {
            this.mHandler.removeCallbacks(this.mAnr);
        }
    }

    private void handleSliceUnpinned(Uri sliceUri) {
        this.mCallback = "onSliceUnpinned";
        this.mHandler.postDelayed(this.mAnr, 2000L);
        try {
            this.mProvider.onSliceUnpinned(sliceUri);
            this.mProvider.handleSliceUnpinned(sliceUri);
        }
        finally {
            this.mHandler.removeCallbacks(this.mAnr);
        }
    }

    private Slice handleBindSlice(Uri sliceUri, Set<SliceSpec> specs, String callingPkg) {
        String pkg;
        String string2 = pkg = callingPkg != null ? callingPkg : this.getContext().getPackageManager().getNameForUid(Binder.getCallingUid());
        if (this.mPermissionManager.checkSlicePermission(sliceUri, Binder.getCallingPid(), Binder.getCallingUid()) != 0) {
            return SliceProvider.createPermissionSlice(this.getContext(), sliceUri, pkg);
        }
        return this.onBindSliceStrict(sliceUri, specs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Slice onBindSliceStrict(Uri sliceUri, Set<SliceSpec> specs) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.getThreadPolicy();
        this.mCallback = "onBindSlice";
        this.mHandler.postDelayed(this.mAnr, 2000L);
        try {
            Slice slice;
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)new StrictMode.ThreadPolicy.Builder().detectAll().penaltyDeath().build());
            SliceProvider.setSpecs(specs);
            try {
                slice = this.mProvider.onBindSlice(sliceUri);
            }
            catch (Exception e) {
                Log.wtf((String)TAG, (String)("Slice with URI " + sliceUri.toString() + " is invalid."), (Throwable)e);
                Slice slice2 = null;
                SliceProvider.setSpecs(null);
                this.mHandler.removeCallbacks(this.mAnr);
                StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
                return slice2;
                {
                    catch (Throwable throwable) {
                        SliceProvider.setSpecs(null);
                        this.mHandler.removeCallbacks(this.mAnr);
                        throw throwable;
                    }
                }
            }
            SliceProvider.setSpecs(null);
            this.mHandler.removeCallbacks(this.mAnr);
            return slice;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Slice bindSlice(Context context, Uri uri, Set<SliceSpec> supportedSpecs) {
        Parcelable parcel;
        block10: {
            block9: {
                Bundle res;
                block8: {
                    ProviderHolder holder = SliceProviderCompat.acquireClient(context.getContentResolver(), uri);
                    if (holder.mProvider == null) {
                        throw new IllegalArgumentException("Unknown URI " + uri);
                    }
                    Bundle extras = new Bundle();
                    extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
                    SliceProviderCompat.addSpecs(extras, supportedSpecs);
                    res = holder.mProvider.call(METHOD_SLICE, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
                    if (res != null) break block8;
                    Slice slice = null;
                    return slice;
                }
                res.setClassLoader(SliceProviderCompat.class.getClassLoader());
                parcel = res.getParcelable(EXTRA_SLICE);
                if (parcel != null) break block9;
                Slice slice = null;
                return slice;
            }
            if (!(parcel instanceof Bundle)) break block10;
            Slice slice = new Slice((Bundle)parcel);
            return slice;
        }
        try {
            Slice slice = (Slice)ParcelUtils.fromParcelable((Parcelable)parcel);
            return slice;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to bind slice", (Throwable)e);
            Slice slice = null;
            return slice;
        }
    }

    public static void addSpecs(Bundle extras, Set<SliceSpec> supportedSpecs) {
        ArrayList<String> types = new ArrayList<String>();
        ArrayList<Integer> revs = new ArrayList<Integer>();
        for (SliceSpec spec : supportedSpecs) {
            types.add(spec.getType());
            revs.add(spec.getRevision());
        }
        extras.putStringArrayList(EXTRA_SUPPORTED_SPECS, types);
        extras.putIntegerArrayList(EXTRA_SUPPORTED_SPECS_REVS, revs);
    }

    public static Set<SliceSpec> getSpecs(Bundle extras) {
        ArraySet specs = new ArraySet();
        ArrayList types = extras.getStringArrayList(EXTRA_SUPPORTED_SPECS);
        ArrayList revs = extras.getIntegerArrayList(EXTRA_SUPPORTED_SPECS_REVS);
        if (types != null && revs != null) {
            for (int i = 0; i < types.size(); ++i) {
                specs.add((Object)new SliceSpec((String)types.get(i), (Integer)revs.get(i)));
            }
        }
        return specs;
    }

    public static Slice bindSlice(Context context, Intent intent, Set<SliceSpec> supportedSpecs) {
        List providers;
        Preconditions.checkNotNull((Object)intent, (Object)"intent");
        Preconditions.checkArgument((intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null ? 1 : 0) != 0, (Object)String.format("Slice intent must be explicit %s", intent));
        ContentResolver resolver = context.getContentResolver();
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return SliceProviderCompat.bindSlice(context, intentData, supportedSpecs);
        }
        Intent queryIntent = new Intent(intent);
        if (!queryIntent.hasCategory("android.app.slice.category.SLICE")) {
            queryIntent.addCategory("android.app.slice.category.SLICE");
        }
        if ((providers = context.getPackageManager().queryIntentContentProviders(queryIntent, 0)) == null || providers.isEmpty()) {
            ResolveInfo resolve = context.getPackageManager().resolveActivity(intent, 128);
            if (resolve != null && resolve.activityInfo != null && resolve.activityInfo.metaData != null && resolve.activityInfo.metaData.containsKey("android.metadata.SLICE_URI")) {
                return SliceProviderCompat.bindSlice(context, Uri.parse((String)resolve.activityInfo.metaData.getString("android.metadata.SLICE_URI")), supportedSpecs);
            }
            return null;
        }
        String authority = ((ResolveInfo)providers.get((int)0)).providerInfo.authority;
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        ProviderHolder holder = SliceProviderCompat.acquireClient(resolver, uri);
        if (holder.mProvider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_INTENT, (Parcelable)intent);
            SliceProviderCompat.addSpecs(extras, supportedSpecs);
            Bundle res = holder.mProvider.call(METHOD_MAP_INTENT, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
            if (res == null) {
                return null;
            }
            res.setClassLoader(SliceProviderCompat.class.getClassLoader());
            Parcelable parcel = res.getParcelable(EXTRA_SLICE);
            if (parcel == null) {
                return null;
            }
            if (parcel instanceof Bundle) {
                return new Slice((Bundle)parcel);
            }
            return (Slice)ParcelUtils.fromParcelable((Parcelable)parcel);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to bind slice", (Throwable)e);
            return null;
        }
    }

    public static void pinSlice(Context context, Uri uri, Set<SliceSpec> supportedSpecs) {
        ProviderHolder holder = SliceProviderCompat.acquireClient(context.getContentResolver(), uri);
        if (holder.mProvider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
            extras.putString(EXTRA_PKG, context.getPackageName());
            SliceProviderCompat.addSpecs(extras, supportedSpecs);
            holder.mProvider.call(METHOD_PIN, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to pin slice", (Throwable)e);
        }
    }

    public static void unpinSlice(Context context, Uri uri, Set<SliceSpec> supportedSpecs) {
        if (SliceProviderCompat.getPinnedSlices(context).contains(uri)) {
            ProviderHolder holder = SliceProviderCompat.acquireClient(context.getContentResolver(), uri);
            if (holder.mProvider == null) {
                throw new IllegalArgumentException("Unknown URI " + uri);
            }
            try {
                Bundle extras = new Bundle();
                extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
                extras.putString(EXTRA_PKG, context.getPackageName());
                SliceProviderCompat.addSpecs(extras, supportedSpecs);
                holder.mProvider.call(METHOD_UNPIN, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
            }
            catch (RemoteException e) {
                Log.e((String)TAG, (String)"Unable to unpin slice", (Throwable)e);
            }
        }
    }

    public static Set<SliceSpec> getPinnedSpecs(Context context, Uri uri) {
        ProviderHolder holder = SliceProviderCompat.acquireClient(context.getContentResolver(), uri);
        if (holder.mProvider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
            Bundle res = holder.mProvider.call(METHOD_GET_PINNED_SPECS, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
            if (res != null) {
                return SliceProviderCompat.getSpecs(res);
            }
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to get pinned specs", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Uri mapIntentToUri(Context context, Intent intent) {
        List providers;
        Preconditions.checkNotNull((Object)intent, (Object)"intent");
        Preconditions.checkArgument((intent.getComponent() != null || intent.getPackage() != null || intent.getData() != null ? 1 : 0) != 0, (Object)String.format("Slice intent must be explicit %s", intent));
        ContentResolver resolver = context.getContentResolver();
        Uri intentData = intent.getData();
        if (intentData != null && "vnd.android.slice".equals(resolver.getType(intentData))) {
            return intentData;
        }
        Intent queryIntent = new Intent(intent);
        if (!queryIntent.hasCategory("android.app.slice.category.SLICE")) {
            queryIntent.addCategory("android.app.slice.category.SLICE");
        }
        if ((providers = context.getPackageManager().queryIntentContentProviders(queryIntent, 0)) == null || providers.isEmpty()) {
            ResolveInfo resolve = context.getPackageManager().resolveActivity(intent, 128);
            if (resolve == null) return null;
            if (resolve.activityInfo == null) return null;
            if (resolve.activityInfo.metaData == null) return null;
            if (!resolve.activityInfo.metaData.containsKey("android.metadata.SLICE_URI")) return null;
            return Uri.parse((String)resolve.activityInfo.metaData.getString("android.metadata.SLICE_URI"));
        }
        String authority = ((ResolveInfo)providers.get((int)0)).providerInfo.authority;
        Uri uri2 = new Uri.Builder().scheme("content").authority(authority).build();
        try (ProviderHolder holder = SliceProviderCompat.acquireClient(resolver, uri2);){
            if (holder.mProvider == null) {
                throw new IllegalArgumentException("Unknown URI " + uri2);
            }
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_INTENT, (Parcelable)intent);
            Bundle res = holder.mProvider.call(METHOD_MAP_ONLY_INTENT, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
            if (res == null) return null;
            Uri uri = (Uri)res.getParcelable(EXTRA_SLICE);
            return uri;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to map slice", (Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    public static Collection<Uri> getSliceDescendants(Context context, @NonNull Uri uri) {
        ContentResolver resolver = context.getContentResolver();
        try (ProviderHolder holder = SliceProviderCompat.acquireClient(resolver, uri);){
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
            Bundle res = holder.mProvider.call(METHOD_GET_DESCENDANTS, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
            if (res == null) return Collections.emptyList();
            ArrayList arrayList = res.getParcelableArrayList(EXTRA_SLICE_DESCENDANTS);
            return arrayList;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to get slice descendants", (Throwable)e);
        }
        return Collections.emptyList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int checkSlicePermission(Context context, String packageName, Uri uri, int pid, int uid) {
        ContentResolver resolver = context.getContentResolver();
        try (ProviderHolder holder = SliceProviderCompat.acquireClient(resolver, uri);){
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
            extras.putString(EXTRA_PKG, packageName);
            extras.putInt(EXTRA_PID, pid);
            extras.putInt(EXTRA_UID, uid);
            Bundle res = holder.mProvider.call(METHOD_CHECK_PERMISSION, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
            if (res == null) return -1;
            int n = res.getInt(EXTRA_RESULT);
            return n;
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to check slice permission", (Throwable)e);
        }
        return -1;
    }

    public static void grantSlicePermission(Context context, String packageName, String toPackage, Uri uri) {
        ContentResolver resolver = context.getContentResolver();
        try (ProviderHolder holder = SliceProviderCompat.acquireClient(resolver, uri);){
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
            extras.putString(EXTRA_PROVIDER_PKG, packageName);
            extras.putString(EXTRA_PKG, toPackage);
            holder.mProvider.call(METHOD_GRANT_PERMISSION, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to get slice descendants", (Throwable)e);
        }
    }

    public static void revokeSlicePermission(Context context, String packageName, String toPackage, Uri uri) {
        ContentResolver resolver = context.getContentResolver();
        try (ProviderHolder holder = SliceProviderCompat.acquireClient(resolver, uri);){
            Bundle extras = new Bundle();
            extras.putParcelable(EXTRA_BIND_URI, (Parcelable)uri);
            extras.putString(EXTRA_PROVIDER_PKG, packageName);
            extras.putString(EXTRA_PKG, toPackage);
            holder.mProvider.call(METHOD_REVOKE_PERMISSION, ARG_SUPPORTS_VERSIONED_PARCELABLE, extras);
        }
        catch (RemoteException e) {
            Log.e((String)TAG, (String)"Unable to get slice descendants", (Throwable)e);
        }
    }

    public static List<Uri> getPinnedSlices(Context context) {
        ArrayList<Uri> pinnedSlices = new ArrayList<Uri>();
        SharedPreferences prefs = context.getSharedPreferences(ALL_FILES, 0);
        Set prefSet = prefs.getStringSet(ALL_FILES, Collections.emptySet());
        for (String pref : prefSet) {
            pinnedSlices.addAll(new CompatPinnedList(context, pref).getPinnedSlices());
        }
        return pinnedSlices;
    }

    private static ProviderHolder acquireClient(ContentResolver resolver, Uri uri) {
        ContentProviderClient provider = resolver.acquireUnstableContentProviderClient(uri);
        if (provider == null) {
            throw new IllegalArgumentException("No provider found for " + uri);
        }
        return new ProviderHolder(provider);
    }

    private static class ProviderHolder
    implements AutoCloseable {
        final ContentProviderClient mProvider;

        ProviderHolder(ContentProviderClient provider) {
            this.mProvider = provider;
        }

        @Override
        public void close() {
            if (this.mProvider == null) {
                return;
            }
            if (Build.VERSION.SDK_INT >= 24) {
                this.mProvider.close();
            } else {
                this.mProvider.release();
            }
        }
    }
}

