/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.compat;

import android.app.slice.Slice;
import android.app.slice.SliceSpec;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.SliceConvert;
import androidx.slice.SliceProvider;
import java.util.Collection;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SliceProviderWrapperContainer {
    private SliceProviderWrapperContainer() {
    }

    @RequiresApi(value=28)
    public static class SliceProviderWrapper
    extends android.app.slice.SliceProvider {
        private static final String TAG = "SliceProviderWrapper";
        private SliceProvider mSliceProvider;

        public SliceProviderWrapper(SliceProvider provider, String[] autoGrantPermissions) {
            super(autoGrantPermissions);
            this.mSliceProvider = provider;
        }

        public void attachInfo(Context context, ProviderInfo info) {
            this.mSliceProvider.attachInfo(context, info);
            super.attachInfo(context, info);
        }

        public boolean onCreate() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Slice onBindSlice(Uri sliceUri, Set<SliceSpec> supportedVersions) {
            SliceProvider.setSpecs(SliceConvert.wrap(supportedVersions));
            try {
                Slice slice = SliceConvert.unwrap(this.mSliceProvider.onBindSlice(sliceUri));
                return slice;
            }
            catch (Exception e) {
                Log.wtf((String)TAG, (String)("Slice with URI " + sliceUri.toString() + " is invalid."), (Throwable)e);
                Slice slice = null;
                return slice;
            }
            finally {
                SliceProvider.setSpecs(null);
            }
        }

        public void onSlicePinned(Uri sliceUri) {
            this.mSliceProvider.onSlicePinned(sliceUri);
            this.mSliceProvider.handleSlicePinned(sliceUri);
        }

        public void onSliceUnpinned(Uri sliceUri) {
            this.mSliceProvider.onSliceUnpinned(sliceUri);
            this.mSliceProvider.handleSliceUnpinned(sliceUri);
        }

        public Collection<Uri> onGetSliceDescendants(Uri uri) {
            return this.mSliceProvider.onGetSliceDescendants(uri);
        }

        @NonNull
        public Uri onMapIntentToUri(Intent intent) {
            return this.mSliceProvider.onMapIntentToUri(intent);
        }
    }
}

