/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.core;

import android.app.PendingIntent;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.drawable.IconCompat;
import androidx.slice.Slice;
import androidx.slice.SliceItem;
import androidx.slice.core.SliceAction;
import androidx.slice.core.SliceQuery;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=19)
public class SliceActionImpl
implements SliceAction {
    private PendingIntent mAction;
    private IconCompat mIcon;
    private int mImageMode = 3;
    private CharSequence mTitle;
    private CharSequence mContentDescription;
    private boolean mIsToggle;
    private boolean mIsChecked;
    private int mPriority = -1;
    private SliceItem mSliceItem;
    private SliceItem mActionItem;
    private boolean mIsActivity;

    public SliceActionImpl(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, @NonNull CharSequence actionTitle) {
        this(action, actionIcon, 0, actionTitle);
    }

    public SliceActionImpl(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, int imageMode, @NonNull CharSequence actionTitle) {
        this.mAction = action;
        this.mIcon = actionIcon;
        this.mTitle = actionTitle;
        this.mImageMode = imageMode;
    }

    public SliceActionImpl(@NonNull PendingIntent action, @NonNull IconCompat actionIcon, @NonNull CharSequence actionTitle, boolean isChecked) {
        this(action, actionIcon, 0, actionTitle);
        this.mIsChecked = isChecked;
        this.mIsToggle = true;
    }

    public SliceActionImpl(@NonNull PendingIntent action, @NonNull CharSequence actionTitle, boolean isChecked) {
        this.mAction = action;
        this.mTitle = actionTitle;
        this.mIsToggle = true;
        this.mIsChecked = isChecked;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public SliceActionImpl(SliceItem slice) {
        SliceItem cdItem;
        SliceItem titleItem;
        this.mSliceItem = slice;
        SliceItem actionItem = SliceQuery.find(slice, "action");
        if (actionItem == null) {
            return;
        }
        this.mActionItem = actionItem;
        this.mAction = actionItem.getAction();
        SliceItem iconItem = SliceQuery.find(actionItem.getSlice(), "image");
        if (iconItem != null) {
            this.mIcon = iconItem.getIcon();
            int n = iconItem.hasHint("no_tint") ? (iconItem.hasHint("large") ? 2 : 1) : (this.mImageMode = 0);
        }
        if ((titleItem = SliceQuery.find(actionItem.getSlice(), "text", "title", null)) != null) {
            this.mTitle = titleItem.getText();
        }
        if ((cdItem = SliceQuery.findSubtype(actionItem.getSlice(), "text", "content_description")) != null) {
            this.mContentDescription = cdItem.getText();
        }
        this.mIsToggle = "toggle".equals(actionItem.getSubType());
        if (this.mIsToggle) {
            this.mIsChecked = actionItem.hasHint("selected");
        }
        this.mIsActivity = this.mSliceItem.hasHint("activity");
        SliceItem priority = SliceQuery.findSubtype(actionItem.getSlice(), "int", "priority");
        this.mPriority = priority != null ? priority.getInt() : -1;
    }

    @Override
    @Nullable
    public SliceActionImpl setContentDescription(@NonNull CharSequence description) {
        this.mContentDescription = description;
        return this;
    }

    @Override
    public SliceActionImpl setChecked(boolean isChecked) {
        this.mIsChecked = isChecked;
        return this;
    }

    @Override
    public SliceActionImpl setPriority(@IntRange(from=0L) int priority) {
        this.mPriority = priority;
        return this;
    }

    @Override
    @NonNull
    public PendingIntent getAction() {
        return this.mAction != null ? this.mAction : this.mActionItem.getAction();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public SliceItem getActionItem() {
        return this.mActionItem;
    }

    @Override
    @Nullable
    public IconCompat getIcon() {
        return this.mIcon;
    }

    @Override
    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Override
    @Nullable
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @Override
    public int getPriority() {
        return this.mPriority;
    }

    @Override
    public boolean isToggle() {
        return this.mIsToggle;
    }

    @Override
    public boolean isChecked() {
        return this.mIsChecked;
    }

    @Override
    public int getImageMode() {
        return this.mImageMode;
    }

    @Override
    public boolean isDefaultToggle() {
        return this.mIsToggle && this.mIcon == null;
    }

    @Nullable
    public SliceItem getSliceItem() {
        return this.mSliceItem;
    }

    @Override
    public boolean isActivity() {
        return this.mIsActivity;
    }

    @NonNull
    public Slice buildSlice(@NonNull Slice.Builder builder) {
        return builder.addHints("shortcut").addAction(this.mAction, this.buildSliceContent(builder).build(), this.getSubtype()).build();
    }

    @NonNull
    public Slice buildPrimaryActionSlice(@NonNull Slice.Builder builder) {
        return this.buildSliceContent(builder).addHints("shortcut", "title").build();
    }

    private Slice.Builder buildSliceContent(@NonNull Slice.Builder builder) {
        Slice.Builder sb = new Slice.Builder(builder);
        if (this.mIcon != null) {
            String[] stringArray;
            if (this.mImageMode == 0) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = "no_tint";
            }
            String[] hints = stringArray;
            sb.addIcon(this.mIcon, null, hints);
        }
        if (this.mTitle != null) {
            sb.addText(this.mTitle, null, "title");
        }
        if (this.mContentDescription != null) {
            sb.addText(this.mContentDescription, "content_description", new String[0]);
        }
        if (this.mIsToggle && this.mIsChecked) {
            sb.addHints("selected");
        }
        if (this.mPriority != -1) {
            sb.addInt(this.mPriority, "priority", new String[0]);
        }
        if (this.mIsActivity) {
            builder.addHints("activity");
        }
        return sb;
    }

    @Nullable
    public String getSubtype() {
        return this.mIsToggle ? "toggle" : null;
    }

    public void setActivity(boolean isActivity) {
        this.mIsActivity = isActivity;
    }
}

