/*
 * Decompiled with CFR 0.152.
 */
package androidx.slice.core;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.slice.Slice;
import androidx.slice.SliceItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=19)
public class SliceQuery {
    public static boolean hasAnyHints(SliceItem item, String ... hints) {
        if (hints == null) {
            return false;
        }
        List<String> itemHints = item.getHints();
        for (String hint : hints) {
            if (!itemHints.contains(hint)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHints(SliceItem item, String ... hints) {
        if (hints == null) {
            return true;
        }
        List<String> itemHints = item.getHints();
        for (String hint : hints) {
            if (TextUtils.isEmpty((CharSequence)hint) || itemHints.contains(hint)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasHints(Slice item, String ... hints) {
        if (hints == null) {
            return true;
        }
        List<String> itemHints = item.getHints();
        for (String hint : hints) {
            if (TextUtils.isEmpty((CharSequence)hint) || itemHints.contains(hint)) continue;
            return false;
        }
        return true;
    }

    public static SliceItem findNotContaining(SliceItem container, List<SliceItem> list) {
        SliceItem ret = null;
        while (ret == null && list.size() != 0) {
            SliceItem remove = list.remove(0);
            if (SliceQuery.contains(container, remove)) continue;
            ret = remove;
        }
        return ret;
    }

    private static boolean contains(SliceItem container, final SliceItem item) {
        if (container == null || item == null) {
            return false;
        }
        return SliceQuery.findFirst(SliceQuery.filter(SliceQuery.stream(container), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem s) {
                return s == item;
            }
        }), null) != null;
    }

    public static List<SliceItem> findAll(SliceItem s, String format) {
        return SliceQuery.findAll(s, format, (String[])null, null);
    }

    public static List<SliceItem> findAll(Slice s, String format, String hints, String nonHints) {
        return SliceQuery.findAll(s, format, new String[]{hints}, new String[]{nonHints});
    }

    public static List<SliceItem> findAll(SliceItem s, String format, String hints, String nonHints) {
        return SliceQuery.findAll(s, format, new String[]{hints}, new String[]{nonHints});
    }

    public static List<SliceItem> findAll(Slice s, final String format, final String[] hints, final String[] nonHints) {
        return SliceQuery.collect(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem item) {
                return SliceQuery.checkFormat(item, format) && SliceQuery.hasHints(item, hints) && !SliceQuery.hasAnyHints(item, nonHints);
            }
        }));
    }

    public static List<SliceItem> findAll(SliceItem s, final String format, final String[] hints, final String[] nonHints) {
        return SliceQuery.collect(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem item) {
                return SliceQuery.checkFormat(item, format) && SliceQuery.hasHints(item, hints) && !SliceQuery.hasAnyHints(item, nonHints);
            }
        }));
    }

    public static SliceItem find(Slice s, String format, String hints, String nonHints) {
        return SliceQuery.find(s, format, new String[]{hints}, new String[]{nonHints});
    }

    public static SliceItem find(Slice s, String format) {
        return SliceQuery.find(s, format, (String[])null, null);
    }

    public static SliceItem find(SliceItem s, String format) {
        return SliceQuery.find(s, format, (String[])null, null);
    }

    public static SliceItem find(SliceItem s, String format, String hints, String nonHints) {
        return SliceQuery.find(s, format, new String[]{hints}, new String[]{nonHints});
    }

    public static SliceItem find(Slice s, final String format, final String[] hints, final String[] nonHints) {
        return SliceQuery.findFirst(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem item) {
                return SliceQuery.checkFormat(item, format) && SliceQuery.hasHints(item, hints) && !SliceQuery.hasAnyHints(item, nonHints);
            }
        }), null);
    }

    public static SliceItem findSubtype(Slice s, final String format, final String subtype) {
        return SliceQuery.findFirst(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem item) {
                return SliceQuery.checkFormat(item, format) && SliceQuery.checkSubtype(item, subtype);
            }
        }), null);
    }

    public static SliceItem findSubtype(SliceItem s, final String format, final String subtype) {
        return SliceQuery.findFirst(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem item) {
                return SliceQuery.checkFormat(item, format) && SliceQuery.checkSubtype(item, subtype);
            }
        }), null);
    }

    public static SliceItem find(SliceItem s, final String format, final String[] hints, final String[] nonHints) {
        return SliceQuery.findFirst(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem item) {
                return SliceQuery.checkFormat(item, format) && SliceQuery.hasHints(item, hints) && !SliceQuery.hasAnyHints(item, nonHints);
            }
        }), null);
    }

    static boolean checkFormat(SliceItem item, String format) {
        return format == null || format.equals(item.getFormat());
    }

    static boolean checkSubtype(SliceItem item, String subtype) {
        return subtype == null || subtype.equals(item.getSubType());
    }

    public static Iterator<SliceItem> stream(SliceItem slice) {
        ArrayList<SliceItem> items = new ArrayList<SliceItem>();
        items.add(slice);
        return SliceQuery.getSliceItemStream(items);
    }

    public static Iterator<SliceItem> stream(Slice slice) {
        ArrayList<SliceItem> items = new ArrayList<SliceItem>();
        if (slice != null) {
            items.addAll(slice.getItems());
        }
        return SliceQuery.getSliceItemStream(items);
    }

    private static Iterator<SliceItem> getSliceItemStream(final ArrayList<SliceItem> items) {
        return new Iterator<SliceItem>(){

            @Override
            public boolean hasNext() {
                return items.size() != 0;
            }

            @Override
            public SliceItem next() {
                SliceItem item = (SliceItem)((Object)items.remove(0));
                if ("slice".equals(item.getFormat()) || "action".equals(item.getFormat())) {
                    items.addAll(item.getSlice().getItems());
                }
                return item;
            }
        };
    }

    public static SliceItem findTopLevelItem(Slice s, String format, String subtype, String[] hints, String[] nonHints) {
        List<SliceItem> items = s.getItems();
        for (int i = 0; i < items.size(); ++i) {
            SliceItem item = items.get(i);
            if (!SliceQuery.checkFormat(item, format) || !SliceQuery.checkSubtype(item, subtype) || !SliceQuery.hasHints(item, hints) || SliceQuery.hasAnyHints(item, nonHints)) continue;
            return item;
        }
        return null;
    }

    private static <T> List<T> collect(Iterator<T> iter) {
        ArrayList<T> list = new ArrayList<T>();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    private static <T> Iterator<T> filter(final Iterator<T> input, final Filter<T> f) {
        return new Iterator<T>(){
            T mNext = this.findNext();

            private T findNext() {
                while (input.hasNext()) {
                    Object i = input.next();
                    if (!f.filter(i)) continue;
                    return i;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mNext != null;
            }

            @Override
            public T next() {
                Object ret = this.mNext;
                this.mNext = this.findNext();
                return ret;
            }
        };
    }

    private static <T> T findFirst(Iterator<T> filter, T def) {
        while (filter.hasNext()) {
            T r = filter.next();
            if (r == null) continue;
            return r;
        }
        return def;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static SliceItem findItem(Slice s, final Uri uri) {
        return SliceQuery.findFirst(SliceQuery.filter(SliceQuery.stream(s), new Filter<SliceItem>(){

            @Override
            public boolean filter(SliceItem input) {
                if ("action".equals(input.getFormat()) || "slice".equals(input.getFormat())) {
                    return uri.equals((Object)input.getSlice().getUri());
                }
                return false;
            }
        }), null);
    }

    private SliceQuery() {
    }

    private static interface Filter<T> {
        public boolean filter(T var1);
    }
}

