/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.core.app;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.ContentResolver;
import android.content.Intent;
import android.os.Looper;
import android.provider.Settings;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.lifecycle.Lifecycle;
import androidx.test.core.app.ActivityScenario$$Lambda$0;
import androidx.test.core.app.ActivityScenario$$Lambda$1;
import androidx.test.core.app.ActivityScenario$$Lambda$2;
import androidx.test.core.app.ActivityScenario$$Lambda$3;
import androidx.test.core.app.ActivityScenario$$Lambda$4;
import androidx.test.core.app.InstrumentationActivityInvoker;
import androidx.test.internal.platform.ServiceLoaderWrapper;
import androidx.test.internal.platform.app.ActivityInvoker;
import androidx.test.internal.platform.os.ControlledLooper;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.runner.lifecycle.ActivityLifecycleCallback;
import androidx.test.runner.lifecycle.ActivityLifecycleMonitorRegistry;
import androidx.test.runner.lifecycle.Stage;
import java.io.Closeable;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public final class ActivityScenario<A extends Activity>
implements AutoCloseable,
Closeable {
    private static final String TAG = ActivityScenario.class.getSimpleName();
    private static final long TIMEOUT_MILLISECONDS = 45000L;
    private static final Map<Stage, Lifecycle.State> STEADY_STATES = new EnumMap<Stage, Lifecycle.State>(Stage.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition stateChangedCondition = this.lock.newCondition();
    private final Intent startActivityIntent;
    private final ActivityInvoker activityInvoker;
    private final ControlledLooper controlledLooper;
    @GuardedBy(value="lock")
    private Stage currentActivityStage;
    @GuardedBy(value="lock")
    @Nullable
    private A currentActivity;
    private final ActivityLifecycleCallback activityLifecycleObserver;

    private ActivityScenario(Intent startActivityIntent) {
        this.activityInvoker = (ActivityInvoker)ServiceLoaderWrapper.loadSingleService(ActivityInvoker.class, (ServiceLoaderWrapper.Factory)ActivityScenario$$Lambda$0.$instance);
        this.controlledLooper = (ControlledLooper)ServiceLoaderWrapper.loadSingleService(ControlledLooper.class, (ServiceLoaderWrapper.Factory)ActivityScenario$$Lambda$1.$instance);
        this.currentActivityStage = Stage.PRE_ON_CREATE;
        this.activityLifecycleObserver = new ActivityLifecycleCallback(){

            public void onActivityLifecycleChanged(Activity activity, Stage stage) {
                if (!ActivityScenario.this.startActivityIntent.filterEquals(activity.getIntent())) {
                    Log.v((String)TAG, (String)String.format("Activity lifecycle changed event received but ignored because the intent does not match. startActivityIntent=%s, activity.getIntent()=%s, activity=%s", ActivityScenario.this.startActivityIntent, activity.getIntent(), activity));
                    return;
                }
                ActivityScenario.this.lock.lock();
                try {
                    switch (ActivityScenario.this.currentActivityStage) {
                        case PRE_ON_CREATE: 
                        case DESTROYED: {
                            if (stage == Stage.CREATED) break;
                            Log.v((String)TAG, (String)String.format("Activity lifecycle changed event received but ignored because the reported transition was not ON_CREATE while the last known transition was %s", ActivityScenario.this.currentActivityStage));
                            return;
                        }
                        default: {
                            if (ActivityScenario.this.currentActivity == activity) break;
                            Log.v((String)TAG, (String)String.format("Activity lifecycle changed event received but ignored because the activity instance does not match. currentActivity=%s, receivedActivity=%s", ActivityScenario.this.currentActivity, activity));
                            return;
                        }
                    }
                    ActivityScenario.this.currentActivityStage = stage;
                    ActivityScenario.this.currentActivity = (Activity)(stage != Stage.DESTROYED ? activity : null);
                    Log.v((String)TAG, (String)String.format("Update currentActivityStage to %s, currentActivity=%s", ActivityScenario.this.currentActivityStage, ActivityScenario.this.currentActivity));
                    ActivityScenario.this.stateChangedCondition.signal();
                }
                finally {
                    ActivityScenario.this.lock.unlock();
                }
            }
        };
        this.startActivityIntent = (Intent)Checks.checkNotNull((Object)startActivityIntent);
    }

    private ActivityScenario(Class<A> activityClass) {
        this.activityInvoker = (ActivityInvoker)ServiceLoaderWrapper.loadSingleService(ActivityInvoker.class, (ServiceLoaderWrapper.Factory)ActivityScenario$$Lambda$2.$instance);
        this.controlledLooper = (ControlledLooper)ServiceLoaderWrapper.loadSingleService(ControlledLooper.class, (ServiceLoaderWrapper.Factory)ActivityScenario$$Lambda$3.$instance);
        this.currentActivityStage = Stage.PRE_ON_CREATE;
        this.activityLifecycleObserver = new /* invalid duplicate definition of identical inner class */;
        this.startActivityIntent = (Intent)Checks.checkNotNull((Object)this.activityInvoker.getIntentForActivity((Class)Checks.checkNotNull(activityClass)));
    }

    public static <A extends Activity> ActivityScenario<A> launch(Class<A> activityClass) {
        ActivityScenario<A> scenario = new ActivityScenario<A>((Class)Checks.checkNotNull(activityClass));
        super.launchInternal();
        return scenario;
    }

    public static <A extends Activity> ActivityScenario<A> launch(Intent startActivityIntent) {
        ActivityScenario<A> scenario = new ActivityScenario<A>((Intent)Checks.checkNotNull((Object)startActivityIntent));
        super.launchInternal();
        return scenario;
    }

    private void launchInternal() {
        Checks.checkState((Settings.System.getInt((ContentResolver)InstrumentationRegistry.getInstrumentation().getTargetContext().getContentResolver(), (String)"always_finish_activities", (int)0) == 0 ? 1 : 0) != 0, (Object)"\"Don't keep activities\" developer options must be disabled for ActivityScenario");
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityLifecycleMonitorRegistry.getInstance().addLifecycleCallback(this.activityLifecycleObserver);
        this.activityInvoker.startActivity(this.startActivityIntent);
        this.waitForActivityToBecomeAnyOf(STEADY_STATES.values().toArray(new Lifecycle.State[0]));
    }

    @Override
    public void close() {
        this.moveToState(Lifecycle.State.DESTROYED);
        ActivityLifecycleMonitorRegistry.getInstance().removeLifecycleCallback(this.activityLifecycleObserver);
    }

    private void waitForActivityToBecomeAnyOf(Lifecycle.State ... expectedStates) {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        HashSet<Lifecycle.State> expectedStateSet = new HashSet<Lifecycle.State>(Arrays.asList(expectedStates));
        this.lock.lock();
        try {
            if (expectedStateSet.contains(STEADY_STATES.get(this.currentActivityStage))) {
                return;
            }
            long now = System.currentTimeMillis();
            long deadline = now + 45000L;
            while (now < deadline && !expectedStateSet.contains(STEADY_STATES.get(this.currentActivityStage))) {
                this.stateChangedCondition.await(deadline - now, TimeUnit.MILLISECONDS);
                now = System.currentTimeMillis();
            }
            if (!expectedStateSet.contains(STEADY_STATES.get(this.currentActivityStage))) {
                throw new AssertionError((Object)String.format("Activity never becomes requested state \"%s\" (last lifecycle transition = \"%s\")", expectedStateSet, this.currentActivityStage));
            }
        }
        catch (InterruptedException e) {
            throw new AssertionError(String.format("Activity never becomes requested state \"%s\" (last lifecycle transition = \"%s\")", expectedStateSet, this.currentActivityStage), e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private ActivityState<A> getCurrentActivityState() {
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        this.lock.lock();
        try {
            ActivityState<A> activityState = new ActivityState<A>(this.currentActivity, STEADY_STATES.get(this.currentActivityStage), this.currentActivityStage);
            return activityState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ActivityScenario<A> moveToState(Lifecycle.State newState) {
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityState<A> currentState = this.getCurrentActivityState();
        Checks.checkNotNull((Object)currentState.state, (Object)String.format("Current state was null unexpectedly. Last stage = %s", currentState.stage));
        if (currentState.state == newState) {
            return this;
        }
        Checks.checkState((currentState.state != Lifecycle.State.DESTROYED && currentState.activity != null ? 1 : 0) != 0, (Object)String.format("Cannot move to state \"%s\" since the Activity has been destroyed already", newState));
        switch (newState) {
            case CREATED: {
                this.activityInvoker.stopActivity(currentState.activity);
                break;
            }
            case STARTED: {
                this.moveToState(Lifecycle.State.RESUMED);
                this.activityInvoker.pauseActivity(currentState.activity);
                break;
            }
            case RESUMED: {
                this.activityInvoker.resumeActivity(currentState.activity);
                break;
            }
            case DESTROYED: {
                this.activityInvoker.finishActivity(currentState.activity);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("A requested state \"%s\" is not supported", newState));
            }
        }
        this.waitForActivityToBecomeAnyOf(newState);
        return this;
    }

    public ActivityScenario<A> recreate() {
        ActivityState<A> activityState;
        Checks.checkNotMainThread();
        InstrumentationRegistry.getInstrumentation().waitForIdleSync();
        ActivityState<A> prevActivityState = this.getCurrentActivityState();
        Checks.checkNotNull(prevActivityState.activity);
        Checks.checkNotNull((Object)prevActivityState.state);
        this.moveToState(Lifecycle.State.RESUMED);
        this.activityInvoker.recreateActivity(prevActivityState.activity);
        long now = System.currentTimeMillis();
        long deadline = now + 45000L;
        do {
            this.waitForActivityToBecomeAnyOf(Lifecycle.State.RESUMED);
            now = System.currentTimeMillis();
            activityState = this.getCurrentActivityState();
        } while (now < deadline && activityState.activity == prevActivityState.activity);
        if (activityState.activity == prevActivityState.activity) {
            throw new IllegalStateException("Requested a re-creation of Activity but didn't happen");
        }
        this.moveToState(prevActivityState.state);
        return this;
    }

    public ActivityScenario<A> onActivity(ActivityAction<A> action) {
        ActivityScenario$$Lambda$4 runnableAction = new ActivityScenario$$Lambda$4(this, action);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.controlledLooper.drainMainThreadUntilIdle();
            runnableAction.run();
        } else {
            InstrumentationRegistry.getInstrumentation().waitForIdleSync();
            InstrumentationRegistry.getInstrumentation().runOnMainSync((Runnable)runnableAction);
        }
        return this;
    }

    public Instrumentation.ActivityResult getResult() {
        return this.activityInvoker.getActivityResult();
    }

    public Lifecycle.State getState() {
        return (Lifecycle.State)Checks.checkNotNull((Object)this.getCurrentActivityState().state, (Object)"Could not get current state due to the transition is incomplete.");
    }

    final /* synthetic */ void lambda$onActivity$2$ActivityScenario(ActivityAction action) {
        Checks.checkMainThread();
        this.lock.lock();
        try {
            Checks.checkNotNull(this.currentActivity, (Object)"Cannot run onActivity since Activity has been destroyed already");
            action.perform(this.currentActivity);
        }
        finally {
            this.lock.unlock();
        }
    }

    static final /* synthetic */ ControlledLooper lambda$new$1$ActivityScenario() {
        return ControlledLooper.NO_OP_CONTROLLED_LOOPER;
    }

    static final /* synthetic */ ActivityInvoker lambda$new$0$ActivityScenario() {
        return new InstrumentationActivityInvoker();
    }

    static {
        STEADY_STATES.put(Stage.RESUMED, Lifecycle.State.RESUMED);
        STEADY_STATES.put(Stage.PAUSED, Lifecycle.State.STARTED);
        STEADY_STATES.put(Stage.STOPPED, Lifecycle.State.CREATED);
        STEADY_STATES.put(Stage.DESTROYED, Lifecycle.State.DESTROYED);
    }

    public static interface ActivityAction<A extends Activity> {
        public void perform(A var1);
    }

    private static class ActivityState<A extends Activity> {
        @Nullable
        final A activity;
        @Nullable
        final Lifecycle.State state;
        final Stage stage;

        ActivityState(@Nullable A activity, @Nullable Lifecycle.State state, Stage stage) {
            this.activity = activity;
            this.state = state;
            this.stage = stage;
        }
    }
}

