/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent;

import android.app.Instrumentation;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Looper;
import android.util.Pair;
import androidx.test.espresso.intent.ActivityResultFunction;
import androidx.test.espresso.intent.Checks;
import androidx.test.espresso.intent.ResettingStubber;
import androidx.test.espresso.intent.ResettingStubberImpl$$ExternalSyntheticLambda0;
import androidx.test.espresso.intent.ResolvedIntent;
import androidx.test.espresso.intent.ResolvedIntentImpl;
import androidx.test.platform.app.InstrumentationRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.hamcrest.Matcher;

public final class ResettingStubberImpl
implements ResettingStubber {
    private List<Pair<Matcher<Intent>, ActivityResultFunction>> intentResponsePairs = new ArrayList<Pair<Matcher<Intent>, ActivityResultFunction>>();
    private PackageManager packageManager;
    private boolean isInitialized;

    public Instrumentation.ActivityResult getActivityResultForIntent(Intent intent) {
        Checks.checkState(this.isInitialized, "ResettingStubber must be initialized before calling this method");
        Checks.checkNotNull(intent);
        ResettingStubberImpl.checkMain();
        ListIterator<Pair<Matcher<Intent>, ActivityResultFunction>> reverseIterator = this.intentResponsePairs.listIterator(this.intentResponsePairs.size());
        while (reverseIterator.hasPrevious()) {
            Pair<Matcher<Intent>, ActivityResultFunction> pair = reverseIterator.previous();
            if (!((Matcher)pair.first).matches((Object)this.resolveIntent(intent))) continue;
            return ((ActivityResultFunction)pair.second).apply(intent);
        }
        return null;
    }

    static /* synthetic */ Instrumentation.ActivityResult lambda$setActivityResultForIntent$0(Instrumentation.ActivityResult result, Intent intent) {
        return result;
    }

    ResolvedIntent resolveIntent(Intent intent) {
        ArrayList<ResolveInfo> resolveInfos = this.packageManager.queryIntentActivities(intent, 0);
        if (null == resolveInfos) {
            resolveInfos = new ArrayList<ResolveInfo>();
        }
        return new ResolvedIntentImpl(intent, resolveInfos);
    }

    private static void checkMain() {
        Checks.checkState(Looper.myLooper() == Looper.getMainLooper(), "Must be called on main thread.");
    }

    @Override
    public void initialize() {
        this.packageManager = InstrumentationRegistry.getInstrumentation().getTargetContext().getPackageManager();
        this.isInitialized = true;
    }

    @Override
    public void reset() {
        ResettingStubberImpl.checkMain();
        this.intentResponsePairs.clear();
        this.isInitialized = false;
    }

    @Override
    public void setActivityResultForIntent(Matcher<Intent> matcher, Instrumentation.ActivityResult result) {
        Instrumentation.ActivityResult activityResult = result;
        this.setActivityResultFunctionForIntent(matcher, new ResettingStubberImpl$$ExternalSyntheticLambda0(activityResult));
    }

    @Override
    public void setActivityResultFunctionForIntent(Matcher<Intent> matcher, ActivityResultFunction result) {
        Checks.checkState(this.isInitialized, "ResettingStubber must be initialized before calling this method");
        Checks.checkNotNull(matcher);
        ResettingStubberImpl.checkMain();
        this.intentResponsePairs.add((Pair<Matcher<Intent>, ActivityResultFunction>)new Pair(matcher, (Object)result));
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }
}

