/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent.matcher;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.test.espresso.intent.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

@CheckReturnValue
public final class BundleMatchers {
    @NonNull
    public static Matcher<Bundle> doesNotHaveKey(@NonNull String key) {
        return BundleMatchers.doesNotHaveKey((Matcher<String>)Matchers.is((Object)key));
    }

    @NonNull
    public static Matcher<Bundle> doesNotHaveKey(@NonNull Matcher<String> keyMatcher) {
        return new BundleMatcher(keyMatcher, Matchers.anything(), false);
    }

    public static <T> Matcher<Bundle> hasEntry(String key, T value) {
        return BundleMatchers.hasEntry((Matcher<String>)Matchers.is((Object)key), Matchers.is(value));
    }

    public static Matcher<Bundle> hasEntry(String key, Matcher<?> valueMatcher) {
        return BundleMatchers.hasEntry((Matcher<String>)Matchers.is((Object)key), valueMatcher);
    }

    public static Matcher<Bundle> hasEntry(Matcher<String> keyMatcher, Matcher<?> valueMatcher) {
        return new BundleMatcher(keyMatcher, valueMatcher, true);
    }

    public static Matcher<Bundle> hasKey(String key) {
        return BundleMatchers.hasKey((Matcher<String>)Matchers.is((Object)key));
    }

    public static Matcher<Bundle> hasKey(Matcher<String> keyMatcher) {
        return new BundleMatcher(keyMatcher, Matchers.anything(), true);
    }

    public static <T> Matcher<Bundle> hasValue(T value) {
        return BundleMatchers.hasValue(Matchers.is(value));
    }

    public static Matcher<Bundle> hasValue(Matcher<?> valueMatcher) {
        return new BundleMatcher((Matcher<String>)Matchers.any(String.class), valueMatcher, true);
    }

    public static Matcher<Bundle> isEmpty() {
        return new EmptyBundleMatcher();
    }

    public static Matcher<Bundle> isEmptyOrNull() {
        return Matchers.anyOf((Matcher[])new Matcher[]{Matchers.nullValue(), BundleMatchers.isEmpty()});
    }

    private BundleMatchers() {
    }

    private static final class EmptyBundleMatcher
    extends TypeSafeMatcher<Bundle> {
        private EmptyBundleMatcher() {
        }

        public void describeTo(Description description) {
            description.appendText("is empty bundle");
        }

        protected boolean matchesSafely(Bundle bundle) {
            return bundle.isEmpty();
        }
    }

    private static class BundleMatcher
    extends TypeSafeMatcher<Bundle> {
        private final Matcher<String> keyMatcher;
        private final Matcher<?> valueMatcher;
        private final boolean shouldBePresent;

        BundleMatcher(Matcher<String> keyMatcher, Matcher<?> valueMatcher, boolean shouldBePresent) {
            super(Bundle.class);
            this.keyMatcher = Checks.checkNotNull(keyMatcher);
            this.valueMatcher = Checks.checkNotNull(valueMatcher);
            this.shouldBePresent = shouldBePresent;
        }

        public void describeTo(Description description) {
            description.appendText("has bundle ");
            description.appendText(this.shouldBePresent ? "with" : "without");
            description.appendText(": key: ");
            description.appendDescriptionOf(this.keyMatcher);
            description.appendText(" value: ");
            description.appendDescriptionOf(this.valueMatcher);
        }

        public boolean matchesSafely(Bundle bundle) {
            for (String key : bundle.keySet()) {
                if (!this.keyMatcher.matches((Object)key) || !this.valueMatcher.matches(bundle.get(key))) continue;
                return this.shouldBePresent;
            }
            return !this.shouldBePresent;
        }
    }
}

