/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.intent.matcher;

import android.content.ComponentName;
import androidx.test.core.app.ApplicationProvider;
import androidx.test.espresso.intent.Checks;
import com.google.errorprone.annotations.CheckReturnValue;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

@CheckReturnValue
public final class ComponentNameMatchers {
    public static Matcher<ComponentName> hasClassName(String className) {
        return ComponentNameMatchers.hasClassName((Matcher<String>)Matchers.is((Object)className));
    }

    public static Matcher<ComponentName> hasClassName(Matcher<String> classNameMatcher) {
        return new ComponentMatcher(classNameMatcher, Matchers.any(String.class), Matchers.any(String.class));
    }

    public static Matcher<ComponentName> hasMyPackageName() {
        return ComponentNameMatchers.hasPackageName((Matcher<String>)Matchers.is((Object)ApplicationProvider.getApplicationContext().getPackageName()));
    }

    public static Matcher<ComponentName> hasPackageName(String packageName) {
        return ComponentNameMatchers.hasPackageName((Matcher<String>)Matchers.is((Object)packageName));
    }

    public static Matcher<ComponentName> hasPackageName(Matcher<String> packageNameMatcher) {
        return new ComponentMatcher(Matchers.any(String.class), packageNameMatcher, Matchers.any(String.class));
    }

    public static Matcher<ComponentName> hasShortClassName(String shortClassName) {
        return ComponentNameMatchers.hasShortClassName((Matcher<String>)Matchers.is((Object)shortClassName));
    }

    public static Matcher<ComponentName> hasShortClassName(Matcher<String> shortClassNameMatcher) {
        return new ComponentMatcher(Matchers.any(String.class), Matchers.any(String.class), shortClassNameMatcher);
    }

    private ComponentNameMatchers() {
    }

    private static class ComponentMatcher
    extends TypeSafeMatcher<ComponentName> {
        private Matcher<String> classNameMatcher;
        private Matcher<String> packageNameMatcher;
        private Matcher<String> shortClassNameMatcher;

        private ComponentMatcher(Matcher<String> classNameMatcher, Matcher<String> packageNameMatcher, Matcher<String> shortClassNameMatcher) {
            super(ComponentName.class);
            this.classNameMatcher = Checks.checkNotNull(classNameMatcher);
            this.packageNameMatcher = Checks.checkNotNull(packageNameMatcher);
            this.shortClassNameMatcher = Checks.checkNotNull(shortClassNameMatcher);
        }

        public void describeTo(Description description) {
            description.appendText("has component with: class name: ");
            description.appendDescriptionOf(this.classNameMatcher);
            description.appendText(" package name: ");
            description.appendDescriptionOf(this.packageNameMatcher);
            description.appendText(" short class name: ");
            description.appendDescriptionOf(this.shortClassNameMatcher);
        }

        public boolean matchesSafely(ComponentName componentName) {
            return this.classNameMatcher.matches((Object)componentName.getClassName()) && this.packageNameMatcher.matches((Object)componentName.getPackageName()) && this.shortClassNameMatcher.matches((Object)componentName.getShortClassName());
        }
    }
}

