/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.action;

import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.webkit.WebView;
import androidx.test.espresso.PerformException;
import androidx.test.espresso.UiController;
import androidx.test.espresso.ViewAction;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.Bindable;
import androidx.test.espresso.web.action.IAtomActionResultPropagator;
import androidx.test.espresso.web.action.JavascriptEvaluation;
import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.SettableFuture;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.ElementReference;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.WindowReference;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;

public final class AtomAction<E>
implements ViewAction,
Bindable {
    private static final String TAG = "AtomAction";
    private static final String ID = "AtomAction";
    private static final String EVALUATION_ERROR_KEY = "evaluation_error_key";
    private final SettableFuture<Evaluation> futureEval = SettableFuture.create();
    final Atom<E> atom;
    final WindowReference window;
    final ElementReference element;
    private IAtomActionResultPropagator atomActionResultPropagator = new IAtomActionResultPropagator.Stub(){

        @Override
        public void setResult(Evaluation evaluation) throws RemoteException {
            AtomAction.this.futureEval.set(evaluation);
        }

        @Override
        public void setError(Bundle bundle) throws RemoteException {
            Throwable throwable = (Throwable)bundle.getSerializable(AtomAction.EVALUATION_ERROR_KEY);
            AtomAction.this.futureEval.setException(throwable);
        }
    };

    public AtomAction(Atom<E> atom, WindowReference windowReference, ElementReference elementReference) {
        this.atom = Preconditions.checkNotNull(atom);
        this.window = windowReference;
        this.element = elementReference;
    }

    public Matcher<View> getConstraints() {
        return ViewMatchers.isJavascriptEnabled();
    }

    public String getDescription() {
        return String.format("Evaluate Atom: %s in window: %s with element: %s", this.atom, this.window, this.element);
    }

    public void perform(UiController uiController, View view) {
        WebView webView = (WebView)view;
        if (Build.VERSION.SDK_INT >= 23 && !webView.isHardwareAccelerated()) {
            throw new PerformException.Builder().withViewDescription(webView.toString()).withCause((Throwable)new RuntimeException("Hardware acceleration is not supported on current device")).build();
        }
        List<Object> list = Preconditions.checkNotNull(this.atom.getArguments(this.element));
        String string = Preconditions.checkNotNull(this.atom.getScript());
        final ListenableFuture<Evaluation> listenableFuture = JavascriptEvaluation.evaluate(webView, string, list, this.window);
        if (null != this.window && Build.VERSION.SDK_INT == 19) {
            Log.w((String)"AtomAction", (String)"WARNING: KitKat does not report when an iframe is loading new content. If you are interacting with content within an iframe and that content is changing (eg: you have just pressed a submit button). Espresso will not be able to block you until the new content has loaded (which it can do on all other API levels). You will need to have some custom polling / synchronization with the iframe in that case.");
        }
        listenableFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    AtomAction.this.atomActionResultPropagator.setResult((Evaluation)listenableFuture.get());
                }
                catch (ExecutionException executionException) {
                    AtomAction.this.reportException(executionException.getCause());
                }
                catch (InterruptedException interruptedException) {
                    AtomAction.this.reportException(interruptedException);
                }
                catch (RemoteException remoteException) {
                    AtomAction.this.reportException(remoteException);
                }
            }
        }, MoreExecutors.directExecutor());
    }

    private void reportException(Throwable throwable) {
        Bundle bundle = new Bundle();
        bundle.putSerializable(EVALUATION_ERROR_KEY, (Serializable)throwable);
        try {
            this.atomActionResultPropagator.setError(bundle);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"AtomAction", (String)"Cannot report error to result propagator", (Throwable)remoteException);
        }
    }

    public Future<E> getFuture() {
        return Futures.transform(this.futureEval, new Function<Evaluation, E>(){

            @Override
            public E apply(Evaluation evaluation) {
                return AtomAction.this.atom.transform(evaluation);
            }
        }, MoreExecutors.directExecutor());
    }

    public E get() throws ExecutionException, InterruptedException {
        Preconditions.checkState(Looper.myLooper() != Looper.getMainLooper(), "On main thread!");
        return this.getFuture().get();
    }

    public E get(long l, TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkState(Looper.myLooper() != Looper.getMainLooper(), "On main thread!");
        return this.getFuture().get(l, timeUnit);
    }

    public String getId() {
        return "AtomAction";
    }

    public IBinder getIBinder() {
        return this.atomActionResultPropagator.asBinder();
    }

    public void setIBinder(IBinder iBinder) {
        this.atomActionResultPropagator = IAtomActionResultPropagator.Stub.asInterface(iBinder);
    }
}

