/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.action;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.webkit.ValueCallback;
import android.webkit.WebHistoryItem;
import android.webkit.WebView;
import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.ModelCodec;
import androidx.test.espresso.web.model.WindowReference;
import com.google.android.apps.common.testing.testrunner.web.Conduit;
import com.google.android.apps.common.testing.testrunner.web.JavaScriptBridge;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;

final class JavascriptEvaluation {
    private static final ScriptPreparer SCRIPT_PREPARER;
    private static final AsyncFunction<PreparedScript, String> RAW_EVALUATOR;
    private static final Function<String, Evaluation> DECODE_EVALUATION;
    private static final int SANITIZER_SYNC = 1;
    private static final Handler MAIN_HANDLER;

    private JavascriptEvaluation() {
    }

    static ListenableFuture<Evaluation> evaluate(WebView webView, String string, List<Object> list, WindowReference windowReference) {
        UnpreparedScript unpreparedScript = new UnpreparedScript(webView, string, list, windowReference);
        SanitizerTask sanitizerTask = new SanitizerTask(unpreparedScript);
        webView.post((Runnable)sanitizerTask);
        ListenableFuture<PreparedScript> listenableFuture = Futures.transform(sanitizerTask, SCRIPT_PREPARER, MoreExecutors.directExecutor());
        ListenableFuture<String> listenableFuture2 = Futures.transformAsync(listenableFuture, RAW_EVALUATOR, MoreExecutors.directExecutor());
        ListenableFuture<Evaluation> listenableFuture3 = Futures.transform(listenableFuture2, DECODE_EVALUATION, MoreExecutors.directExecutor());
        return listenableFuture3;
    }

    static {
        DECODE_EVALUATION = new Function<String, Evaluation>(){

            @Override
            public Evaluation apply(String string) {
                return ModelCodec.decodeEvaluation(string);
            }
        };
        MAIN_HANDLER = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        ((SanitizerTask)message.obj).sanitizerSync();
                    }
                }
            }
        };
        if (Build.VERSION.SDK_INT < 19) {
            SCRIPT_PREPARER = new ScriptPreparer(true);
            RAW_EVALUATOR = new AsyncConduitEvaluation();
        } else {
            SCRIPT_PREPARER = new ScriptPreparer(false);
            RAW_EVALUATOR = new AsyncJavascriptEvaluation();
        }
    }

    private static class ValueCallbackFuture<V>
    extends AbstractFuture<V>
    implements ValueCallback<V> {
        private ValueCallbackFuture() {
        }

        public void onReceiveValue(V v) {
            this.set(v);
        }
    }

    private static final class AsyncJavascriptEvaluation
    implements AsyncFunction<PreparedScript, String> {
        private AsyncJavascriptEvaluation() {
        }

        @Override
        public ListenableFuture<String> apply(final PreparedScript preparedScript) {
            if (null != preparedScript.conduit) {
                return Futures.immediateFailedFuture(new RuntimeException("Conduit script cannot be used"));
            }
            final ValueCallbackFuture<String> valueCallbackFuture = new ValueCallbackFuture<String>();
            if (Looper.myLooper() == Looper.getMainLooper()) {
                preparedScript.view.evaluateJavascript(preparedScript.script, valueCallbackFuture);
            } else {
                preparedScript.view.post(new Runnable(this){

                    @Override
                    public void run() {
                        preparedScript.view.evaluateJavascript(preparedScript.script, (ValueCallback)valueCallbackFuture);
                    }
                });
            }
            return valueCallbackFuture;
        }
    }

    private static final class AsyncConduitEvaluation
    implements AsyncFunction<PreparedScript, String> {
        private AsyncConduitEvaluation() {
        }

        @Override
        public ListenableFuture<String> apply(final PreparedScript preparedScript) {
            if (null == preparedScript.conduit) {
                return Futures.immediateFailedFuture(new RuntimeException("Not a conduit script!"));
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                preparedScript.view.loadUrl(preparedScript.script);
            } else {
                preparedScript.view.post(new Runnable(this){

                    @Override
                    public void run() {
                        preparedScript.view.loadUrl(preparedScript.script);
                    }
                });
            }
            return preparedScript.conduit.getResult();
        }
    }

    private static final class ScriptPreparer
    implements Function<UnpreparedScript, PreparedScript> {
        private final boolean conduitize;
        private static final Pattern FUNCTION_PATTERN = Pattern.compile("^\\s*function\\s*\\w*\\s*\\(.*\\}\\s*$", 40);

        public ScriptPreparer(boolean bl) {
            this.conduitize = bl;
        }

        @Override
        public PreparedScript apply(UnpreparedScript unpreparedScript) {
            StringBuilder stringBuilder = this.atomize(unpreparedScript.script, unpreparedScript.args, unpreparedScript.window);
            Conduit conduit = null;
            if (this.conduitize) {
                conduit = JavaScriptBridge.makeConduit();
                stringBuilder = conduit.wrapScriptInConduit(stringBuilder).insert(0, "javascript:");
            }
            return new PreparedScript(unpreparedScript.view, stringBuilder.toString(), conduit);
        }

        private StringBuilder atomize(String string, List<Object> list, WindowReference windowReference) {
            int n = "function(){return(function(){function h(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function k(a){var b=h(a);return\"array\"==b||\"object\"==b&&\"number\"==typeof a.length}function l(a){var b=typeof a;return\"object\"==b&&null!=a||\"function\"==b}var m=Date.now||function(){return+new Date};\nfunction p(a,b){function c(){}c.prototype=b.prototype;a.f=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.c=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function q(a,b){for(var c=a.length,d=Array(c),e=\"string\"==typeof a?a.split(\"\"):a,f=0;f<c;f++)f in e&&(d[f]=b.call(void 0,e[f],f,a));return d};function r(a,b){var c={},d;for(d in a)b.call(void 0,a[d],d,a)&&(c[d]=a[d]);return c}function t(a,b){var c={},d;for(d in a)c[d]=b.call(void 0,a[d],d,a);return c}function u(a,b){return null!==a&&b in a}function v(a,b){for(var c in a)if(b.call(void 0,a[c],c,a))return c};var w=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function x(a,b){return a<b?-1:a>b?1:0};var y;a:{var z=this.navigator;if(z){var A=z.userAgent;if(A){y=A;break a}}y=\"\"};/*xxx_rpl_lic*/\nvar B=window;function C(a,b){this.code=a;this.b=D[a]||\"unknown error\";this.message=b||\"\";a=this.b.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")});b=a.length-5;if(0>b||a.indexOf(\"Error\",b)!=b)a+=\"Error\";this.name=a;a=Error(this.message);a.name=this.name;this.stack=a.stack||\"\"}p(C,Error);\nvar D={15:\"element not selectable\",11:\"element not visible\",31:\"unknown error\",30:\"unknown error\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",21:\"timeout\",25:\"unable to set cookie\",\n26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};C.prototype.toString=function(){return this.name+\": \"+this.message};function E(){}\nfunction F(a,b,c){if(null==b)c.push(\"null\");else{if(\"object\"==typeof b){if(\"array\"==h(b)){var d=b;b=d.length;c.push(\"[\");for(var e=\"\",f=0;f<b;f++)c.push(e),F(a,d[f],c),e=\",\";c.push(\"]\");return}if(b instanceof String||b instanceof Number||b instanceof Boolean)b=b.valueOf();else{c.push(\"{\");e=\"\";for(d in b)Object.prototype.hasOwnProperty.call(b,d)&&(f=b[d],\"function\"!=typeof f&&(c.push(e),G(d,c),c.push(\":\"),F(a,f,c),e=\",\"));c.push(\"}\");return}}switch(typeof b){case \"string\":G(b,c);break;case \"number\":c.push(isFinite(b)&&\n!isNaN(b)?String(b):\"null\");break;case \"boolean\":c.push(String(b));break;case \"function\":c.push(\"null\");break;default:throw Error(\"Unknown type: \"+typeof b);}}}var H={'\"':'\\\\\"',\"\\\\\":\"\\\\\\\\\",\"/\":\"\\\\/\",\"\\b\":\"\\\\b\",\"\\f\":\"\\\\f\",\"\\n\":\"\\\\n\",\"\\r\":\"\\\\r\",\"\\t\":\"\\\\t\",\"\\x0B\":\"\\\\u000b\"},I=/\\uffff/.test(\"\\uffff\")?/[\\\\\"\\x00-\\x1f\\x7f-\\uffff]/g:/[\\\\\"\\x00-\\x1f\\x7f-\\xff]/g;function G(a,b){b.push('\"',a.replace(I,function(a){var b=H[a];b||(b=\"\\\\u\"+(a.charCodeAt(0)|65536).toString(16).substr(1),H[a]=b);return b}),'\"')};function J(a){return(a=a.exec(y))?a[1]:\"\"}J(/Android\\s+([0-9.]+)/)||J(/Version\\/([0-9.]+)/);function K(a){var b=0,c=w(String(L)).split(\".\");a=w(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),e=0;0==b&&e<d;e++){var f=c[e]||\"\",g=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];g=/(\\d*)(\\D*)(.*)/.exec(g)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==g[0].length)break;b=x(0==f[1].length?0:parseInt(f[1],10),0==g[1].length?0:parseInt(g[1],10))||x(0==f[2].length,0==g[2].length)||x(f[2],g[2]);f=f[3];g=g[3]}while(0==b)}}var M=/Android\\s+([0-9\\.]+)/.exec(y),L=M?M[1]:\"0\";K(2.3);K(4);function N(a){function b(a,d){switch(h(a)){case \"string\":case \"number\":case \"boolean\":return a;case \"function\":return a.toString();case \"array\":return q(a,function(a){return b(a,d)});case \"object\":if(0<=d.indexOf(a))throw new C(13,\"Recursive object cannot be transferred\");if(u(a,\"nodeType\")&&(1==a.nodeType||9==a.nodeType)){var c={};c.ELEMENT=O(a);return c}if(u(a,\"document\"))return c={},c.WINDOW=O(a),c;d.push(a);if(k(a))return q(a,function(a){return b(a,d)});a=r(a,function(a,b){return\"number\"==typeof b||\n\"string\"==typeof b});return t(a,function(a){return b(a,d)});default:return null}}return b(a,[])}function P(a,b){return\"array\"==h(a)?q(a,function(a){return P(a,b)}):l(a)?\"function\"==typeof a?a:u(a,\"ELEMENT\")?Q(a.ELEMENT,b):u(a,\"WINDOW\")?Q(a.WINDOW,b):t(a,function(a){return P(a,b)}):a}function R(a){a=a||document;var b=a.$wdc_;b||(b=a.$wdc_={},b.a=m());b.a||(b.a=m());return b}function O(a){var b=R(a.ownerDocument),c=v(b,function(b){return b==a});c||(c=\":wdc:\"+b.a++,b[c]=a);return c}\nfunction Q(a,b){a=decodeURIComponent(a);b=b||document;var c=R(b);if(!u(c,a))throw new C(10,\"Element does not exist in cache\");var d=c[a];if(u(d,\"setInterval\")){if(d.closed)throw delete c[a],new C(23,\"Window has been closed.\");return d}for(var e=d;e;){if(e==b.documentElement)return d;e=e.parentNode}delete c[a];throw new C(10,\"Element is no longer attached to the DOM\");};function S(a,b,c,d){d=d||B;try{a:{var e=a;if(\"string\"==typeof e)try{a=new d.Function(e);break a}catch(n){throw n;}a=d==window?e:new d.Function(\"return (\"+e+\").apply(null,arguments);\")}var f=P(b,d.document);var g={status:0,value:N(a.apply(null,f))}}catch(n){g={status:u(n,\"code\")?n.code:13,value:{message:n.message}}}c&&(a=[],F(new E,g,a),g=a.join(\"\"));return g}var T=[\"_\"],U=this;T[0]in U||\"undefined\"==typeof U.execScript||U.execScript(\"var \"+T[0]);\nfor(var V;T.length&&(V=T.shift());){var W;if(W=!T.length)W=void 0!==S;W?U[V]=S:U[V]&&U[V]!==Object.prototype[V]?U=U[V]:U=U[V]={}};;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n".length() + string.length() + 1024;
            if (windowReference != null) {
                n += "function(){return(function(){var g=Date.now||function(){return+new Date};function k(a,b){function d(){}d.prototype=b.prototype;a.f=b.prototype;a.prototype=new d;a.prototype.constructor=a;a.c=function(a,d,f){for(var c=Array(arguments.length-2),e=2;e<arguments.length;e++)c[e-2]=arguments[e];return b.prototype[d].apply(a,c)}};var l=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function m(a,b){return a<b?-1:a>b?1:0};var n;a:{var p=this.navigator;if(p){var q=p.userAgent;if(q){n=q;break a}}n=\"\"};/*xxx_rpl_lic*/\nfunction r(a,b){this.code=a;this.b=t[a]||\"unknown error\";this.message=b||\"\";a=this.b.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")});b=a.length-5;if(0>b||a.indexOf(\"Error\",b)!=b)a+=\"Error\";this.name=a;a=Error(this.message);a.name=this.name;this.stack=a.stack||\"\"}k(r,Error);\nvar t={15:\"element not selectable\",11:\"element not visible\",31:\"unknown error\",30:\"unknown error\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",21:\"timeout\",25:\"unable to set cookie\",\n26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};r.prototype.toString=function(){return this.name+\": \"+this.message};function u(a){return(a=a.exec(n))?a[1]:\"\"}u(/Android\\s+([0-9.]+)/)||u(/Version\\/([0-9.]+)/);function v(a){var b=0,d=l(String(w)).split(\".\");a=l(String(a)).split(\".\");for(var c=Math.max(d.length,a.length),e=0;0==b&&e<c;e++){var f=d[e]||\"\",h=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];h=/(\\d*)(\\D*)(.*)/.exec(h)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==h[0].length)break;b=m(0==f[1].length?0:parseInt(f[1],10),0==h[1].length?0:parseInt(h[1],10))||m(0==f[2].length,0==h[2].length)||m(f[2],h[2]);f=f[3];h=h[3]}while(0==b)}}var x=/Android\\s+([0-9\\.]+)/.exec(n),w=x?x[1]:\"0\";v(2.3);v(4);function y(a,b){a=decodeURIComponent(a);b=b||document;var d=b||document;var c=d.$wdc_;c||(c=d.$wdc_={},c.a=g());c.a||(c.a=g());d=c;if(!(null!==d&&a in d))throw new r(10,\"Element does not exist in cache\");c=d[a];if(null!==c&&\"setInterval\"in c){if(c.closed)throw delete d[a],new r(23,\"Window has been closed.\");return c}for(var e=c;e;){if(e==b.documentElement)return c;e=e.parentNode}delete d[a];throw new r(10,\"Element is no longer attached to the DOM\");}var z=[\"_\"],A=this;\nz[0]in A||\"undefined\"==typeof A.execScript||A.execScript(\"var \"+z[0]);for(var B;z.length&&(B=z.shift());)z.length||void 0===y?A[B]&&A[B]!==Object.prototype[B]?A=A[B]:A=A[B]={}:A[B]=y;;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n".length();
            }
            StringBuilder stringBuilder = new StringBuilder(n).append("var my_wind = ");
            if (windowReference != null) {
                stringBuilder.append("(").append("function(){return(function(){var g=Date.now||function(){return+new Date};function k(a,b){function d(){}d.prototype=b.prototype;a.f=b.prototype;a.prototype=new d;a.prototype.constructor=a;a.c=function(a,d,f){for(var c=Array(arguments.length-2),e=2;e<arguments.length;e++)c[e-2]=arguments[e];return b.prototype[d].apply(a,c)}};var l=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function m(a,b){return a<b?-1:a>b?1:0};var n;a:{var p=this.navigator;if(p){var q=p.userAgent;if(q){n=q;break a}}n=\"\"};/*xxx_rpl_lic*/\nfunction r(a,b){this.code=a;this.b=t[a]||\"unknown error\";this.message=b||\"\";a=this.b.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")});b=a.length-5;if(0>b||a.indexOf(\"Error\",b)!=b)a+=\"Error\";this.name=a;a=Error(this.message);a.name=this.name;this.stack=a.stack||\"\"}k(r,Error);\nvar t={15:\"element not selectable\",11:\"element not visible\",31:\"unknown error\",30:\"unknown error\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",21:\"timeout\",25:\"unable to set cookie\",\n26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};r.prototype.toString=function(){return this.name+\": \"+this.message};function u(a){return(a=a.exec(n))?a[1]:\"\"}u(/Android\\s+([0-9.]+)/)||u(/Version\\/([0-9.]+)/);function v(a){var b=0,d=l(String(w)).split(\".\");a=l(String(a)).split(\".\");for(var c=Math.max(d.length,a.length),e=0;0==b&&e<c;e++){var f=d[e]||\"\",h=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];h=/(\\d*)(\\D*)(.*)/.exec(h)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==h[0].length)break;b=m(0==f[1].length?0:parseInt(f[1],10),0==h[1].length?0:parseInt(h[1],10))||m(0==f[2].length,0==h[2].length)||m(f[2],h[2]);f=f[3];h=h[3]}while(0==b)}}var x=/Android\\s+([0-9\\.]+)/.exec(n),w=x?x[1]:\"0\";v(2.3);v(4);function y(a,b){a=decodeURIComponent(a);b=b||document;var d=b||document;var c=d.$wdc_;c||(c=d.$wdc_={},c.a=g());c.a||(c.a=g());d=c;if(!(null!==d&&a in d))throw new r(10,\"Element does not exist in cache\");c=d[a];if(null!==c&&\"setInterval\"in c){if(c.closed)throw delete d[a],new r(23,\"Window has been closed.\");return c}for(var e=c;e;){if(e==b.documentElement)return c;e=e.parentNode}delete d[a];throw new r(10,\"Element is no longer attached to the DOM\");}var z=[\"_\"],A=this;\nz[0]in A||\"undefined\"==typeof A.execScript||A.execScript(\"var \"+z[0]);for(var B;z.length&&(B=z.shift());)z.length||void 0===y?A[B]&&A[B]!==Object.prototype[B]?A=A[B]:A=A[B]={}:A[B]=y;;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n").append(")(").append(ModelCodec.encode(windowReference)).append("[\"WINDOW\"]);");
            } else {
                stringBuilder.append("null;");
            }
            stringBuilder.append("return (").append("function(){return(function(){function h(a){var b=typeof a;if(\"object\"==b)if(a){if(a instanceof Array)return\"array\";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if(\"[object Window]\"==c)return\"object\";if(\"[object Array]\"==c||\"number\"==typeof a.length&&\"undefined\"!=typeof a.splice&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"splice\"))return\"array\";if(\"[object Function]\"==c||\"undefined\"!=typeof a.call&&\"undefined\"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable(\"call\"))return\"function\"}else return\"null\";\nelse if(\"function\"==b&&\"undefined\"==typeof a.call)return\"object\";return b}function k(a){var b=h(a);return\"array\"==b||\"object\"==b&&\"number\"==typeof a.length}function l(a){var b=typeof a;return\"object\"==b&&null!=a||\"function\"==b}var m=Date.now||function(){return+new Date};\nfunction p(a,b){function c(){}c.prototype=b.prototype;a.f=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.c=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};function q(a,b){for(var c=a.length,d=Array(c),e=\"string\"==typeof a?a.split(\"\"):a,f=0;f<c;f++)f in e&&(d[f]=b.call(void 0,e[f],f,a));return d};function r(a,b){var c={},d;for(d in a)b.call(void 0,a[d],d,a)&&(c[d]=a[d]);return c}function t(a,b){var c={},d;for(d in a)c[d]=b.call(void 0,a[d],d,a);return c}function u(a,b){return null!==a&&b in a}function v(a,b){for(var c in a)if(b.call(void 0,a[c],c,a))return c};var w=String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\\s\\xa0]*([\\s\\S]*?)[\\s\\xa0]*$/.exec(a)[1]};function x(a,b){return a<b?-1:a>b?1:0};var y;a:{var z=this.navigator;if(z){var A=z.userAgent;if(A){y=A;break a}}y=\"\"};/*xxx_rpl_lic*/\nvar B=window;function C(a,b){this.code=a;this.b=D[a]||\"unknown error\";this.message=b||\"\";a=this.b.replace(/((?:^|\\s+)[a-z])/g,function(a){return a.toUpperCase().replace(/^[\\s\\xa0]+/g,\"\")});b=a.length-5;if(0>b||a.indexOf(\"Error\",b)!=b)a+=\"Error\";this.name=a;a=Error(this.message);a.name=this.name;this.stack=a.stack||\"\"}p(C,Error);\nvar D={15:\"element not selectable\",11:\"element not visible\",31:\"unknown error\",30:\"unknown error\",24:\"invalid cookie domain\",29:\"invalid element coordinates\",12:\"invalid element state\",32:\"invalid selector\",51:\"invalid selector\",52:\"invalid selector\",17:\"javascript error\",405:\"unsupported operation\",34:\"move target out of bounds\",27:\"no such alert\",7:\"no such element\",8:\"no such frame\",23:\"no such window\",28:\"script timeout\",33:\"session not created\",10:\"stale element reference\",21:\"timeout\",25:\"unable to set cookie\",\n26:\"unexpected alert open\",13:\"unknown error\",9:\"unknown command\"};C.prototype.toString=function(){return this.name+\": \"+this.message};function E(){}\nfunction F(a,b,c){if(null==b)c.push(\"null\");else{if(\"object\"==typeof b){if(\"array\"==h(b)){var d=b;b=d.length;c.push(\"[\");for(var e=\"\",f=0;f<b;f++)c.push(e),F(a,d[f],c),e=\",\";c.push(\"]\");return}if(b instanceof String||b instanceof Number||b instanceof Boolean)b=b.valueOf();else{c.push(\"{\");e=\"\";for(d in b)Object.prototype.hasOwnProperty.call(b,d)&&(f=b[d],\"function\"!=typeof f&&(c.push(e),G(d,c),c.push(\":\"),F(a,f,c),e=\",\"));c.push(\"}\");return}}switch(typeof b){case \"string\":G(b,c);break;case \"number\":c.push(isFinite(b)&&\n!isNaN(b)?String(b):\"null\");break;case \"boolean\":c.push(String(b));break;case \"function\":c.push(\"null\");break;default:throw Error(\"Unknown type: \"+typeof b);}}}var H={'\"':'\\\\\"',\"\\\\\":\"\\\\\\\\\",\"/\":\"\\\\/\",\"\\b\":\"\\\\b\",\"\\f\":\"\\\\f\",\"\\n\":\"\\\\n\",\"\\r\":\"\\\\r\",\"\\t\":\"\\\\t\",\"\\x0B\":\"\\\\u000b\"},I=/\\uffff/.test(\"\\uffff\")?/[\\\\\"\\x00-\\x1f\\x7f-\\uffff]/g:/[\\\\\"\\x00-\\x1f\\x7f-\\xff]/g;function G(a,b){b.push('\"',a.replace(I,function(a){var b=H[a];b||(b=\"\\\\u\"+(a.charCodeAt(0)|65536).toString(16).substr(1),H[a]=b);return b}),'\"')};function J(a){return(a=a.exec(y))?a[1]:\"\"}J(/Android\\s+([0-9.]+)/)||J(/Version\\/([0-9.]+)/);function K(a){var b=0,c=w(String(L)).split(\".\");a=w(String(a)).split(\".\");for(var d=Math.max(c.length,a.length),e=0;0==b&&e<d;e++){var f=c[e]||\"\",g=a[e]||\"\";do{f=/(\\d*)(\\D*)(.*)/.exec(f)||[\"\",\"\",\"\",\"\"];g=/(\\d*)(\\D*)(.*)/.exec(g)||[\"\",\"\",\"\",\"\"];if(0==f[0].length&&0==g[0].length)break;b=x(0==f[1].length?0:parseInt(f[1],10),0==g[1].length?0:parseInt(g[1],10))||x(0==f[2].length,0==g[2].length)||x(f[2],g[2]);f=f[3];g=g[3]}while(0==b)}}var M=/Android\\s+([0-9\\.]+)/.exec(y),L=M?M[1]:\"0\";K(2.3);K(4);function N(a){function b(a,d){switch(h(a)){case \"string\":case \"number\":case \"boolean\":return a;case \"function\":return a.toString();case \"array\":return q(a,function(a){return b(a,d)});case \"object\":if(0<=d.indexOf(a))throw new C(13,\"Recursive object cannot be transferred\");if(u(a,\"nodeType\")&&(1==a.nodeType||9==a.nodeType)){var c={};c.ELEMENT=O(a);return c}if(u(a,\"document\"))return c={},c.WINDOW=O(a),c;d.push(a);if(k(a))return q(a,function(a){return b(a,d)});a=r(a,function(a,b){return\"number\"==typeof b||\n\"string\"==typeof b});return t(a,function(a){return b(a,d)});default:return null}}return b(a,[])}function P(a,b){return\"array\"==h(a)?q(a,function(a){return P(a,b)}):l(a)?\"function\"==typeof a?a:u(a,\"ELEMENT\")?Q(a.ELEMENT,b):u(a,\"WINDOW\")?Q(a.WINDOW,b):t(a,function(a){return P(a,b)}):a}function R(a){a=a||document;var b=a.$wdc_;b||(b=a.$wdc_={},b.a=m());b.a||(b.a=m());return b}function O(a){var b=R(a.ownerDocument),c=v(b,function(b){return b==a});c||(c=\":wdc:\"+b.a++,b[c]=a);return c}\nfunction Q(a,b){a=decodeURIComponent(a);b=b||document;var c=R(b);if(!u(c,a))throw new C(10,\"Element does not exist in cache\");var d=c[a];if(u(d,\"setInterval\")){if(d.closed)throw delete c[a],new C(23,\"Window has been closed.\");return d}for(var e=d;e;){if(e==b.documentElement)return d;e=e.parentNode}delete c[a];throw new C(10,\"Element is no longer attached to the DOM\");};function S(a,b,c,d){d=d||B;try{a:{var e=a;if(\"string\"==typeof e)try{a=new d.Function(e);break a}catch(n){throw n;}a=d==window?e:new d.Function(\"return (\"+e+\").apply(null,arguments);\")}var f=P(b,d.document);var g={status:0,value:N(a.apply(null,f))}}catch(n){g={status:u(n,\"code\")?n.code:13,value:{message:n.message}}}c&&(a=[],F(new E,g,a),g=a.join(\"\"));return g}var T=[\"_\"],U=this;T[0]in U||\"undefined\"==typeof U.execScript||U.execScript(\"var \"+T[0]);\nfor(var V;T.length&&(V=T.shift());){var W;if(W=!T.length)W=void 0!==S;W?U[V]=S:U[V]&&U[V]!==Object.prototype[V]?U=U[V]:U=U[V]={}};;return this._.apply(null,arguments);}).apply({navigator:typeof window!=\"undefined\"?window.navigator:null},arguments);}\n").append(")(");
            this.escapeAndQuote(stringBuilder, string).append(",").append(ModelCodec.encode(list)).append(",").append(this.conduitize).append(",").append("my_wind)");
            return this.wrapInFunction(stringBuilder);
        }

        private StringBuilder wrapInFunction(StringBuilder stringBuilder) {
            stringBuilder.insert(0, "(function(){").append("})()");
            return stringBuilder;
        }

        static boolean isFunctionDefinition(String string) {
            return FUNCTION_PATTERN.matcher(string).matches();
        }

        private StringBuilder escapeAndQuote(StringBuilder stringBuilder, String string) {
            stringBuilder.append("\"");
            boolean bl = ScriptPreparer.isFunctionDefinition(string);
            if (bl) {
                stringBuilder.append("return (");
            }
            block7: for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                switch (c) {
                    case '\"': 
                    case '\'': 
                    case '\\': {
                        stringBuilder.append('\\').append(c);
                        continue block7;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        continue block7;
                    }
                    case '\u2028': {
                        stringBuilder.append("\\u2028");
                        continue block7;
                    }
                    case '\u2029': {
                        stringBuilder.append("\\u2029");
                        continue block7;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
            }
            if (bl) {
                stringBuilder.append(").apply(null,arguments);");
            }
            stringBuilder.append("\"");
            return stringBuilder;
        }
    }

    private static class PreparedScript {
        private final WebView view;
        private final String script;
        private final Conduit conduit;

        PreparedScript(WebView webView, String string, Conduit conduit) {
            this.view = Preconditions.checkNotNull(webView);
            this.script = Preconditions.checkNotNull(string);
            this.conduit = conduit;
        }
    }

    private static class UnpreparedScript {
        private final WebView view;
        private final String script;
        private final List<Object> args;
        private final WindowReference window;

        UnpreparedScript(WebView webView, String string, List<Object> list, WindowReference windowReference) {
            this.view = Preconditions.checkNotNull(webView);
            this.script = Preconditions.checkNotNull(string);
            this.args = Preconditions.checkNotNull(list);
            this.window = windowReference;
        }
    }

    private static class SanitizerTask
    extends AbstractFuture<UnpreparedScript>
    implements Runnable {
        private static final String DOC_ELEMENT_PRESENT = "return document.documentElement != null && document.readyState === 'complete'";
        private static final int DELAY = 100;
        private final UnpreparedScript unprepared;
        private String sanityMessage = "";
        private int count;

        public SanitizerTask(UnpreparedScript unpreparedScript) {
            this.unprepared = Preconditions.checkNotNull(unpreparedScript);
            this.count = 0;
        }

        @Override
        public void run() {
            if (Looper.myLooper() != Looper.getMainLooper()) {
                this.unprepared.view.post((Runnable)this);
            } else {
                try {
                    this.innerSanity();
                }
                catch (RuntimeException runtimeException) {
                    this.setException(runtimeException);
                }
            }
        }

        void sanitizerSync() {
            if (this.isWebViewSane()) {
                this.set(this.unprepared);
            } else {
                this.unprepared.view.post((Runnable)this);
            }
        }

        private void innerSanity() {
            ++this.count;
            Preconditions.checkState(this.count < 250, "Waited over: %s millis but webview never went sane: %s", 25000, (Object)this.sanityMessage);
            if (this.isWebViewSane()) {
                PreparedScript preparedScript = SCRIPT_PREPARER.apply(new UnpreparedScript(this.unprepared.view, DOC_ELEMENT_PRESENT, Collections.EMPTY_LIST, this.unprepared.window));
                ListenableFuture listenableFuture = null;
                try {
                    listenableFuture = RAW_EVALUATOR.apply(preparedScript);
                }
                catch (Exception exception) {
                    this.setException(exception);
                    return;
                }
                final ListenableFuture listenableFuture2 = Futures.transform(listenableFuture, DECODE_EVALUATION, MoreExecutors.directExecutor());
                listenableFuture2.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Evaluation evaluation = (Evaluation)listenableFuture2.get();
                            if (evaluation.getStatus() == 0) {
                                if (((Boolean)evaluation.getValue()).booleanValue()) {
                                    if (Build.VERSION.SDK_INT == 10) {
                                        SanitizerTask.this.set(SanitizerTask.this.unprepared);
                                    } else {
                                        SanitizerTask.this.unprepared.view.post(new Runnable(){

                                            @Override
                                            public void run() {
                                                SanitizerTask.this.unprepared.view.requestFocusNodeHref(MAIN_HANDLER.obtainMessage(1, (Object)SanitizerTask.this));
                                            }
                                        });
                                    }
                                } else {
                                    SanitizerTask.this.unprepared.view.postDelayed((Runnable)SanitizerTask.this, 100L);
                                }
                            } else {
                                String string = String.valueOf(evaluation);
                                SanitizerTask.this.setException(new RuntimeException(new StringBuilder(41 + String.valueOf(string).length()).append("Fatal exception checking document state: ").append(string).toString()));
                            }
                        }
                        catch (ExecutionException executionException) {
                            SanitizerTask.this.setException(executionException.getCause());
                        }
                        catch (InterruptedException interruptedException) {
                            SanitizerTask.this.setException(interruptedException.getCause());
                        }
                    }
                }, MoreExecutors.directExecutor());
            } else {
                this.unprepared.view.postDelayed((Runnable)this, 100L);
            }
        }

        private static boolean urlAndHistoryUrlMatch(String string, String string2) {
            if (string.equals(string2)) {
                return true;
            }
            String string3 = "about:blank";
            String string4 = "data:";
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
            return !(!string.equals("about:blank") && !string.startsWith("data:") || !string2.equals("about:blank") && !string2.startsWith("data:"));
        }

        private boolean isWebViewSane() {
            boolean bl;
            String string = this.unprepared.view.getUrl();
            WebHistoryItem webHistoryItem = this.unprepared.view.copyBackForwardList().getCurrentItem();
            boolean bl2 = string != null;
            boolean bl3 = bl = webHistoryItem != null;
            if (bl2 && bl) {
                String string2 = webHistoryItem.getUrl();
                boolean bl4 = SanitizerTask.urlAndHistoryUrlMatch(string, string2);
                boolean bl5 = this.unprepared.view.getContentHeight() != 0;
                boolean bl6 = this.unprepared.view.getProgress() == 100;
                this.sanityMessage = String.format("viewAndHistoryUrlsMatch: %s, nonZeroContentHeight: %s, progressComplete: %s", bl4, bl5, bl6);
                return bl4 && bl6 && bl5;
            }
            this.sanityMessage = String.format("view.getUrl() != null: %s view.copyBackForwardList().getCurrentItem() != null: %s", bl2, bl);
            return false;
        }
    }
}

