/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import java.io.IOException;
import java.io.StringBufferInputStream;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class TagSoupDocumentParser {
    private static final ThreadLocal<TransformerFactory> transformerFactory = new ThreadLocal<TransformerFactory>(){

        @Override
        protected TransformerFactory initialValue() {
            return TransformerFactory.newInstance();
        }
    };
    private final Parser parser = new Parser();

    private TagSoupDocumentParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature("http://xml.org/sax/features/namespaces", false);
    }

    public static TagSoupDocumentParser newInstance() throws SAXNotRecognizedException, SAXNotSupportedException {
        return new TagSoupDocumentParser();
    }

    public Document parse(String string) throws SAXException, IOException {
        Preconditions.checkNotNull(string);
        SAXSource sAXSource = new SAXSource((XMLReader)this.parser, new InputSource(new StringBufferInputStream(string)));
        DOMResult dOMResult = new DOMResult();
        try {
            transformerFactory.get().newTransformer().transform(sAXSource, dOMResult);
        }
        catch (TransformerException transformerException) {
            throw new SAXException(transformerException);
        }
        return (Document)dOMResult.getNode();
    }
}

