/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import android.view.View;
import android.webkit.WebView;
import androidx.test.espresso.NoMatchingViewException;
import androidx.test.espresso.ViewAssertion;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Atom;

public abstract class WebAssertion<E> {
    @RemoteMsgField(order=0)
    private final Atom<E> atom;

    @RemoteMsgConstructor
    public WebAssertion(Atom<E> atom) {
        this.atom = Preconditions.checkNotNull(atom);
    }

    public final Atom<E> getAtom() {
        return this.atom;
    }

    public final ViewAssertion toViewAssertion(E e) {
        return new CheckResultWebAssertion<E>(Preconditions.checkNotNull(e), this);
    }

    protected abstract void checkResult(WebView var1, E var2);

    static final class CheckResultWebAssertion<T>
    implements ViewAssertion {
        final T result;
        final WebAssertion<T> webAssertion;

        CheckResultWebAssertion(T t, WebAssertion<T> webAssertion) {
            this.result = t;
            this.webAssertion = webAssertion;
        }

        public void check(View view, NoMatchingViewException noMatchingViewException) {
            if (null == view) {
                throw noMatchingViewException;
            }
            if (!(view instanceof WebView)) {
                String string = String.valueOf(view);
                throw new RuntimeException(new StringBuilder(19 + String.valueOf(string).length()).append(string).append(": is not a WebView!").toString());
            }
            this.webAssertion.checkResult((WebView)view, this.result);
        }
    }
}

