/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import android.webkit.WebView;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.test.espresso.remote.annotation.RemoteMsgConstructor;
import androidx.test.espresso.remote.annotation.RemoteMsgField;
import androidx.test.espresso.web.assertion.TagSoupDocumentParser;
import androidx.test.espresso.web.assertion.WebAssertion;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.model.Atom;
import androidx.test.espresso.web.model.Atoms;
import androidx.test.espresso.web.model.Evaluation;
import androidx.test.espresso.web.model.TransformingAtom;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class WebViewAssertions {
    private static final ResultDescriber<Object> TO_STRING_DESCRIBER = new ToStringResultDescriber();

    private WebViewAssertions() {
    }

    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> matcher, ResultDescriber<? super E> resultDescriber) {
        Preconditions.checkNotNull(matcher);
        Preconditions.checkNotNull(resultDescriber);
        Preconditions.checkNotNull(atom);
        return new ResultCheckingWebAssertion<E>(atom, matcher, resultDescriber);
    }

    public static <E> WebAssertion<E> webMatches(Atom<E> atom, Matcher<E> matcher) {
        return WebViewAssertions.webMatches(atom, matcher, TO_STRING_DESCRIBER);
    }

    public static WebAssertion<Document> webContent(Matcher<Document> matcher) {
        Preconditions.checkNotNull(matcher);
        return WebViewAssertions.webMatches(Atoms.transform(Atoms.script("return document.documentElement.outerHTML;"), new DocumentParserAtom()), matcher, new WebContentResultDescriber());
    }

    static final class DocumentParserAtom
    implements TransformingAtom.Transformer<Evaluation, Document> {
        @RemoteMsgConstructor
        public DocumentParserAtom() {
        }

        @Override
        public Document apply(Evaluation evaluation) {
            if (evaluation.getValue() instanceof String) {
                try {
                    return TagSoupDocumentParser.newInstance().parse((String)evaluation.getValue());
                }
                catch (SAXException sAXException) {
                    String string = String.valueOf(evaluation.getValue());
                    throw new RuntimeException(new StringBuilder(14 + String.valueOf(string).length()).append("Parse failed: ").append(string).toString(), sAXException);
                }
                catch (IOException iOException) {
                    String string = String.valueOf(evaluation.getValue());
                    throw new RuntimeException(new StringBuilder(14 + String.valueOf(string).length()).append("Parse failed: ").append(string).toString(), iOException);
                }
            }
            String string = String.valueOf(evaluation);
            throw new RuntimeException(new StringBuilder(33 + String.valueOf(string).length()).append("Value should have been a string: ").append(string).toString());
        }
    }

    static final class WebContentResultDescriber
    implements ResultDescriber<Document> {
        @RemoteMsgConstructor
        public WebContentResultDescriber() {
        }

        @Override
        public String apply(Document document) {
            try {
                DOMSource dOMSource = new DOMSource(document);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(dOMSource, streamResult);
                return stringWriter.toString();
            }
            catch (TransformerException transformerException) {
                String string = String.valueOf(transformerException);
                return new StringBuilder(22 + String.valueOf(string).length()).append("Could not transform!!!").append(string).toString();
            }
        }
    }

    static final class ToStringResultDescriber
    implements ResultDescriber<Object> {
        @RemoteMsgConstructor
        public ToStringResultDescriber() {
        }

        @Override
        public String apply(Object object) {
            return object.toString();
        }
    }

    static final class ResultCheckingWebAssertion<E>
    extends WebAssertion<E> {
        @RemoteMsgField(order=0)
        private final Atom<E> atom;
        @RemoteMsgField(order=1)
        private final Matcher<E> resultMatcher;
        @RemoteMsgField(order=2)
        private final ResultDescriber<? super E> resultDescriber;

        @RemoteMsgConstructor
        ResultCheckingWebAssertion(Atom<E> atom, Matcher<E> matcher, ResultDescriber<? super E> resultDescriber) {
            super(atom);
            this.atom = atom;
            this.resultMatcher = matcher;
            this.resultDescriber = resultDescriber;
        }

        @Override
        protected void checkResult(WebView webView, E e) {
            StringDescription stringDescription = new StringDescription();
            stringDescription.appendText("'");
            this.resultMatcher.describeTo((Description)stringDescription);
            stringDescription.appendText("' doesn't match: ");
            stringDescription.appendText(null == e ? "null" : this.resultDescriber.apply(e));
            ViewMatchers.assertThat((String)stringDescription.toString(), e, this.resultMatcher);
        }
    }

    public static interface ResultDescriber<E> {
        public String apply(E var1);
    }
}

