/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.test.espresso.web.internal.deps.aidl.TransactionInterceptor;

public abstract class BaseStub
extends Binder
implements IInterface {
    private static TransactionInterceptor globalInterceptor = null;

    static synchronized void installTransactionInterceptorPackagePrivate(TransactionInterceptor transactionInterceptor) {
        if (transactionInterceptor == null) {
            throw new IllegalArgumentException("null interceptor");
        }
        if (globalInterceptor != null) {
            throw new IllegalStateException("Duplicate TransactionInterceptor installation.");
        }
        globalInterceptor = transactionInterceptor;
    }

    protected BaseStub(String string) {
        this.attachInterface(this, string);
    }

    public IBinder asBinder() {
        return this;
    }

    protected boolean routeToSuperOrEnforceInterface(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        if (n > 0xFFFFFF) {
            return super.onTransact(n, parcel, parcel2, n2);
        }
        parcel.enforceInterface(this.getInterfaceDescriptor());
        return false;
    }

    public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        if (this.routeToSuperOrEnforceInterface(n, parcel, parcel2, n2)) {
            return true;
        }
        if (globalInterceptor == null) {
            return this.dispatchTransaction(n, parcel, parcel2, n2);
        }
        return globalInterceptor.interceptTransaction(this, n, parcel, parcel2, n2);
    }

    protected boolean dispatchTransaction(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
        return false;
    }
}

