/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.base;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import java.util.Arrays;

public final class MoreObjects {
    public static <T> T firstNonNull(T t, T t2) {
        if (t != null) {
            return t;
        }
        if (t2 != null) {
            return t2;
        }
        throw new NullPointerException("Both parameters are null");
    }

    public static ToStringHelper toStringHelper(Object object) {
        return new ToStringHelper(object.getClass().getSimpleName());
    }

    public static final class ToStringHelper {
        private final String className;
        private final ValueHolder holderHead;
        private ValueHolder holderTail;
        private boolean omitNullValues;

        private ToStringHelper(String string) {
            this.holderTail = this.holderHead = new ValueHolder();
            this.omitNullValues = false;
            this.className = Preconditions.checkNotNull(string);
        }

        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String string, Object object) {
            return this.addHolder(string, object);
        }

        public ToStringHelper add(String string, boolean bl) {
            return this.addHolder(string, String.valueOf(bl));
        }

        public ToStringHelper add(String string, float f) {
            return this.addHolder(string, String.valueOf(f));
        }

        public ToStringHelper add(String string, int n) {
            return this.addHolder(string, String.valueOf(n));
        }

        public ToStringHelper add(String string, long l) {
            return this.addHolder(string, String.valueOf(l));
        }

        public ToStringHelper addValue(Object object) {
            return this.addHolder(object);
        }

        public String toString() {
            boolean bl = this.omitNullValues;
            String string = "";
            StringBuilder stringBuilder = new StringBuilder(32).append(this.className).append('{');
            ValueHolder valueHolder = this.holderHead.next;
            while (valueHolder != null) {
                Object object = valueHolder.value;
                if (!bl || object != null) {
                    stringBuilder.append(string);
                    string = ", ";
                    if (valueHolder.name != null) {
                        stringBuilder.append(valueHolder.name).append('=');
                    }
                    if (object != null && object.getClass().isArray()) {
                        Object[] objectArray = new Object[]{object};
                        String string2 = Arrays.deepToString(objectArray);
                        stringBuilder.append(string2, 1, string2.length() - 1);
                    } else {
                        stringBuilder.append(object);
                    }
                }
                valueHolder = valueHolder.next;
            }
            return stringBuilder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder;
            this.holderTail = this.holderTail.next = (valueHolder = new ValueHolder());
            return valueHolder;
        }

        private ToStringHelper addHolder(Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            return this;
        }

        private ToStringHelper addHolder(String string, Object object) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.value = object;
            valueHolder.name = Preconditions.checkNotNull(string);
            return this;
        }

        private static final class ValueHolder {
            String name;
            Object value;
            ValueHolder next;

            private ValueHolder() {
            }
        }
    }
}

