/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.base;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Throwables {
    private static final Object jla = Throwables.getJLA();
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getSizeMethod();

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    @Deprecated
    public static RuntimeException propagate(Throwable throwable) {
        Throwables.throwIfUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    private static Object getJLA() {
        try {
            Class<?> clazz = Class.forName("sun.misc.SharedSecrets", false, null);
            Method method = clazz.getMethod("getJavaLangAccess", new Class[0]);
            return method.invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    private static Method getSizeMethod() {
        try {
            Method method = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (method == null) {
                return null;
            }
            method.invoke(Throwables.getJLA(), new Throwable());
            return method;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    private static Method getJlaMethod(String string, Class<?> ... classArray) throws ThreadDeath {
        try {
            return Class.forName("sun.misc.JavaLangAccess", false, null).getMethod(string, classArray);
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

