/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.cache;

import androidx.test.espresso.web.internal.deps.guava.cache.Cache;
import androidx.test.espresso.web.internal.deps.guava.cache.LongAddable;
import androidx.test.espresso.web.internal.deps.guava.cache.LongAddables;

public abstract class AbstractCache<K, V>
implements Cache<K, V> {

    public static final class SimpleStatsCounter
    implements StatsCounter {
        private final LongAddable hitCount = LongAddables.create();
        private final LongAddable missCount = LongAddables.create();
        private final LongAddable loadSuccessCount = LongAddables.create();
        private final LongAddable loadExceptionCount = LongAddables.create();
        private final LongAddable totalLoadTime = LongAddables.create();
        private final LongAddable evictionCount = LongAddables.create();

        @Override
        public void recordHits(int n) {
            this.hitCount.add(n);
        }

        @Override
        public void recordMisses(int n) {
            this.missCount.add(n);
        }

        @Override
        public void recordLoadSuccess(long l) {
            this.loadSuccessCount.increment();
            this.totalLoadTime.add(l);
        }

        @Override
        public void recordLoadException(long l) {
            this.loadExceptionCount.increment();
            this.totalLoadTime.add(l);
        }

        @Override
        public void recordEviction() {
            this.evictionCount.increment();
        }
    }

    public static interface StatsCounter {
        public void recordHits(int var1);

        public void recordMisses(int var1);

        public void recordLoadSuccess(long var1);

        public void recordLoadException(long var1);

        public void recordEviction();
    }
}

