/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.collect;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.collect.Hashing;
import androidx.test.espresso.web.internal.deps.guava.collect.ImmutableCollection;
import androidx.test.espresso.web.internal.deps.guava.collect.ImmutableList;
import androidx.test.espresso.web.internal.deps.guava.collect.ObjectArrays;
import androidx.test.espresso.web.internal.deps.guava.collect.RegularImmutableSet;
import androidx.test.espresso.web.internal.deps.guava.collect.Sets;
import androidx.test.espresso.web.internal.deps.guava.collect.SingletonImmutableSet;
import androidx.test.espresso.web.internal.deps.guava.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Set;

public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    private transient ImmutableList<E> asList;

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E e) {
        return new SingletonImmutableSet<E>(e);
    }

    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5) {
        return ImmutableSet.construct(5, e, e2, e3, e4, e5);
    }

    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e, E e2, E e3, E e4, E e5, E e6, E ... EArray) {
        Preconditions.checkArgument(EArray.length <= 0x7FFFFFF9, "the total number of elements must fit in an int");
        int n = 6;
        Object[] objectArray = new Object[6 + EArray.length];
        objectArray[0] = e;
        objectArray[1] = e2;
        objectArray[2] = e3;
        objectArray[3] = e4;
        objectArray[4] = e5;
        objectArray[5] = e6;
        System.arraycopy(EArray, 0, objectArray, 6, EArray.length);
        return ImmutableSet.construct(objectArray.length, objectArray);
    }

    private static <E> ImmutableSet<E> construct(int n, Object ... objectArray) {
        switch (n) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object object = objectArray[0];
                return ImmutableSet.of(object);
            }
        }
        int n2 = ImmutableSet.chooseTableSize(n);
        Object[] objectArray2 = new Object[n2];
        int n3 = n2 - 1;
        int n4 = 0;
        int n5 = 0;
        block4: for (int i = 0; i < n; ++i) {
            Object object = ObjectArrays.checkElementNotNull(objectArray[i], i);
            int n6 = object.hashCode();
            int n7 = Hashing.smear(n6);
            while (true) {
                int n8;
                Object object2;
                if ((object2 = objectArray2[n8 = n7 & n3]) == null) {
                    objectArray[n5++] = object;
                    objectArray2[n8] = object;
                    n4 += n6;
                    continue block4;
                }
                if (object2.equals(object)) continue block4;
                ++n7;
            }
        }
        Arrays.fill(objectArray, n5, n, null);
        if (n5 == 1) {
            Object object = objectArray[0];
            return new SingletonImmutableSet<Object>(object, n4);
        }
        if (ImmutableSet.chooseTableSize(n5) < n2 / 2) {
            return ImmutableSet.construct(n5, objectArray);
        }
        Object[] objectArray3 = ImmutableSet.shouldTrim(n5, objectArray.length) ? Arrays.copyOf(objectArray, n5) : objectArray;
        return new RegularImmutableSet(objectArray3, n4, objectArray2, n3, n5);
    }

    private static boolean shouldTrim(int n, int n2) {
        return n < (n2 >> 1) + (n2 >> 2);
    }

    static int chooseTableSize(int n) {
        if ((n = Math.max(n, 2)) < 0x2CCCCCCC) {
            int n2 = Integer.highestOneBit(n - 1) << 1;
            while ((double)n2 * 0.7 < (double)n) {
                n2 <<= 1;
            }
            return n2;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    public static <E> ImmutableSet<E> copyOf(E[] EArray) {
        switch (EArray.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(EArray[0]);
            }
        }
        return ImmutableSet.construct(EArray.length, (Object[])EArray.clone());
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, object);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public ImmutableList<E> asList() {
        ImmutableList<E> immutableList = this.asList;
        return immutableList == null ? (this.asList = this.createAsList()) : immutableList;
    }

    ImmutableList<E> createAsList() {
        return ImmutableList.asImmutableList(this.toArray());
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static class Builder<E>
    extends ImmutableCollection.ArrayBasedBuilder<E> {
        Object[] hashTable;
        private int hashCode;

        public Builder() {
            super(4);
        }

        @Override
        public Builder<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) <= this.hashTable.length) {
                this.addDeduping(e);
                return this;
            }
            this.hashTable = null;
            super.add((Object)e);
            return this;
        }

        @Override
        public Builder<E> add(E ... EArray) {
            if (this.hashTable != null) {
                for (E e : EArray) {
                    this.add((Object)e);
                }
            } else {
                super.add(EArray);
            }
            return this;
        }

        private void addDeduping(E e) {
            int n = this.hashTable.length - 1;
            int n2 = e.hashCode();
            int n3 = Hashing.smear(n2);
            while (true) {
                Object object;
                if ((object = this.hashTable[n3 &= n]) == null) {
                    this.hashTable[n3] = e;
                    this.hashCode += n2;
                    super.add((Object)e);
                    return;
                }
                if (object.equals(e)) {
                    return;
                }
                ++n3;
            }
        }

        public ImmutableSet<E> build() {
            RegularImmutableSet regularImmutableSet;
            switch (this.size) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(this.contents[0]);
                }
            }
            if (this.hashTable != null && ImmutableSet.chooseTableSize(this.size) == this.hashTable.length) {
                Object[] objectArray = ImmutableSet.shouldTrim(this.size, this.contents.length) ? Arrays.copyOf(this.contents, this.size) : this.contents;
                regularImmutableSet = new RegularImmutableSet(objectArray, this.hashCode, this.hashTable, this.hashTable.length - 1, this.size);
            } else {
                regularImmutableSet = ImmutableSet.construct(this.size, this.contents);
                this.size = ((AbstractCollection)regularImmutableSet).size();
            }
            this.forceCopy = true;
            this.hashTable = null;
            return regularImmutableSet;
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        SerializedForm(Object[] objectArray) {
            this.elements = objectArray;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }
}

