/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.collect;

import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Predicate;
import androidx.test.espresso.web.internal.deps.guava.collect.FluentIterable;
import androidx.test.espresso.web.internal.deps.guava.collect.Iterators;
import androidx.test.espresso.web.internal.deps.guava.collect.Lists;
import androidx.test.espresso.web.internal.deps.guava.collect.ObjectArrays;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class Iterables {
    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> clazz) {
        return Iterables.toArray(iterable, ObjectArrays.newArray(clazz, 0));
    }

    static <T> T[] toArray(Iterable<? extends T> iterable, T[] TArray) {
        Collection<T> collection = Iterables.castOrCopyToCollection(iterable);
        return collection.toArray(TArray);
    }

    private static <E> Collection<E> castOrCopyToCollection(Iterable<E> iterable) {
        return iterable instanceof Collection ? (ArrayList<E>)iterable : Lists.newArrayList(iterable.iterator());
    }

    public static <T> Iterable<T> filter(final Iterable<T> iterable, final Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(predicate);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(iterable.iterator(), predicate);
            }
        };
    }

    public static <F, T> Iterable<T> transform(final Iterable<F> iterable, final Function<? super F, ? extends T> function) {
        Preconditions.checkNotNull(iterable);
        Preconditions.checkNotNull(function);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(iterable.iterator(), function);
            }
        };
    }
}

