/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.MoreExecutors;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Platform;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

abstract class AbstractCatchingFuture<V, X extends Throwable, F, T>
extends AbstractFuture.TrustedFuture<V>
implements Runnable {
    ListenableFuture<? extends V> inputFuture;
    Class<X> exceptionType;
    F fallback;

    static <V, X extends Throwable> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        CatchingFuture<? extends V, ? super X> catchingFuture = new CatchingFuture<V, X>(listenableFuture, clazz, function);
        listenableFuture.addListener(catchingFuture, MoreExecutors.rejectionPropagatingExecutor(executor, catchingFuture));
        return catchingFuture;
    }

    static <X extends Throwable, V> ListenableFuture<V> create(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        AsyncCatchingFuture<? extends V, ? super X> asyncCatchingFuture = new AsyncCatchingFuture<V, X>(listenableFuture, clazz, asyncFunction);
        listenableFuture.addListener(asyncCatchingFuture, MoreExecutors.rejectionPropagatingExecutor(executor, asyncCatchingFuture));
        return asyncCatchingFuture;
    }

    AbstractCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, F f) {
        this.inputFuture = Preconditions.checkNotNull(listenableFuture);
        this.exceptionType = Preconditions.checkNotNull(clazz);
        this.fallback = Preconditions.checkNotNull(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        T t;
        F f;
        Class<X> clazz;
        ListenableFuture<? extends V> listenableFuture = this.inputFuture;
        if (listenableFuture == null | (clazz = this.exceptionType) == null | (f = this.fallback) == null | this.isCancelled()) {
            return;
        }
        this.inputFuture = null;
        Object v = null;
        Throwable throwable = null;
        try {
            v = Futures.getDone(listenableFuture);
        }
        catch (ExecutionException executionException) {
            throwable = Preconditions.checkNotNull(executionException.getCause());
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable == null) {
            this.set(v);
            return;
        }
        if (!Platform.isInstanceOfThrowableClass(throwable, clazz)) {
            this.setException(throwable);
            return;
        }
        Throwable throwable3 = throwable;
        try {
            t = this.doFallback(f, throwable3);
        }
        catch (Throwable throwable4) {
            this.setException(throwable4);
            return;
        }
        finally {
            this.exceptionType = null;
            this.fallback = null;
        }
        this.setResult(t);
    }

    @Override
    protected String pendingToString() {
        String string;
        ListenableFuture<? extends V> listenableFuture = this.inputFuture;
        Class<X> clazz = this.exceptionType;
        F f = this.fallback;
        String string2 = super.pendingToString();
        String string3 = "";
        if (listenableFuture != null) {
            string = String.valueOf(listenableFuture);
            string3 = new StringBuilder(16 + String.valueOf(string).length()).append("inputFuture=[").append(string).append("], ").toString();
        }
        if (clazz != null && f != null) {
            string = string3;
            String string4 = String.valueOf(clazz);
            String string5 = String.valueOf(f);
            return new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string).append("exceptionType=[").append(string4).append("], fallback=[").append(string5).append("]").toString();
        }
        if (string2 != null) {
            String string6 = String.valueOf(string3);
            String string7 = String.valueOf(string2);
            return string7.length() != 0 ? string6.concat(string7) : new String(string6);
        }
        return null;
    }

    abstract T doFallback(F var1, X var2) throws Exception;

    abstract void setResult(T var1);

    @Override
    protected final void afterDone() {
        this.maybePropagateCancellationTo(this.inputFuture);
        this.inputFuture = null;
        this.exceptionType = null;
        this.fallback = null;
    }

    private static final class CatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, Function<? super X, ? extends V>, V> {
        CatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function) {
            super(listenableFuture, clazz, function);
        }

        @Override
        V doFallback(Function<? super X, ? extends V> function, X x) throws Exception {
            return function.apply(x);
        }

        @Override
        void setResult(V v) {
            this.set(v);
        }
    }

    private static final class AsyncCatchingFuture<V, X extends Throwable>
    extends AbstractCatchingFuture<V, X, AsyncFunction<? super X, ? extends V>, ListenableFuture<? extends V>> {
        AsyncCatchingFuture(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction) {
            super(listenableFuture, clazz, asyncFunction);
        }

        @Override
        ListenableFuture<? extends V> doFallback(AsyncFunction<? super X, ? extends V> asyncFunction, X x) throws Exception {
            ListenableFuture<? extends V> listenableFuture = asyncFunction.apply(x);
            Preconditions.checkNotNull(listenableFuture, "AsyncFunction.apply returned null instead of a Future. Did you mean to return immediateFuture(null)?");
            return listenableFuture;
        }

        @Override
        void setResult(ListenableFuture<? extends V> listenableFuture) {
            this.setFuture(listenableFuture);
        }
    }
}

