/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ForwardingFluentFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.FutureCallback;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Futures;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.GwtFluentFutureCatchingSpecialization;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public abstract class FluentFuture<V>
extends GwtFluentFutureCatchingSpecialization<V> {
    FluentFuture() {
    }

    public static <V> FluentFuture<V> from(ListenableFuture<V> listenableFuture) {
        return listenableFuture instanceof FluentFuture ? (FluentFuture<V>)listenableFuture : new ForwardingFluentFuture<V>(listenableFuture);
    }

    public final <X extends Throwable> FluentFuture<V> catching(Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        return (FluentFuture)Futures.catching(this, clazz, function, executor);
    }

    public final <X extends Throwable> FluentFuture<V> catchingAsync(Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        return (FluentFuture)Futures.catchingAsync(this, clazz, asyncFunction, executor);
    }

    public final FluentFuture<V> withTimeout(long l, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        return (FluentFuture)Futures.withTimeout(this, l, timeUnit, scheduledExecutorService);
    }

    public final <T> FluentFuture<T> transformAsync(AsyncFunction<? super V, T> asyncFunction, Executor executor) {
        return (FluentFuture)Futures.transformAsync(this, asyncFunction, executor);
    }

    public final <T> FluentFuture<T> transform(Function<? super V, T> function, Executor executor) {
        return (FluentFuture)Futures.transform(this, function, executor);
    }

    public final void addCallback(FutureCallback<? super V> futureCallback, Executor executor) {
        Futures.addCallback(this, futureCallback, executor);
    }
}

