/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.base.Function;
import androidx.test.espresso.web.internal.deps.guava.base.MoreObjects;
import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractCatchingFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractTransformFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AsyncFunction;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.FutureCallback;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.GwtFuturesCatchingSpecialization;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ImmediateFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.TimeoutFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.Uninterruptibles;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class Futures
extends GwtFuturesCatchingSpecialization {
    public static <V> ListenableFuture<V> immediateFuture(V v) {
        if (v == null) {
            ImmediateFuture.ImmediateSuccessfulFuture<Object> immediateSuccessfulFuture = ImmediateFuture.ImmediateSuccessfulFuture.NULL;
            return immediateSuccessfulFuture;
        }
        return new ImmediateFuture.ImmediateSuccessfulFuture<V>(v);
    }

    public static <V> ListenableFuture<V> immediateFailedFuture(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        return new ImmediateFuture.ImmediateFailedFuture(throwable);
    }

    public static <V, X extends Throwable> ListenableFuture<V> catching(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, Function<? super X, ? extends V> function, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, function, executor);
    }

    public static <V, X extends Throwable> ListenableFuture<V> catchingAsync(ListenableFuture<? extends V> listenableFuture, Class<X> clazz, AsyncFunction<? super X, ? extends V> asyncFunction, Executor executor) {
        return AbstractCatchingFuture.create(listenableFuture, clazz, asyncFunction, executor);
    }

    public static <V> ListenableFuture<V> withTimeout(ListenableFuture<V> listenableFuture, long l, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        return TimeoutFuture.create(listenableFuture, l, timeUnit, scheduledExecutorService);
    }

    public static <I, O> ListenableFuture<O> transformAsync(ListenableFuture<I> listenableFuture, AsyncFunction<? super I, ? extends O> asyncFunction, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, asyncFunction, executor);
    }

    public static <I, O> ListenableFuture<O> transform(ListenableFuture<I> listenableFuture, Function<? super I, ? extends O> function, Executor executor) {
        return AbstractTransformFuture.create(listenableFuture, function, executor);
    }

    public static <V> void addCallback(ListenableFuture<V> listenableFuture, FutureCallback<? super V> futureCallback, Executor executor) {
        Preconditions.checkNotNull(futureCallback);
        listenableFuture.addListener(new CallbackListener<V>(listenableFuture, futureCallback), executor);
    }

    public static <V> V getDone(Future<V> future) throws ExecutionException {
        Preconditions.checkState(future.isDone(), "Future was expected to be done: %s", future);
        return Uninterruptibles.getUninterruptibly(future);
    }

    private static final class CallbackListener<V>
    implements Runnable {
        final Future<V> future;
        final FutureCallback<? super V> callback;

        CallbackListener(Future<V> future, FutureCallback<? super V> futureCallback) {
            this.future = future;
            this.callback = futureCallback;
        }

        @Override
        public void run() {
            V v;
            try {
                v = Futures.getDone(this.future);
            }
            catch (ExecutionException executionException) {
                this.callback.onFailure(executionException.getCause());
                return;
            }
            catch (Error | RuntimeException throwable) {
                this.callback.onFailure(throwable);
                return;
            }
            this.callback.onSuccess(v);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).addValue(this.callback).toString();
        }
    }
}

