/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import java.util.concurrent.atomic.AtomicReference;

abstract class InterruptibleTask<T>
extends AtomicReference<Runnable>
implements Runnable {
    private static final Runnable DONE = new DoNothingRunnable();
    private static final Runnable INTERRUPTING = new DoNothingRunnable();

    InterruptibleTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Thread thread = Thread.currentThread();
        if (!this.compareAndSet(null, thread)) {
            return;
        }
        boolean bl = !this.isDone();
        T t = null;
        Throwable throwable = null;
        try {
            if (bl) {
                t = this.runInterruptibly();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            if (!this.compareAndSet(thread, DONE)) {
                while (this.get() == INTERRUPTING) {
                    Thread.yield();
                }
            }
            if (bl) {
                this.afterRanInterruptibly(t, throwable);
            }
        }
    }

    abstract boolean isDone();

    abstract T runInterruptibly() throws Exception;

    abstract void afterRanInterruptibly(T var1, Throwable var2);

    final void interruptTask() {
        Runnable runnable = (Runnable)this.get();
        if (runnable instanceof Thread && this.compareAndSet(runnable, INTERRUPTING)) {
            ((Thread)runnable).interrupt();
            this.set(DONE);
        }
    }

    @Override
    public final String toString() {
        String string;
        String string2;
        Runnable runnable = (Runnable)this.get();
        if (runnable == DONE) {
            string2 = "running=[DONE]";
        } else if (runnable == INTERRUPTING) {
            string2 = "running=[INTERRUPTED]";
        } else if (runnable instanceof Thread) {
            string = ((Thread)runnable).getName();
            string2 = new StringBuilder(21 + String.valueOf(string).length()).append("running=[RUNNING ON ").append(string).append("]").toString();
        } else {
            string2 = "running=[NOT STARTED YET]";
        }
        string = this.toPendingString();
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string).length()).append(string2).append(", ").append(string).toString();
    }

    abstract String toPendingString();

    private static final class DoNothingRunnable
    implements Runnable {
        private DoNothingRunnable() {
        }

        @Override
        public void run() {
        }
    }
}

