/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.base.Throwables;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractListeningExecutorService;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ForwardingListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableScheduledFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListeningExecutorService;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListeningScheduledExecutorService;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.TrustedListenableFutureTask;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class MoreExecutors {
    public static Executor directExecutor() {
        return DirectExecutor.INSTANCE;
    }

    public static ListeningExecutorService listeningDecorator(ExecutorService executorService) {
        return executorService instanceof ListeningExecutorService ? (ListeningExecutorService)executorService : (executorService instanceof ScheduledExecutorService ? new ScheduledListeningDecorator((ScheduledExecutorService)executorService) : new ListeningDecorator(executorService));
    }

    static Executor rejectionPropagatingExecutor(final Executor executor, final AbstractFuture<?> abstractFuture) {
        Preconditions.checkNotNull(executor);
        Preconditions.checkNotNull(abstractFuture);
        if (executor == MoreExecutors.directExecutor()) {
            return executor;
        }
        return new Executor(){
            boolean thrownFromDelegate = true;

            @Override
            public void execute(final Runnable runnable) {
                block2: {
                    try {
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                thrownFromDelegate = false;
                                runnable.run();
                            }
                        });
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        if (!this.thrownFromDelegate) break block2;
                        abstractFuture.setException(rejectedExecutionException);
                    }
                }
            }
        };
    }

    private static final class ScheduledListeningDecorator
    extends ListeningDecorator
    implements ListeningScheduledExecutorService {
        final ScheduledExecutorService delegate;

        ScheduledListeningDecorator(ScheduledExecutorService scheduledExecutorService) {
            super(scheduledExecutorService);
            this.delegate = Preconditions.checkNotNull(scheduledExecutorService);
        }

        public ListenableScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
            TrustedListenableFutureTask<Object> trustedListenableFutureTask = TrustedListenableFutureTask.create(runnable, null);
            ScheduledFuture<?> scheduledFuture = this.delegate.schedule(trustedListenableFutureTask, l, timeUnit);
            return new ListenableScheduledTask<Object>(trustedListenableFutureTask, scheduledFuture);
        }

        public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long l, TimeUnit timeUnit) {
            TrustedListenableFutureTask<V> trustedListenableFutureTask = TrustedListenableFutureTask.create(callable);
            ScheduledFuture<?> scheduledFuture = this.delegate.schedule(trustedListenableFutureTask, l, timeUnit);
            return new ListenableScheduledTask<V>(trustedListenableFutureTask, scheduledFuture);
        }

        public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask(runnable);
            ScheduledFuture<?> scheduledFuture = this.delegate.scheduleAtFixedRate(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            return new ListenableScheduledTask<Void>(neverSuccessfulListenableFutureTask, scheduledFuture);
        }

        public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long l, long l2, TimeUnit timeUnit) {
            NeverSuccessfulListenableFutureTask neverSuccessfulListenableFutureTask = new NeverSuccessfulListenableFutureTask(runnable);
            ScheduledFuture<?> scheduledFuture = this.delegate.scheduleWithFixedDelay(neverSuccessfulListenableFutureTask, l, l2, timeUnit);
            return new ListenableScheduledTask<Void>(neverSuccessfulListenableFutureTask, scheduledFuture);
        }

        private static final class NeverSuccessfulListenableFutureTask
        extends AbstractFuture<Void>
        implements Runnable {
            private final Runnable delegate;

            public NeverSuccessfulListenableFutureTask(Runnable runnable) {
                this.delegate = Preconditions.checkNotNull(runnable);
            }

            @Override
            public void run() {
                try {
                    this.delegate.run();
                }
                catch (Throwable throwable) {
                    this.setException(throwable);
                    throw Throwables.propagate(throwable);
                }
            }
        }

        private static final class ListenableScheduledTask<V>
        extends ForwardingListenableFuture.SimpleForwardingListenableFuture<V>
        implements ListenableScheduledFuture<V> {
            private final ScheduledFuture<?> scheduledDelegate;

            public ListenableScheduledTask(ListenableFuture<V> listenableFuture, ScheduledFuture<?> scheduledFuture) {
                super(listenableFuture);
                this.scheduledDelegate = scheduledFuture;
            }

            @Override
            public boolean cancel(boolean bl) {
                boolean bl2 = super.cancel(bl);
                if (bl2) {
                    this.scheduledDelegate.cancel(bl);
                }
                return bl2;
            }

            @Override
            public long getDelay(TimeUnit timeUnit) {
                return this.scheduledDelegate.getDelay(timeUnit);
            }

            @Override
            public int compareTo(Delayed delayed) {
                return this.scheduledDelegate.compareTo(delayed);
            }
        }
    }

    private static class ListeningDecorator
    extends AbstractListeningExecutorService {
        private final ExecutorService delegate;

        ListeningDecorator(ExecutorService executorService) {
            this.delegate = Preconditions.checkNotNull(executorService);
        }

        @Override
        public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.delegate.awaitTermination(l, timeUnit);
        }

        @Override
        public final boolean isShutdown() {
            return this.delegate.isShutdown();
        }

        @Override
        public final boolean isTerminated() {
            return this.delegate.isTerminated();
        }

        @Override
        public final void shutdown() {
            this.delegate.shutdown();
        }

        @Override
        public final List<Runnable> shutdownNow() {
            return this.delegate.shutdownNow();
        }

        @Override
        public final void execute(Runnable runnable) {
            this.delegate.execute(runnable);
        }
    }

    private static final class DirectExecutor
    extends Enum<DirectExecutor>
    implements Executor {
        public static final /* enum */ DirectExecutor INSTANCE = new DirectExecutor();
        private static final /* synthetic */ DirectExecutor[] $VALUES;

        public static DirectExecutor[] values() {
            return (DirectExecutor[])$VALUES.clone();
        }

        @Override
        public void execute(Runnable runnable) {
            runnable.run();
        }

        public String toString() {
            return "MoreExecutors.directExecutor()";
        }

        static {
            $VALUES = new DirectExecutor[]{INSTANCE};
        }
    }
}

