/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ThreadFactoryBuilder {
    private String nameFormat = null;
    private Boolean daemon = null;
    private Integer priority = null;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;
    private ThreadFactory backingThreadFactory = null;

    public ThreadFactoryBuilder setNameFormat(String string) {
        String string2 = ThreadFactoryBuilder.format(string, 0);
        this.nameFormat = string;
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.doBuild(this);
    }

    private static ThreadFactory doBuild(ThreadFactoryBuilder threadFactoryBuilder) {
        final String string = threadFactoryBuilder.nameFormat;
        final Boolean bl = threadFactoryBuilder.daemon;
        final Integer n = threadFactoryBuilder.priority;
        final Thread.UncaughtExceptionHandler uncaughtExceptionHandler = threadFactoryBuilder.uncaughtExceptionHandler;
        final ThreadFactory threadFactory = threadFactoryBuilder.backingThreadFactory != null ? threadFactoryBuilder.backingThreadFactory : Executors.defaultThreadFactory();
        final AtomicLong atomicLong = string != null ? new AtomicLong(0L) : null;
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = threadFactory.newThread(runnable);
                if (string != null) {
                    thread.setName(ThreadFactoryBuilder.format(string, new Object[]{atomicLong.getAndIncrement()}));
                }
                if (bl != null) {
                    thread.setDaemon(bl);
                }
                if (n != null) {
                    thread.setPriority(n);
                }
                if (uncaughtExceptionHandler != null) {
                    thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
                }
                return thread;
            }
        };
    }

    private static String format(String string, Object ... objectArray) {
        return String.format(Locale.ROOT, string, objectArray);
    }
}

