/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.internal.deps.guava.util.concurrent;

import androidx.test.espresso.web.internal.deps.guava.base.Preconditions;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.AbstractFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.ListenableFuture;
import androidx.test.espresso.web.internal.deps.guava.util.concurrent.MoreExecutors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class TimeoutFuture<V>
extends AbstractFuture.TrustedFuture<V> {
    private ListenableFuture<V> delegateRef;
    private Future<?> timer;

    static <V> ListenableFuture<V> create(ListenableFuture<V> listenableFuture, long l, TimeUnit timeUnit, ScheduledExecutorService scheduledExecutorService) {
        TimeoutFuture<V> timeoutFuture = new TimeoutFuture<V>(listenableFuture);
        Fire<V> fire = new Fire<V>(timeoutFuture);
        timeoutFuture.timer = scheduledExecutorService.schedule(fire, l, timeUnit);
        listenableFuture.addListener(fire, MoreExecutors.directExecutor());
        return timeoutFuture;
    }

    private TimeoutFuture(ListenableFuture<V> listenableFuture) {
        this.delegateRef = Preconditions.checkNotNull(listenableFuture);
    }

    @Override
    protected String pendingToString() {
        ListenableFuture<V> listenableFuture = this.delegateRef;
        if (listenableFuture != null) {
            String string = String.valueOf(listenableFuture);
            return new StringBuilder(14 + String.valueOf(string).length()).append("inputFuture=[").append(string).append("]").toString();
        }
        return null;
    }

    @Override
    protected void afterDone() {
        this.maybePropagateCancellationTo(this.delegateRef);
        Future<?> future = this.timer;
        if (future != null) {
            future.cancel(false);
        }
        this.delegateRef = null;
        this.timer = null;
    }

    private static final class Fire<V>
    implements Runnable {
        TimeoutFuture<V> timeoutFutureRef;

        Fire(TimeoutFuture<V> timeoutFuture) {
            this.timeoutFutureRef = timeoutFuture;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TimeoutFuture<V> timeoutFuture = this.timeoutFutureRef;
            if (timeoutFuture == null) {
                return;
            }
            ListenableFuture listenableFuture = ((TimeoutFuture)timeoutFuture).delegateRef;
            if (listenableFuture == null) {
                return;
            }
            this.timeoutFutureRef = null;
            if (listenableFuture.isDone()) {
                timeoutFuture.setFuture(listenableFuture);
            } else {
                try {
                    String string = String.valueOf(listenableFuture);
                    timeoutFuture.setException(new TimeoutException(new StringBuilder(18 + String.valueOf(string).length()).append("Future timed out: ").append(string).toString()));
                }
                finally {
                    listenableFuture.cancel(true);
                }
            }
        }
    }
}

